/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.service;

import java.util.ArrayList;
import javax.management.MBeanServer;
import org.jboss.as.jmx.MBeanServerService;
import org.jboss.as.osgi.parser.SubsystemState;
import org.jboss.as.osgi.service.BundleManagerService;
import org.jboss.logging.Logger;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoader;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceNotFoundException;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.deployment.deployer.SystemDeployerService;
import org.jboss.osgi.framework.bundle.AbstractBundle;
import org.jboss.osgi.framework.bundle.BundleManager;
import org.jboss.osgi.framework.plugin.BundleDeploymentPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.launch.Framework;

public class FrameworkService
implements Service<Framework> {
    public static final ServiceName SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"osgi", "framework"});
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.osgi");
    private final InjectedValue<BundleManager> injectedBundleManager = new InjectedValue();
    private final InjectedValue<MBeanServer> injectedMBeanServer = new InjectedValue();
    private final SubsystemState subsystemState;
    private Framework framework;

    private FrameworkService(SubsystemState subsystemState) {
        this.subsystemState = subsystemState;
    }

    public static void addService(ServiceTarget target, SubsystemState subsystemState) {
        FrameworkService service = new FrameworkService(subsystemState);
        ServiceBuilder serviceBuilder = target.addService(SERVICE_NAME, (Service)service);
        serviceBuilder.addDependency(BundleManagerService.SERVICE_NAME, BundleManager.class, service.injectedBundleManager);
        serviceBuilder.addDependency(MBeanServerService.SERVICE_NAME, MBeanServer.class, service.injectedMBeanServer);
        serviceBuilder.setInitialMode(ServiceController.Mode.ON_DEMAND);
        serviceBuilder.install();
    }

    public static Framework getServiceValue(ServiceContainer container) {
        try {
            ServiceController controller = container.getRequiredService(SERVICE_NAME);
            return (Framework)controller.getValue();
        }
        catch (ServiceNotFoundException ex) {
            throw new IllegalStateException("Cannot obtain required service: " + SERVICE_NAME);
        }
    }

    public synchronized void start(StartContext context) throws StartException {
        log.infof("Starting OSGi Framework", new Object[0]);
        try {
            final BundleManager bundleManager = (BundleManager)this.injectedBundleManager.getValue();
            this.framework = bundleManager.getFrameworkState();
            this.framework.start();
            BundleContext sysContext = this.framework.getBundleContext();
            MBeanServer mbeanServer = (MBeanServer)this.injectedMBeanServer.getValue();
            sysContext.registerService(MBeanServer.class.getName(), (Object)mbeanServer, null);
            ServiceContainer serviceContainer = context.getController().getServiceContainer();
            sysContext.registerService(ServiceContainer.class.getName(), (Object)serviceContainer, null);
            ArrayList<Deployment> deployments = new ArrayList<Deployment>();
            BundleDeploymentPlugin depPlugin = (BundleDeploymentPlugin)bundleManager.getPlugin(BundleDeploymentPlugin.class);
            for (SubsystemState.OSGiModule moduleMetaData : this.subsystemState.getModules()) {
                ModuleIdentifier identifier = moduleMetaData.getIdentifier();
                ModuleLoader moduleLoader = Module.getSystemModuleLoader();
                Module module = moduleLoader.loadModule(identifier);
                Deployment dep = depPlugin.createDeployment(module);
                dep.setAutoStart(moduleMetaData.isStart());
                deployments.add(dep);
            }
            SystemDeployerService service = new SystemDeployerService(sysContext){

                protected Bundle installBundle(Deployment dep) throws BundleException {
                    AbstractBundle bundleState = bundleManager.installBundle(dep);
                    return bundleState.getBundleWrapper();
                }
            };
            service.deploy(deployments.toArray(new Deployment[deployments.size()]));
        }
        catch (Throwable t) {
            throw new StartException("Failed to start OSGi Framework: " + this.framework, t);
        }
    }

    public synchronized void stop(StopContext context) {
        log.infof("Stopping OSGi Framework", new Object[0]);
        if (this.framework != null) {
            try {
                this.framework.stop();
                this.framework.waitForStop(2000L);
            }
            catch (Exception ex) {
                log.errorf((Throwable)ex, "Cannot stop OSGi Framework", new Object[0]);
            }
        }
    }

    public Framework getValue() throws IllegalStateException {
        return this.framework;
    }
}

