/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.parser;

import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.jboss.as.controller.AbstractBoottimeAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.osgi.OSGiLogger;
import org.jboss.as.osgi.deployment.BundleStartTracker;
import org.jboss.as.osgi.deployment.OSGiDeploymentActivator;
import org.jboss.as.osgi.parser.OSGiSubsystemProviders;
import org.jboss.as.osgi.parser.SubsystemState;
import org.jboss.as.osgi.service.BundleInstallProviderIntegration;
import org.jboss.as.osgi.service.ConfigAdminServiceImpl;
import org.jboss.as.osgi.service.FrameworkBootstrapService;
import org.jboss.as.server.AbstractDeploymentChainStep;
import org.jboss.as.server.DeploymentProcessorTarget;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceTarget;

class OSGiSubsystemAdd
extends AbstractBoottimeAddStepHandler
implements DescriptionProvider {
    static final SubsystemState.Activation DEFAULT_ACTIVATION = SubsystemState.Activation.LAZY;
    static final OSGiSubsystemAdd INSTANCE = new OSGiSubsystemAdd();

    private OSGiSubsystemAdd() {
    }

    protected void populateModel(ModelNode operation, ModelNode subModel) {
        if (operation.has("activation")) {
            subModel.get("activation").set(operation.get("activation"));
        }
    }

    protected void performBoottime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) {
        OSGiLogger.ROOT_LOGGER.activatingSubsystem();
        context.addStep((OperationStepHandler)new AbstractDeploymentChainStep(){

            protected void execute(DeploymentProcessorTarget processorTarget) {
                new OSGiDeploymentActivator().activate(processorTarget);
            }
        }, OperationContext.Stage.RUNTIME);
        long begin = System.currentTimeMillis();
        ServiceTarget serviceTarget = context.getServiceTarget();
        newControllers.add(SubsystemState.addService(serviceTarget, this.getActivationMode(operation)));
        newControllers.add(BundleStartTracker.addService(serviceTarget));
        newControllers.add(BundleInstallProviderIntegration.addService(serviceTarget));
        newControllers.addAll(FrameworkBootstrapService.addService(serviceTarget, new ServiceListener[]{verificationHandler}));
        newControllers.add(ConfigAdminServiceImpl.addService(serviceTarget, new ServiceListener[]{verificationHandler}));
        long end = System.currentTimeMillis();
        OSGiLogger.ROOT_LOGGER.debugf("Activated OSGi Subsystem in %dms", end - begin);
    }

    public ModelNode getModelDescription(Locale locale) {
        ResourceBundle resourceBundle = OSGiSubsystemProviders.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("operation-name").set("add");
        node.get("description").set(resourceBundle.getString("osgi.add"));
        OSGiSubsystemAdd.addModelProperties(resourceBundle, node, "request-properties");
        node.get("reply-properties").setEmptyObject();
        return node;
    }

    static void addModelProperties(ResourceBundle bundle2, ModelNode node, String propType) {
        node.get(new String[]{propType, "activation", "description"}).set(bundle2.getString("activation"));
        node.get(new String[]{propType, "activation", "type"}).set(ModelType.STRING);
        node.get(new String[]{propType, "activation", "default"}).set(DEFAULT_ACTIVATION.toString());
    }

    private SubsystemState.Activation getActivationMode(ModelNode operation) {
        SubsystemState.Activation activation = DEFAULT_ACTIVATION;
        if (operation.has("activation")) {
            activation = SubsystemState.Activation.valueOf(operation.get("activation").asString().toUpperCase());
        }
        return activation;
    }
}

