/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.service;

import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.Observable;
import java.util.Observer;
import java.util.concurrent.atomic.AtomicLong;
import org.jboss.as.osgi.OSGiLogger;
import org.jboss.as.osgi.OSGiMessages;
import org.jboss.as.osgi.parser.SubsystemState;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.as.server.ServerEnvironmentService;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoader;
import org.jboss.msc.service.AbstractService;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.value.InjectedValue;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.deployment.deployer.DeploymentFactory;
import org.jboss.osgi.framework.AutoInstallProvider;
import org.jboss.osgi.framework.BundleManagerService;
import org.jboss.osgi.framework.Services;
import org.jboss.osgi.metadata.OSGiMetaData;
import org.jboss.osgi.metadata.OSGiMetaDataBuilder;
import org.jboss.osgi.spi.util.BundleInfo;
import org.jboss.osgi.vfs.AbstractVFS;
import org.jboss.osgi.vfs.VirtualFile;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.service.startlevel.StartLevel;

class AutoInstallIntegration
extends AbstractService<AutoInstallProvider>
implements AutoInstallProvider,
Observer {
    final InjectedValue<BundleManagerService> injectedBundleManager = new InjectedValue();
    final InjectedValue<ServerEnvironment> injectedEnvironment = new InjectedValue();
    final InjectedValue<Bundle> injectedSystemBundle = new InjectedValue();
    final InjectedValue<StartLevel> injectedStartLevel = new InjectedValue();
    final InjectedValue<SubsystemState> injectedSubsystemState = new InjectedValue();
    ServiceController<?> serviceController;
    private File modulesDir;
    private File bundlesDir;
    private ServiceTarget serviceTarget;
    private final AtomicLong updateServiceIdCounter = new AtomicLong();

    static ServiceController<?> addService(ServiceTarget target) {
        AutoInstallIntegration service = new AutoInstallIntegration();
        ServiceBuilder builder = target.addService(Services.AUTOINSTALL_PROVIDER, (Service)service);
        builder.addDependency(ServerEnvironmentService.SERVICE_NAME, ServerEnvironment.class, service.injectedEnvironment);
        builder.addDependency(SubsystemState.SERVICE_NAME, SubsystemState.class, service.injectedSubsystemState);
        builder.addDependency(Services.BUNDLE_MANAGER, BundleManagerService.class, service.injectedBundleManager);
        builder.addDependency(Services.SYSTEM_BUNDLE, Bundle.class, service.injectedSystemBundle);
        builder.addDependency(Services.START_LEVEL, StartLevel.class, service.injectedStartLevel);
        builder.addDependency(Services.FRAMEWORK_INIT);
        builder.setInitialMode(ServiceController.Mode.ON_DEMAND);
        return builder.install();
    }

    AutoInstallIntegration() {
    }

    public synchronized void start(StartContext context) throws StartException {
        this.serviceController = context.getController();
        OSGiLogger.ROOT_LOGGER.debugf("Starting: %s in mode %s", this.serviceController.getName(), this.serviceController.getMode());
        final LinkedHashMap<ServiceName, SubsystemState.OSGiCapability> pendingServices = new LinkedHashMap<ServiceName, SubsystemState.OSGiCapability>();
        try {
            BundleManagerService bundleManager = (BundleManagerService)this.injectedBundleManager.getValue();
            final ServiceContainer serviceContainer = this.serviceController.getServiceContainer();
            this.serviceTarget = context.getChildTarget();
            this.modulesDir = ((ServerEnvironment)this.injectedEnvironment.getValue()).getModulesDir();
            this.bundlesDir = new File(this.modulesDir.getPath() + "/../bundles").getCanonicalFile();
            if (!this.bundlesDir.isDirectory()) {
                throw OSGiMessages.MESSAGES.cannotFindBundleDir(this.bundlesDir);
            }
            ((SubsystemState)this.injectedSubsystemState.getValue()).addObserver(this);
            for (SubsystemState.OSGiCapability moduleMetaData : ((SubsystemState)this.injectedSubsystemState.getValue()).getCapabilities()) {
                ServiceName serviceName = this.installModule(bundleManager, moduleMetaData);
                pendingServices.put(serviceName, moduleMetaData);
            }
            ServiceName servicesInstalled = Services.AUTOINSTALL_PROVIDER.append(new String[]{"INSTALLED"});
            ServiceBuilder builder = this.serviceTarget.addService(servicesInstalled, (Service)new AbstractService<Void>(){

                public void start(StartContext context) throws StartException {
                    OSGiLogger.ROOT_LOGGER.debugf("Auto bundles installed", new Object[0]);
                }
            });
            builder.addDependencies(pendingServices.keySet());
            builder.install();
            builder = this.serviceTarget.addService(Services.AUTOINSTALL_PROVIDER_COMPLETE, (Service)new AbstractService<Void>(){

                public void start(StartContext context) throws StartException {
                    for (ServiceName serviceName : pendingServices.keySet()) {
                        SubsystemState.OSGiCapability moduleMetaData = (SubsystemState.OSGiCapability)pendingServices.get(serviceName);
                        AutoInstallIntegration.this.startBundle(serviceContainer, serviceName, moduleMetaData);
                    }
                    OSGiLogger.ROOT_LOGGER.debugf("Auto bundles bundles started", new Object[0]);
                }
            });
            builder.addDependencies(new ServiceName[]{servicesInstalled});
            builder.install();
        }
        catch (Exception ex) {
            throw new StartException(OSGiMessages.MESSAGES.failedToCreateAutoInstallList(), (Throwable)ex);
        }
    }

    ServiceName installModule(BundleManagerService bundleManager, SubsystemState.OSGiCapability moduleMetaData) throws Exception {
        URL url;
        VirtualFile virtualFile;
        ModuleIdentifier identifier = moduleMetaData.getIdentifier();
        Integer startLevel = moduleMetaData.getStartLevel();
        File modulesFile = this.getRepositoryEntry(this.bundlesDir, identifier);
        if (modulesFile != null) {
            URL url2 = modulesFile.toURI().toURL();
            return this.installBundleFromURL(bundleManager, url2, startLevel);
        }
        modulesFile = this.getRepositoryEntry(this.modulesDir, identifier);
        if (modulesFile != null && BundleInfo.isValidBundle((VirtualFile)(virtualFile = AbstractVFS.toVirtualFile((URL)(url = modulesFile.toURI().toURL()))))) {
            OSGiLogger.ROOT_LOGGER.foundOsgiBundle(modulesFile);
            return this.installBundleFromURL(bundleManager, url, startLevel);
        }
        ModuleLoader moduleLoader = Module.getBootModuleLoader();
        Module module = moduleLoader.loadModule(identifier);
        OSGiMetaData metadata = this.getModuleMetadata(module);
        return bundleManager.registerModule(this.serviceTarget, module, metadata);
    }

    private ServiceName installBundleFromURL(BundleManagerService bundleManager, URL moduleURL, Integer startLevel) throws Exception {
        BundleInfo info = BundleInfo.createBundleInfo((URL)moduleURL);
        Deployment dep = DeploymentFactory.createDeployment((BundleInfo)info);
        if (startLevel != null) {
            dep.setStartLevel(Integer.valueOf(startLevel));
        }
        return bundleManager.installBundle(this.serviceTarget, dep);
    }

    void startBundle(ServiceContainer serviceContainer, ServiceName serviceName, SubsystemState.OSGiCapability moduleMetaData) {
        if (moduleMetaData.getStartLevel() != null) {
            ServiceController controller = serviceContainer.getRequiredService(serviceName);
            Bundle bundle2 = (Bundle)controller.getValue();
            StartLevel startLevel = (StartLevel)this.injectedStartLevel.getValue();
            startLevel.setBundleStartLevel(bundle2, moduleMetaData.getStartLevel().intValue());
            try {
                bundle2.start();
            }
            catch (BundleException ex) {
                OSGiLogger.ROOT_LOGGER.cannotStart(ex, bundle2);
            }
        }
    }

    public synchronized AutoInstallIntegration getValue() throws IllegalStateException {
        return this;
    }

    private File getRepositoryEntry(File rootDir, ModuleIdentifier identifier) throws IOException {
        String identifierPath = identifier.getName().replace('.', '/') + "/" + identifier.getSlot();
        File entryDir = new File(rootDir + "/" + identifierPath);
        if (!entryDir.isDirectory()) {
            OSGiLogger.ROOT_LOGGER.debugf("Cannot obtain directory: %s", entryDir);
            return null;
        }
        String[] files = entryDir.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".jar");
            }
        });
        if (files.length == 0) {
            OSGiLogger.ROOT_LOGGER.debugf("Cannot find jar in: %s", entryDir);
            return null;
        }
        if (files.length > 1) {
            OSGiLogger.ROOT_LOGGER.debugf("Multiple jars in: %s", entryDir);
            return null;
        }
        File entryFile = new File(entryDir + "/" + files[0]);
        if (!entryFile.exists()) {
            OSGiLogger.ROOT_LOGGER.debugf("File does not exist: %s", entryFile);
            return null;
        }
        return entryFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OSGiMetaData getModuleMetadata(Module module) throws IOException {
        File modulesDir = ((ServerEnvironment)this.injectedEnvironment.getValue()).getModulesDir();
        ModuleIdentifier identifier = module.getIdentifier();
        String identifierPath = identifier.getName().replace('.', '/') + "/" + identifier.getSlot();
        File entryFile = new File(modulesDir + "/" + identifierPath + "/jbosgi-xservice.properties");
        if (!entryFile.exists()) {
            OSGiLogger.ROOT_LOGGER.debugf("Cannot obtain OSGi metadata file: %s", entryFile);
            return null;
        }
        FileInputStream input = new FileInputStream(entryFile);
        try {
            OSGiMetaData oSGiMetaData = OSGiMetaDataBuilder.load((InputStream)input);
            return oSGiMetaData;
        }
        finally {
            input.close();
        }
    }

    @Override
    public void update(Observable o, Object arg) {
        if (!(arg instanceof SubsystemState.ChangeEvent)) {
            return;
        }
        SubsystemState.ChangeEvent event = (SubsystemState.ChangeEvent)arg;
        if (event.getType() != SubsystemState.ChangeType.CAPABILITY) {
            return;
        }
        if (!event.isRemoved()) {
            try {
                for (final SubsystemState.OSGiCapability module : ((SubsystemState)this.injectedSubsystemState.getValue()).getCapabilities()) {
                    if (!module.getIdentifier().toString().equals(event.getId())) continue;
                    final ServiceName serviceName = this.installModule((BundleManagerService)this.injectedBundleManager.getValue(), module);
                    ServiceBuilder builder = this.serviceController.getServiceContainer().addService(ServiceName.of((ServiceName)Services.AUTOINSTALL_PROVIDER, (String[])new String[]{"ModuleUpdater", "" + this.updateServiceIdCounter.incrementAndGet()}), (Service)new AbstractService<Void>(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void start(StartContext context) throws StartException {
                            try {
                                AutoInstallIntegration.this.startBundle(AutoInstallIntegration.this.serviceController.getServiceContainer(), serviceName, module);
                            }
                            finally {
                                context.getController().setMode(ServiceController.Mode.REMOVE);
                            }
                        }
                    });
                    builder.addDependency(serviceName);
                    builder.install();
                    return;
                }
            }
            catch (Exception e) {
                OSGiLogger.ROOT_LOGGER.errorAddingModule(e, event.getId());
                return;
            }
            OSGiLogger.ROOT_LOGGER.moduleNotFound(event.getId());
        }
    }
}

