/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.service;

import java.io.IOException;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.osgi.OSGiLogger;
import org.jboss.as.osgi.parser.SubsystemState;
import org.jboss.as.osgi.service.ConfigAdminListener;
import org.jboss.as.osgi.service.ConfigAdminService;
import org.jboss.as.server.Services;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class ConfigAdminServiceImpl
implements ConfigAdminService {
    private final InjectedValue<SubsystemState> injectedSubsystemState = new InjectedValue();
    private final InjectedValue<ModelController> injectedModelController = new InjectedValue();
    private final Set<ConfigAdminListener> listeners = new CopyOnWriteArraySet<ConfigAdminListener>();
    private final Executor executor = Executors.newSingleThreadExecutor();
    private ModelControllerClient controllerClient;

    private ConfigAdminServiceImpl() {
    }

    public static ServiceController<?> addService(ServiceTarget target, ServiceListener<Object> ... listeners) {
        ConfigAdminServiceImpl service = new ConfigAdminServiceImpl();
        ServiceBuilder builder = target.addService(ConfigAdminService.SERVICE_NAME, (Service)service);
        builder.addDependency(SubsystemState.SERVICE_NAME, SubsystemState.class, service.injectedSubsystemState);
        builder.addDependency(Services.JBOSS_SERVER_CONTROLLER, ModelController.class, service.injectedModelController);
        builder.addListener(listeners);
        return builder.install();
    }

    @Override
    public Set<String> getConfigurations() {
        return ((SubsystemState)this.injectedSubsystemState.getValue()).getConfigurations();
    }

    @Override
    public boolean hasConfiguration(String pid) {
        return ((SubsystemState)this.injectedSubsystemState.getValue()).hasConfiguration(pid);
    }

    @Override
    public Dictionary<String, String> getConfiguration(String pid) {
        return ((SubsystemState)this.injectedSubsystemState.getValue()).getConfiguration(pid);
    }

    @Override
    public Dictionary<String, String> putConfiguration(String pid, Dictionary<String, String> newconfig) {
        ModelNode address = this.getSubsystemAddress();
        address.add(new ModelNode().set("configuration", pid));
        Dictionary<String, String> oldconfig = this.getConfiguration(pid);
        if (oldconfig != null) {
            ModelNode op = Util.getEmptyOperation((String)"remove", (ModelNode)address);
            try {
                this.controllerClient.execute(op);
            }
            catch (IOException ex) {
                OSGiLogger.ROOT_LOGGER.errorf(ex, "Cannot remove configuration for pid: %s", pid);
            }
        }
        ModelNode entries = new ModelNode();
        Enumeration<String> keys = newconfig.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            entries.get(key).set(newconfig.get(key));
        }
        ModelNode op = Util.getEmptyOperation((String)"add", (ModelNode)address);
        op.get("entries").set(entries);
        try {
            ModelNode node = this.controllerClient.execute(op);
            ModelNode outcome = node.get("outcome");
            if ("success".equals(outcome.asString())) {
                this.executor.execute(new ConfigurationModifiedService(pid, newconfig));
            } else {
                OSGiLogger.ROOT_LOGGER.errorf("Cannot add configuration for pid: %s -> %s", pid, node);
            }
        }
        catch (IOException ex) {
            OSGiLogger.ROOT_LOGGER.errorf(ex, "Cannot add configuration for pid: %s", pid);
        }
        return oldconfig;
    }

    @Override
    public Dictionary<String, String> removeConfiguration(String pid) {
        Dictionary<String, String> oldconfig = this.getConfiguration(pid);
        if (oldconfig != null) {
            ModelNode address = this.getSubsystemAddress();
            address.add(new ModelNode().set("configuration", pid));
            ModelNode op = Util.getEmptyOperation((String)"remove", (ModelNode)address);
            try {
                ModelNode node = this.controllerClient.execute(op);
                ModelNode outcome = node.get("outcome");
                if ("success".equals(outcome.asString())) {
                    this.executor.execute(new ConfigurationModifiedService(pid, oldconfig));
                } else {
                    OSGiLogger.ROOT_LOGGER.errorf("Cannot remove configuration for pid: %s -> %s", pid, node);
                }
            }
            catch (IOException ex) {
                OSGiLogger.ROOT_LOGGER.errorf(ex, "Cannot remove configuration for pid: %s", pid);
            }
        }
        return oldconfig;
    }

    public void start(StartContext context) throws StartException {
        ServiceController controller = context.getController();
        OSGiLogger.ROOT_LOGGER.debugf("Starting: %s in mode %s", controller.getName(), controller.getMode());
        ExecutorService executor = Executors.newSingleThreadExecutor();
        this.controllerClient = ((ModelController)this.injectedModelController.getValue()).createClient((Executor)executor);
    }

    public void stop(StopContext context) {
        ServiceController controller = context.getController();
        OSGiLogger.ROOT_LOGGER.debugf("Stopping: %s in mode %s", controller.getName(), controller.getMode());
    }

    public ConfigAdminService getValue() throws IllegalStateException {
        return this;
    }

    @Override
    public void addListener(ConfigAdminListener listener) {
        OSGiLogger.ROOT_LOGGER.debugf("Add listener: %s", listener);
        this.listeners.add(listener);
        Set<String> pids = listener.getPIDs();
        if (pids != null) {
            for (String pid : pids) {
                Dictionary<String, String> props = this.getConfiguration(pid);
                listener.configurationModified(pid, props);
            }
        }
    }

    @Override
    public void removeListener(ConfigAdminListener listener) {
        OSGiLogger.ROOT_LOGGER.debugf("Remove listener: %s", listener);
        this.listeners.remove(listener);
    }

    private ModelNode getSubsystemAddress() {
        ModelNode address = new ModelNode();
        address.add(new ModelNode().set("subsystem", "osgi"));
        return address;
    }

    class ConfigurationModifiedService
    implements Runnable {
        private final String pid;
        private final Dictionary<String, String> props;

        private ConfigurationModifiedService(String pid, Dictionary<String, String> props) {
            this.pid = pid;
            this.props = props;
        }

        @Override
        public void run() {
            OSGiLogger.ROOT_LOGGER.debugf("Updating configuration: %s", this.pid);
            HashSet snapshot = new HashSet(ConfigAdminServiceImpl.this.listeners);
            for (ConfigAdminListener aux : snapshot) {
                Set<String> pids = aux.getPIDs();
                if (pids != null && !pids.contains(this.pid)) continue;
                try {
                    aux.configurationModified(this.pid, this.props);
                }
                catch (Exception ex) {
                    OSGiLogger.ROOT_LOGGER.configurationListenerError(ex, aux);
                }
            }
        }
    }
}

