/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.management;

import java.util.EnumSet;
import java.util.Locale;
import java.util.ResourceBundle;
import org.jboss.as.controller.AbstractRuntimeOnlyHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.common.CommonDescriptions;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.osgi.OSGiLogger;
import org.jboss.as.osgi.OSGiMessages;
import org.jboss.as.osgi.parser.OSGiDescriptionProviders;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.osgi.framework.BundleManager;
import org.jboss.osgi.framework.Services;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.startlevel.StartLevel;

public class BundleResourceHandler
extends AbstractRuntimeOnlyHandler {
    public static final BundleResourceHandler INSTANCE = new BundleResourceHandler();
    static final String[] ATTRIBUTES = new String[]{"id", "location", "startlevel", "state", "symbolic-name", "type", "version"};
    static final String[] OPERATIONS = new String[]{"start", "stop"};

    private BundleResourceHandler() {
    }

    public void register(ManagementResourceRegistration registry) {
        for (String attr : ATTRIBUTES) {
            registry.registerReadOnlyAttribute(attr, (OperationStepHandler)this, AttributeAccess.Storage.RUNTIME);
        }
        for (final String op : OPERATIONS) {
            registry.registerOperationHandler(op, (OperationStepHandler)this, new DescriptionProvider(){

                public ModelNode getModelDescription(Locale locale) {
                    ResourceBundle resourceBundle = OSGiDescriptionProviders.getResourceBundle(locale);
                    return CommonDescriptions.getDescriptionOnlyOperation((ResourceBundle)resourceBundle, (String)op, (String)"bundle");
                }
            }, EnumSet.of(OperationEntry.Flag.RESTART_NONE));
        }
    }

    protected void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
        String operationName = operation.require("operation").asString();
        if ("read-attribute".equals(operationName)) {
            this.handleReadAttributeOperation(context, operation);
        } else {
            this.handleOperation(operationName, context, operation);
        }
    }

    private void handleReadAttributeOperation(OperationContext context, ModelNode operation) {
        String name = operation.require("name").asString();
        if ("id".equals(name)) {
            Bundle bundle2 = this.getTargetBundle(context, operation);
            context.getResult().set(bundle2.getBundleId());
        } else if ("startlevel".equals(name)) {
            StartLevel startLevel = this.getStartLevel(context);
            if (startLevel == null) {
                ModelNode failureDescription = context.getFailureDescription();
                failureDescription.set(OSGiMessages.MESSAGES.startLevelServiceNotAvailable());
            } else {
                Bundle bundle3 = this.getTargetBundle(context, operation);
                Integer level = startLevel.getBundleStartLevel(bundle3);
                context.getResult().set(level.intValue());
            }
        } else if ("state".equals(name)) {
            Bundle bundle4 = this.getTargetBundle(context, operation);
            context.getResult().set(BundleResourceHandler.getBundleState(bundle4));
        } else if ("symbolic-name".equals(name)) {
            Bundle bundle5 = this.getTargetBundle(context, operation);
            context.getResult().set(bundle5.getSymbolicName());
        } else if ("location".equals(name)) {
            Bundle bundle6 = this.getTargetBundle(context, operation);
            context.getResult().set(bundle6.getLocation());
        } else if ("type".equals(name)) {
            Bundle bundle7 = this.getTargetBundle(context, operation);
            if (bundle7.getHeaders().get("Fragment-Host") != null) {
                context.getResult().set("fragment");
            } else {
                context.getResult().set("bundle");
            }
        } else if ("version".equals(name)) {
            Bundle bundle8 = this.getTargetBundle(context, operation);
            context.getResult().set(bundle8.getVersion().toString());
        }
        context.completeStep();
    }

    private void handleOperation(String operationName, OperationContext context, ModelNode operation) {
        block4: {
            try {
                if ("start".equals(operationName)) {
                    Bundle bundle2 = this.getTargetBundle(context, operation);
                    bundle2.start();
                    break block4;
                }
                if ("stop".equals(operationName)) {
                    Bundle bundle3 = this.getTargetBundle(context, operation);
                    bundle3.stop();
                    break block4;
                }
                throw new UnsupportedOperationException(operationName);
            }
            catch (Exception ex) {
                OSGiLogger.LOGGER.errorInOperationHandler(ex, operationName);
                context.getFailureDescription().set(ex.getLocalizedMessage());
            }
        }
        context.completeStep();
    }

    private Bundle getTargetBundle(OperationContext context, ModelNode operation) {
        ModelNode addr = operation.require("address");
        PathAddress pathAddress = PathAddress.pathAddress((ModelNode)addr);
        String value = pathAddress.getLastElement().getValue();
        Bundle bundle2 = null;
        try {
            Long bundleId = Long.parseLong(value);
            bundle2 = this.getSystemContext(context).getBundle(bundleId.longValue());
        }
        catch (NumberFormatException ex) {
            bundle2 = this.getBundleManager(context).getBundleByLocation(value);
        }
        if (bundle2 == null) {
            throw OSGiMessages.MESSAGES.illegalArgumentCannotObtainBundleResource(value);
        }
        return bundle2;
    }

    static String getBundleState(Bundle bundle2) {
        switch (bundle2.getState()) {
            case 1: {
                return "UNINSTALLED";
            }
            case 2: {
                return "INSTALLED";
            }
            case 4: {
                return "RESOLVED";
            }
            case 8: {
                return "STARTING";
            }
            case 16: {
                return "STOPPING";
            }
            case 32: {
                return "ACTIVE";
            }
        }
        return null;
    }

    private BundleManager getBundleManager(OperationContext context) {
        ServiceController controller = context.getServiceRegistry(false).getService(Services.BUNDLE_MANAGER);
        return controller != null ? (BundleManager)controller.getValue() : null;
    }

    private BundleContext getSystemContext(OperationContext context) {
        ServiceController controller = context.getServiceRegistry(false).getService(Services.SYSTEM_CONTEXT);
        return controller != null ? (BundleContext)controller.getValue() : null;
    }

    private StartLevel getStartLevel(OperationContext context) {
        ServiceController controller = context.getServiceRegistry(false).getService(Services.START_LEVEL);
        return controller != null ? (StartLevel)controller.getValue() : null;
    }
}

