/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.service;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.client.helpers.standalone.ServerDeploymentHelper;
import org.jboss.as.controller.client.helpers.standalone.ServerDeploymentManager;
import org.jboss.as.osgi.OSGiLogger;
import org.jboss.as.osgi.OSGiMessages;
import org.jboss.as.server.Services;
import org.jboss.as.server.deployment.client.ModelControllerServerDeploymentManager;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.framework.BundleInstallHandler;
import org.jboss.osgi.framework.BundleManager;
import org.jboss.osgi.framework.IntegrationServices;
import org.osgi.framework.BundleException;

public class BundleInstallIntegration
implements BundleInstallHandler {
    private static Map<String, Deployment> deploymentMap = new HashMap<String, Deployment>();
    private final InjectedValue<ModelController> injectedController = new InjectedValue();
    private final InjectedValue<BundleManager> injectedBundleManager = new InjectedValue();
    private ServerDeploymentManager deploymentManager;

    public static ServiceController<?> addService(ServiceTarget target) {
        BundleInstallIntegration service = new BundleInstallIntegration();
        ServiceBuilder builder = target.addService(IntegrationServices.BUNDLE_INSTALL_HANDLER, (Service)service);
        builder.addDependency(Services.JBOSS_SERVER_CONTROLLER, ModelController.class, service.injectedController);
        builder.addDependency(org.jboss.osgi.framework.Services.BUNDLE_MANAGER, BundleManager.class, service.injectedBundleManager);
        builder.addDependency(org.jboss.osgi.framework.Services.FRAMEWORK_CREATE);
        builder.setInitialMode(ServiceController.Mode.ON_DEMAND);
        return builder.install();
    }

    private BundleInstallIntegration() {
    }

    public void start(StartContext context) throws StartException {
        ServiceController controller = context.getController();
        OSGiLogger.LOGGER.tracef("Starting: %s in mode %s", controller.getName(), controller.getMode());
        this.deploymentManager = new ModelControllerServerDeploymentManager((ModelController)this.injectedController.getValue());
    }

    public void stop(StopContext context) {
        ServiceController controller = context.getController();
        OSGiLogger.LOGGER.tracef("Stopping: %s in mode %s", controller.getName(), controller.getMode());
    }

    public BundleInstallHandler getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public static Deployment getDeployment(String contextName) {
        return deploymentMap.get(contextName);
    }

    public static Deployment removeDeployment(String contextName) {
        return deploymentMap.remove(contextName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void installBundle(Deployment dep) throws BundleException {
        OSGiLogger.LOGGER.tracef("Install deployment: %s", dep);
        try {
            String contextName = this.getContextName(dep);
            deploymentMap.put(contextName, dep);
            InputStream input = dep.getRoot().openStream();
            try {
                ServerDeploymentHelper server = new ServerDeploymentHelper(this.deploymentManager);
                server.deploy(contextName, input);
            }
            finally {
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (IOException e) {
                        OSGiLogger.LOGGER.debugf(e, "Failed to close resource %s", input);
                    }
                }
            }
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception ex) {
            throw OSGiMessages.MESSAGES.cannotDeployBundle(ex, dep);
        }
    }

    public void uninstallBundle(Deployment dep) {
        OSGiLogger.LOGGER.tracef("Uninstall deployment: %s", dep);
        try {
            ServerDeploymentHelper server = new ServerDeploymentHelper(this.deploymentManager);
            server.undeploy(this.getContextName(dep));
        }
        catch (Exception ex) {
            OSGiLogger.LOGGER.warnCannotUndeployBundle(ex, dep);
        }
    }

    private String getContextName(Deployment dep) {
        int idx;
        String name = dep.getLocation();
        if (name.endsWith("/")) {
            name = name.substring(0, name.length() - 1);
        }
        if ((idx = name.lastIndexOf("/")) > 0) {
            name = name.substring(idx + 1);
        }
        return name;
    }
}

