/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.web;

import java.util.List;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.osgi.AbstractSubsystemExtension;
import org.jboss.as.osgi.web.RemountDeploymentRootProcessor;
import org.jboss.as.osgi.web.WebContextActivationProcessor;
import org.jboss.as.osgi.web.WebContextLifecycleInterceptor;
import org.jboss.as.server.AbstractDeploymentChainStep;
import org.jboss.as.server.DeploymentProcessorTarget;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Phase;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.osgi.framework.spi.IntegrationServices;

public class WebExtension
extends AbstractSubsystemExtension {
    static final String OSGI_BUNDLECONTEXT = "osgi-bundlecontext";
    static final String WEB_CONTEXT_PATH = "Web-ContextPath";

    public void performBoottime(OperationContext context, ModelNode operation, ModelNode model, final ServiceVerificationHandler verificationHandler, final List<ServiceController<?>> newControllers) {
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                ServiceTarget serviceTarget = context.getServiceTarget();
                newControllers.add(WebContextLifecycleInterceptor.addService(serviceTarget, verificationHandler));
                context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
            }
        }, OperationContext.Stage.RUNTIME);
        context.addStep((OperationStepHandler)new AbstractDeploymentChainStep(){

            protected void execute(DeploymentProcessorTarget processorTarget) {
                processorTarget.addDeploymentProcessor("osgi", Phase.STRUCTURE, 1104, (DeploymentUnitProcessor)new RemountDeploymentRootProcessor());
                processorTarget.addDeploymentProcessor("osgi", Phase.INSTALL, 7680, (DeploymentUnitProcessor)new WebContextActivationProcessor());
            }
        }, OperationContext.Stage.RUNTIME);
    }

    public void configureServiceDependencies(ServiceName serviceName, ServiceBuilder<?> builder) {
        if (serviceName.equals(IntegrationServices.SYSTEM_SERVICES_PLUGIN)) {
            builder.addDependency(WebContextLifecycleInterceptor.SERVICE_NAME);
        }
    }
}

