/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.pojo.descriptor;

import org.jboss.as.pojo.BeanState;
import org.jboss.as.pojo.PojoMessages;
import org.jboss.as.pojo.descriptor.BeanMetaDataConfig;
import org.jboss.as.pojo.descriptor.ConfigVisitor;
import org.jboss.as.pojo.descriptor.ConfigVisitorNode;
import org.jboss.as.pojo.descriptor.LifecycleConfig;
import org.jboss.as.pojo.service.BeanInfo;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.value.InjectedValue;

public class InstallConfig
extends LifecycleConfig {
    private static final long serialVersionUID = 1L;
    private final transient InjectedValue<BeanInfo> beanInfo = new InjectedValue();
    private final transient InjectedValue<Object> bean = new InjectedValue();
    private String dependency;
    private BeanState whenRequired = BeanState.INSTALLED;
    private BeanState dependencyState;

    @Override
    public void visit(ConfigVisitor visitor) {
        if (visitor.getState().next() == this.whenRequired) {
            if (this.dependency != null) {
                visitor.addDependency(this.dependency, BeanState.DESCRIBED, (Injector)this.getBeanInfo());
                ServiceName name = BeanMetaDataConfig.toBeanName(this.dependency, this.dependencyState);
                visitor.addDependency(name, (Injector)this.getBean());
            }
            super.visit(visitor);
        }
    }

    @Override
    public Class<?> getType(ConfigVisitor visitor, ConfigVisitorNode previous) {
        if (this.dependency != null) {
            throw PojoMessages.MESSAGES.tooDynamicFromDependency();
        }
        return super.getType(visitor, previous);
    }

    public String getDependency() {
        return this.dependency;
    }

    public void setDependency(String dependency) {
        this.dependency = dependency;
    }

    public BeanState getWhenRequired() {
        return this.whenRequired;
    }

    public void setWhenRequired(BeanState whenRequired) {
        this.whenRequired = whenRequired;
    }

    public void setDependencyState(BeanState dependencyState) {
        this.dependencyState = dependencyState;
    }

    public InjectedValue<BeanInfo> getBeanInfo() {
        return this.beanInfo;
    }

    public InjectedValue<Object> getBean() {
        return this.bean;
    }
}

