/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.pojo.descriptor;

import java.util.HashMap;
import java.util.Map;
import org.jboss.as.pojo.PojoMessages;
import org.jboss.msc.service.ServiceController;

public enum ModeConfig {
    ACTIVE("active", ServiceController.Mode.ACTIVE),
    PASSIVE("passive", ServiceController.Mode.PASSIVE),
    ON_DEMAND("on demand", ServiceController.Mode.ON_DEMAND),
    NEVER("never", ServiceController.Mode.NEVER);

    private static final Map<String, ModeConfig> MAP;
    private final String value;
    private final ServiceController.Mode mode;

    private ModeConfig(String value, ServiceController.Mode mode) {
        this.value = value;
        this.mode = mode;
    }

    public ServiceController.Mode getMode() {
        return this.mode;
    }

    static ModeConfig of(String value) {
        if (value == null) {
            throw PojoMessages.MESSAGES.nullValue();
        }
        ModeConfig controllerMode = MAP.get(value.toLowerCase());
        return controllerMode == null ? PASSIVE : controllerMode;
    }

    static {
        MAP = new HashMap<String, ModeConfig>();
        for (ModeConfig mode : ModeConfig.values()) {
            MAP.put(mode.value, mode);
        }
    }
}

