/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.protocol;

import java.io.DataInput;
import java.io.IOException;
import java.io.InputStream;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.marshalling.ClassResolver;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.MarshallerFactory;
import org.jboss.marshalling.Marshalling;
import org.jboss.marshalling.MarshallingConfiguration;
import org.jboss.marshalling.ModularClassResolver;
import org.jboss.marshalling.Unmarshaller;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;

public class ProtocolUtils {
    private static final MarshallerFactory MARSHALLER_FACTORY;
    public static final MarshallingConfiguration MODULAR_CONFIG;

    private ProtocolUtils() {
    }

    public static <T> T unmarshal(Unmarshaller unmarshaller, Class<T> expectedType) throws IOException {
        try {
            return (T)unmarshaller.readObject(expectedType);
        }
        catch (ClassNotFoundException e) {
            throw new IOException("Failed to read object", e);
        }
    }

    public static Marshaller getMarshaller(MarshallingConfiguration config) throws IOException {
        return MARSHALLER_FACTORY.createMarshaller(config);
    }

    public static Unmarshaller getUnmarshaller(MarshallingConfiguration config) throws IOException {
        return MARSHALLER_FACTORY.createUnmarshaller(config);
    }

    public static void expectHeader(InputStream input, int expected) throws IOException {
        ProtocolUtils.expectHeader(StreamUtils.readByte(input), expected);
    }

    public static void expectHeader(DataInput input, int expected) throws IOException {
        ProtocolUtils.expectHeader(input.readByte(), expected);
    }

    private static void expectHeader(byte actual, int expected) throws IOException {
        if (actual != (byte)expected) {
            throw new IOException("Invalid byte token.  Expecting '" + expected + "' received '" + actual + "'");
        }
    }

    static {
        MarshallerFactory marshallerFactory;
        try {
            marshallerFactory = Marshalling.getMarshallerFactory((String)"river", (ClassLoader)Module.getModuleFromDefaultLoader((ModuleIdentifier)ModuleIdentifier.fromString((String)"org.jboss.marshalling.river")).getClassLoader());
        }
        catch (ModuleLoadException e) {
            marshallerFactory = Marshalling.getMarshallerFactory((String)"river", (ClassLoader)ProtocolUtils.class.getClassLoader());
        }
        if (marshallerFactory == null) {
            throw new RuntimeException("Failed to construct a Marshaller factory");
        }
        MARSHALLER_FACTORY = marshallerFactory;
        MODULAR_CONFIG = new MarshallingConfiguration();
        MODULAR_CONFIG.setClassResolver((ClassResolver)ModularClassResolver.getInstance());
    }
}

