/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.protocol.mgmt;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.net.SocketFactory;
import org.jboss.as.protocol.Connection;
import org.jboss.as.protocol.MessageHandler;
import org.jboss.as.protocol.ProtocolClient;
import org.jboss.as.protocol.StreamUtils;

public interface ManagementRequestConnectionStrategy {
    public Connection getConnection() throws IOException;

    public void complete();

    public static class EstablishConnectingStrategy
    implements ManagementRequestConnectionStrategy {
        private final InetAddress address;
        private final int port;
        private final long connectTimeout;
        private final ExecutorService executorService;
        private final ThreadFactory threadFactory;
        private Connection connection;

        public EstablishConnectingStrategy(InetAddress address, int port, long connectTimeout, ExecutorService executorService, ThreadFactory threadFactory) {
            this.address = address;
            this.port = port;
            this.connectTimeout = connectTimeout;
            this.executorService = executorService;
            this.threadFactory = threadFactory;
        }

        @Override
        public synchronized Connection getConnection() throws IOException {
            if (this.connection == null) {
                int timeout = (int)TimeUnit.SECONDS.toMillis(this.connectTimeout);
                ProtocolClient.Configuration config = new ProtocolClient.Configuration();
                config.setMessageHandler(MessageHandler.NULL);
                config.setConnectTimeout(timeout);
                config.setReadExecutor(this.executorService);
                config.setSocketFactory(SocketFactory.getDefault());
                config.setServerAddress(new InetSocketAddress(this.address, this.port));
                config.setThreadFactory(this.threadFactory);
                ProtocolClient protocolClient = new ProtocolClient(config);
                this.connection = protocolClient.connect();
            }
            return this.connection;
        }

        @Override
        public synchronized void complete() {
            StreamUtils.safeClose(this.connection);
        }
    }

    public static class ExistingConnectionStrategy
    implements ManagementRequestConnectionStrategy {
        private final Connection connection;

        public ExistingConnectionStrategy(Connection connection) {
            this.connection = connection;
        }

        @Override
        public Connection getConnection() throws IOException {
            return this.connection;
        }

        @Override
        public void complete() {
        }
    }
}

