/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.protocol.mgmt;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jboss.as.protocol.Connection;
import org.jboss.as.protocol.MessageHandler;
import org.jboss.as.protocol.ProtocolUtils;
import org.jboss.as.protocol.SimpleByteDataOutput;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.as.protocol.mgmt.AbstractMessageHandler;

public abstract class ManagementResponse
extends AbstractMessageHandler {
    private final MessageHandler finalMessageHandler;
    final MessageHandler requestBodyHandler = new AbstractMessageHandler(){

        @Override
        public final void handle(Connection connection, InputStream input) throws IOException {
            connection.setMessageHandler(ManagementResponse.this.requestEndHandler);
            ProtocolUtils.expectHeader(input, 3);
            ManagementResponse.this.readRequest(input);
        }
    };
    final MessageHandler requestEndHandler = new AbstractMessageHandler(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void handle(Connection connection, InputStream input) throws IOException {
            connection.setMessageHandler(ManagementResponse.this.finalMessageHandler);
            ProtocolUtils.expectHeader(input, 4);
            OutputStream outputStream = null;
            SimpleByteDataOutput output = null;
            try {
                outputStream = connection.writeMessage();
                output = new SimpleByteDataOutput(outputStream);
                output.writeByte(5);
                output.writeByte(ManagementResponse.this.getResponseCode());
                output.close();
                outputStream.close();
            }
            catch (Throwable throwable) {
                StreamUtils.safeClose(output);
                StreamUtils.safeClose(outputStream);
                throw throwable;
            }
            StreamUtils.safeClose(output);
            StreamUtils.safeClose(outputStream);
            try {
                outputStream = connection.writeMessage();
                outputStream.write(6);
                ManagementResponse.this.sendResponse(outputStream);
                outputStream.close();
            }
            finally {
                StreamUtils.safeClose(outputStream);
            }
            try {
                outputStream = connection.writeMessage();
                outputStream.write(7);
                outputStream.close();
            }
            finally {
                StreamUtils.safeClose(outputStream);
            }
        }
    };

    protected ManagementResponse() {
        this(MessageHandler.NULL);
    }

    protected ManagementResponse(MessageHandler finalMessageHandler) {
        if (finalMessageHandler == null) {
            throw new IllegalArgumentException("finalMessageHandler is null");
        }
        this.finalMessageHandler = finalMessageHandler;
    }

    @Override
    public void handle(Connection connection, InputStream input) throws IOException {
        connection.setMessageHandler(this.requestBodyHandler);
        ProtocolUtils.expectHeader(input, 1);
    }

    protected abstract byte getResponseCode();

    protected void readRequest(InputStream input) throws IOException {
    }

    protected void sendResponse(OutputStream output) throws IOException {
    }
}

