/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.protocol;

import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.jboss.as.protocol.ProtocolChannel;
import org.jboss.as.protocol.ProtocolChannelFactory;
import org.jboss.as.protocol.ProtocolMessages;
import org.jboss.remoting3.Channel;
import org.jboss.remoting3.Connection;
import org.jboss.remoting3.Endpoint;
import org.jboss.remoting3.Registration;
import org.jboss.remoting3.Remoting;
import org.jboss.remoting3.remote.RemoteConnectionProviderFactory;
import org.jboss.remoting3.spi.ConnectionProviderFactory;
import org.xnio.IoFuture;
import org.xnio.IoUtils;
import org.xnio.Option;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.Xnio;

public class ProtocolChannelClient<T extends ProtocolChannel>
implements Closeable {
    private final boolean startedEndpoint;
    private final Endpoint endpoint;
    private final Registration providerRegistration;
    private final URI uri;
    private final ProtocolChannelFactory<T> channelFactory;
    private volatile Connection connection;
    private final Set<T> channels = new HashSet<T>();
    private final long connectTimeout;

    private ProtocolChannelClient(boolean startedEndpoint, Endpoint endpoint, Registration providerRegistration, URI uri, ProtocolChannelFactory<T> channelFactory, long connectTimeout) {
        this.startedEndpoint = startedEndpoint;
        this.endpoint = endpoint;
        this.providerRegistration = providerRegistration;
        this.uri = uri;
        this.channelFactory = channelFactory;
        this.connectTimeout = connectTimeout;
    }

    public static <T extends ProtocolChannel> ProtocolChannelClient<T> create(Configuration<T> configuration) throws IOException, URISyntaxException {
        if (configuration == null) {
            throw ProtocolMessages.MESSAGES.nullVar("configuration");
        }
        configuration.validate();
        if (configuration.getEndpoint() != null) {
            Endpoint endpoint = configuration.getEndpoint();
            return new ProtocolChannelClient<T>(false, endpoint, null, configuration.getUri(), configuration.getChannelFactory(), configuration.getConnectTimeout());
        }
        Endpoint endpoint = Remoting.createEndpoint((String)configuration.getEndpointName(), (Executor)configuration.getExecutor(), (OptionMap)configuration.getOptionMap());
        Xnio xnio = Xnio.getInstance();
        Registration providerRegistration = endpoint.addConnectionProvider(configuration.getUri().getScheme(), (ConnectionProviderFactory)new RemoteConnectionProviderFactory(xnio), OptionMap.create((Option)Options.SSL_ENABLED, (Object)false));
        return new ProtocolChannelClient<T>(true, endpoint, providerRegistration, configuration.getUri(), configuration.getChannelFactory(), configuration.getConnectTimeout());
    }

    public Connection connect(CallbackHandler handler) throws IOException {
        if (this.connection != null) {
            throw ProtocolMessages.MESSAGES.alreadyConnected();
        }
        OptionMap map = OptionMap.create((Option)Options.SASL_POLICY_NOANONYMOUS, (Object)Boolean.FALSE);
        CallbackHandler actualHandler = handler != null ? handler : new AnonymousCallbackHandler();
        WrapperCallbackHandler wrapperHandler = new WrapperCallbackHandler(actualHandler);
        IoFuture future = this.endpoint.connect(this.uri, map, (CallbackHandler)wrapperHandler);
        IoFuture.Status status = future.await(this.connectTimeout, TimeUnit.MILLISECONDS);
        while (status == IoFuture.Status.WAITING) {
            boolean cancel = false;
            if (wrapperHandler.isInCall()) {
                status = future.await(this.connectTimeout, TimeUnit.MILLISECONDS);
            } else if (wrapperHandler.getCallFinished() > -1L) {
                long timeSinceFinished = System.currentTimeMillis() - wrapperHandler.getCallFinished();
                if (timeSinceFinished < 0L) {
                    timeSinceFinished = 0L;
                }
                if (timeSinceFinished < this.connectTimeout) {
                    status = future.await(this.connectTimeout - timeSinceFinished, TimeUnit.MILLISECONDS);
                } else {
                    cancel = true;
                }
            } else {
                cancel = true;
            }
            if (!cancel) continue;
            future.cancel();
            throw ProtocolMessages.MESSAGES.couldNotConnect(this.connectTimeout);
        }
        this.connection = (Connection)future.get();
        return this.connection;
    }

    public T openChannel(String channelName) throws IOException {
        if (this.connection == null) {
            throw ProtocolMessages.MESSAGES.notConnected();
        }
        Channel channel = (Channel)this.connection.openChannel(channelName, OptionMap.EMPTY).get();
        T wrapped = this.channelFactory.create(channelName, channel);
        this.channels.add(wrapped);
        return wrapped;
    }

    @Override
    public void close() {
        for (ProtocolChannel channel : this.channels) {
            try {
                channel.writeShutdown();
            }
            catch (IOException iOException) {}
        }
        this.channels.clear();
        IoUtils.safeClose((Closeable)this.connection);
        if (this.startedEndpoint) {
            IoUtils.safeClose((Closeable)this.providerRegistration);
            IoUtils.safeClose((Closeable)this.endpoint);
        }
    }

    private static final class AnonymousCallbackHandler
    implements CallbackHandler {
        private AnonymousCallbackHandler() {
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            for (Callback current : callbacks) {
                if (!(current instanceof NameCallback)) {
                    throw new UnsupportedCallbackException(current);
                }
                NameCallback ncb = (NameCallback)current;
                ncb.setName("anonymous");
            }
        }
    }

    private static final class WrapperCallbackHandler
    implements CallbackHandler {
        private volatile boolean inCall = false;
        private volatile long callFinished = -1L;
        private final CallbackHandler wrapped;

        WrapperCallbackHandler(CallbackHandler toWrap) {
            this.wrapped = toWrap;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            this.inCall = true;
            try {
                this.wrapped.handle(callbacks);
            }
            finally {
                this.callFinished = System.currentTimeMillis();
                this.inCall = false;
            }
        }

        boolean isInCall() {
            return this.inCall;
        }

        long getCallFinished() {
            return this.callFinished;
        }
    }

    public static final class Configuration<T extends ProtocolChannel> {
        private static final long DEFAULT_CONNECT_TIMEOUT = 5000L;
        private static final AtomicInteger COUNTER = new AtomicInteger();
        private Endpoint endpoint;
        private String endpointName;
        private OptionMap optionMap = OptionMap.EMPTY;
        private ThreadGroup group;
        private String uriScheme;
        private URI uri;
        private ProtocolChannelFactory<T> channelFactory;
        private Executor executor;
        private long connectTimeout = -1L;
        private String connectTimeoutProperty;

        void validate() {
            if (this.endpointName == null && this.endpoint == null) {
                throw ProtocolMessages.MESSAGES.nullParameters("endpointName", "endpoint");
            }
            if (this.optionMap == null) {
                throw ProtocolMessages.MESSAGES.nullVar("optionMap");
            }
            if (this.uriScheme == null && this.endpoint == null) {
                throw ProtocolMessages.MESSAGES.nullVar("uriScheme");
            }
            if (this.uriScheme != null && this.endpoint != null) {
                throw ProtocolMessages.MESSAGES.cannotSetUriScheme();
            }
            if (this.uri == null) {
                throw ProtocolMessages.MESSAGES.nullVar("uri");
            }
            if (this.endpoint != null) {
                if (!this.uri.getScheme().equals("remote")) {
                    throw ProtocolMessages.MESSAGES.invalidUrl("remote");
                }
            } else if (!this.uriScheme.equals(this.uri.getScheme())) {
                throw ProtocolMessages.MESSAGES.unmatchedScheme(this.uriScheme, this.uri);
            }
            if (this.endpoint != null && this.executor != null) {
                throw ProtocolMessages.MESSAGES.executorUnneeded();
            }
            if (this.endpoint == null && this.executor == null) {
                throw ProtocolMessages.MESSAGES.executorNeeded();
            }
            if (this.channelFactory == null) {
                throw ProtocolMessages.MESSAGES.nullVar("channelFactory");
            }
            if (this.connectTimeout != -1L && this.connectTimeoutProperty != null) {
                throw ProtocolMessages.MESSAGES.cannotSpecifyMultipleTimeouts();
            }
            if (this.connectTimeoutProperty != null) {
                this.connectTimeout = AccessController.doPrivileged(new PrivilegedAction<Long>(){

                    @Override
                    public Long run() {
                        try {
                            return Long.valueOf(System.getProperty(Configuration.this.connectTimeoutProperty, "-1"));
                        }
                        catch (NumberFormatException e) {
                            return Long.valueOf("-1");
                        }
                    }
                });
            }
            if (this.connectTimeout < 0L) {
                this.connectTimeout = 5000L;
            }
        }

        public Endpoint getEndpoint() {
            return this.endpoint;
        }

        public void setEndpoint(Endpoint endpoint) {
            this.endpoint = endpoint;
        }

        public void setEndpointName(String endpointName) {
            this.endpointName = endpointName;
        }

        public void setGroup(ThreadGroup group) {
            this.group = group;
        }

        public long getConnectTimeout() {
            return this.connectTimeout;
        }

        public String getConnectTimeoutProperty() {
            return this.connectTimeoutProperty;
        }

        public void setConnectTimeoutProperty(String connectTimeoutProperty) {
            this.connectTimeoutProperty = connectTimeoutProperty;
        }

        public void setConnectTimeout(long connectTimeout) {
            this.connectTimeout = connectTimeout;
        }

        public String getEndpointName() {
            return this.endpointName;
        }

        public ThreadGroup getGroup() {
            if (this.group == null) {
                this.group = new ThreadGroup("Remoting client threads " + COUNTER.incrementAndGet());
            }
            return this.group;
        }

        public String getUriScheme() {
            return this.uriScheme;
        }

        public void setUriScheme(String uriScheme) {
            this.uriScheme = uriScheme;
        }

        public OptionMap getOptionMap() {
            return this.optionMap;
        }

        public void setOptionMap(OptionMap optionMap) {
            this.optionMap = optionMap;
        }

        public URI getUri() {
            return this.uri;
        }

        public void setUri(URI uri) {
            this.uri = uri;
        }

        public Executor getExecutor() {
            return this.executor;
        }

        public void setExecutor(Executor readExecutor) {
            this.executor = readExecutor;
        }

        public ProtocolChannelFactory<T> getChannelFactory() {
            return this.channelFactory;
        }

        public void setChannelFactory(ProtocolChannelFactory<T> channelFactory) {
            this.channelFactory = channelFactory;
        }
    }
}

