/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.protocol.old;

import java.io.DataInput;
import java.io.IOException;
import java.io.InputStream;
import org.jboss.as.protocol.ProtocolMessages;
import org.jboss.as.protocol.old.StreamUtils;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.MarshallerFactory;
import org.jboss.marshalling.Marshalling;
import org.jboss.marshalling.MarshallingConfiguration;
import org.jboss.marshalling.Unmarshaller;

public class ProtocolUtils {
    private static final MarshallerFactory MARSHALLER_FACTORY = Marshalling.getMarshallerFactory((String)"river", (ClassLoader)ProtocolUtils.class.getClassLoader());

    private ProtocolUtils() {
    }

    public static <T> T unmarshal(Unmarshaller unmarshaller, Class<T> expectedType) throws IOException {
        try {
            return (T)unmarshaller.readObject(expectedType);
        }
        catch (ClassNotFoundException e) {
            throw ProtocolMessages.MESSAGES.failedToReadObject(e);
        }
    }

    public static Marshaller getMarshaller(MarshallingConfiguration config) throws IOException {
        return MARSHALLER_FACTORY.createMarshaller(config);
    }

    public static Unmarshaller getUnmarshaller(MarshallingConfiguration config) throws IOException {
        return MARSHALLER_FACTORY.createUnmarshaller(config);
    }

    public static void expectHeader(InputStream input, int expected) throws IOException {
        ProtocolUtils.expectHeader(StreamUtils.readByte(input), expected);
    }

    public static void expectHeader(DataInput input, int expected) throws IOException {
        ProtocolUtils.expectHeader(input.readByte(), expected);
    }

    public static void expectHeader(byte actual, int expected) throws IOException {
        if (actual != (byte)expected) {
            throw ProtocolMessages.MESSAGES.invalidByteToken(expected, actual);
        }
    }
}

