/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.remoting;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.ExtensionContext;
import org.jboss.as.model.AbstractSubsystemAdd;
import org.jboss.as.model.ParseResult;
import org.jboss.as.model.ParseUtils;
import org.jboss.as.remoting.AbstractRemotingSubsystemUpdate;
import org.jboss.as.remoting.AddConnectorUpdate;
import org.jboss.as.remoting.Attribute;
import org.jboss.as.remoting.Element;
import org.jboss.as.remoting.Namespace;
import org.jboss.as.remoting.PolicyElement;
import org.jboss.as.remoting.RemotingSubsystemAdd;
import org.jboss.as.remoting.RemotingSubsystemElement;
import org.jboss.as.remoting.RemotingSubsystemElementUpdate;
import org.jboss.as.remoting.SaslElement;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.xnio.SaslQop;
import org.jboss.xnio.SaslStrength;

public final class RemotingSubsystemParser
implements XMLStreamConstants,
XMLElementReader<ParseResult<ExtensionContext.SubsystemConfiguration<RemotingSubsystemElement>>> {
    private static final RemotingSubsystemParser INSTANCE = new RemotingSubsystemParser();

    private RemotingSubsystemParser() {
    }

    public static RemotingSubsystemParser getInstance() {
        return INSTANCE;
    }

    public void readElement(XMLExtendedStreamReader reader, ParseResult<ExtensionContext.SubsystemConfiguration<RemotingSubsystemElement>> result) throws XMLStreamException {
        ArrayList<AbstractRemotingSubsystemUpdate> updates = new ArrayList<AbstractRemotingSubsystemUpdate>();
        String threadPoolName = null;
        int count = reader.getAttributeCount();
        block9: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (reader.getAttributeNamespace(i) != null) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case THREAD_POOL: {
                    threadPoolName = value;
                    continue block9;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (threadPoolName == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.THREAD_POOL));
        }
        updates.add(new RemotingSubsystemElementUpdate(threadPoolName));
        block10: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case REMOTING_1_0: {
                    Element element = Element.forName(reader.getLocalName());
                    switch (element) {
                        case CONNECTOR: {
                            updates.add(this.parseConnector(reader));
                            continue block10;
                        }
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        result.setResult((Object)new ExtensionContext.SubsystemConfiguration((AbstractSubsystemAdd)new RemotingSubsystemAdd(threadPoolName), updates));
    }

    AddConnectorUpdate parseConnector(XMLExtendedStreamReader reader) throws XMLStreamException {
        String name = null;
        String socketBinding = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME, Attribute.SOCKET_BINDING);
        int count = reader.getAttributeCount();
        for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (reader.getAttributeNamespace(i) != null) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    name = value;
                    break;
                }
                case SOCKET_BINDING: {
                    socketBinding = value;
                    break;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
            required.remove((Object)attribute);
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        assert (name != null);
        assert (socketBinding != null);
        AddConnectorUpdate update = new AddConnectorUpdate(name, socketBinding);
        EnumSet<Element> visited = EnumSet.noneOf(Element.class);
        block13: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case REMOTING_1_0: {
                    Element element = Element.forName(reader.getLocalName());
                    if (visited.contains((Object)element)) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    visited.add(element);
                    switch (element) {
                        case SASL: {
                            update.setSaslElement(this.parseSaslElement(reader));
                            continue block13;
                        }
                        case PROPERTIES: {
                            this.parseProperties(reader, update.getProperties());
                            continue block13;
                        }
                        case AUTHENTICATION_PROVIDER: {
                            update.setAuthenticationProvider(ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"name"));
                            continue block13;
                        }
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        return update;
    }

    SaslElement parseSaslElement(XMLExtendedStreamReader reader) throws XMLStreamException {
        SaslElement saslElement = new SaslElement();
        int count = reader.getAttributeCount();
        if (count > 0) {
            throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)0);
        }
        EnumSet<Element> visited = EnumSet.noneOf(Element.class);
        block12: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case REMOTING_1_0: {
                    Element element = Element.forName(reader.getLocalName());
                    if (visited.contains((Object)element)) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    visited.add(element);
                    switch (element) {
                        case INCLUDE_MECHANISMS: {
                            saslElement.setIncludeMechanisms((String[])ParseUtils.readArrayAttributeElement((XMLExtendedStreamReader)reader, (String)"value", String.class));
                            continue block12;
                        }
                        case POLICY: {
                            saslElement.setPolicy(this.parsePolicyElement(reader));
                            continue block12;
                        }
                        case PROPERTIES: {
                            HashMap<String, String> map = new HashMap<String, String>();
                            this.parseProperties(reader, map);
                            saslElement.setProperties(map);
                            continue block12;
                        }
                        case QOP: {
                            saslElement.setQop((SaslQop[])ParseUtils.readArrayAttributeElement((XMLExtendedStreamReader)reader, (String)"value", SaslQop.class));
                            continue block12;
                        }
                        case REUSE_SESSION: {
                            saslElement.setReuseSession(ParseUtils.readBooleanAttributeElement((XMLExtendedStreamReader)reader, (String)"value"));
                            continue block12;
                        }
                        case SERVER_AUTH: {
                            saslElement.setServerAuth(ParseUtils.readBooleanAttributeElement((XMLExtendedStreamReader)reader, (String)"value"));
                            continue block12;
                        }
                        case STRENGTH: {
                            saslElement.setStrength((SaslStrength[])ParseUtils.readArrayAttributeElement((XMLExtendedStreamReader)reader, (String)"value", SaslStrength.class));
                            continue block12;
                        }
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        return saslElement;
    }

    PolicyElement parsePolicyElement(XMLExtendedStreamReader reader) throws XMLStreamException {
        PolicyElement policy = new PolicyElement();
        if (reader.getAttributeCount() > 0) {
            throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)0);
        }
        EnumSet<Element> visited = EnumSet.noneOf(Element.class);
        block11: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case REMOTING_1_0: {
                    Element element = Element.forName(reader.getLocalName());
                    if (visited.contains((Object)element)) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    visited.add(element);
                    switch (element) {
                        case FORWARD_SECRECY: {
                            policy.setForwardSecrecy(ParseUtils.readBooleanAttributeElement((XMLExtendedStreamReader)reader, (String)"value"));
                            continue block11;
                        }
                        case NO_ACTIVE: {
                            policy.setNoActive(ParseUtils.readBooleanAttributeElement((XMLExtendedStreamReader)reader, (String)"value"));
                            continue block11;
                        }
                        case NO_ANONYMOUS: {
                            policy.setNoAnonymous(ParseUtils.readBooleanAttributeElement((XMLExtendedStreamReader)reader, (String)"value"));
                            continue block11;
                        }
                        case NO_DICTIONARY: {
                            policy.setNoDictionary(ParseUtils.readBooleanAttributeElement((XMLExtendedStreamReader)reader, (String)"value"));
                            continue block11;
                        }
                        case NO_PLAINTEXT: {
                            policy.setNoPlainText(ParseUtils.readBooleanAttributeElement((XMLExtendedStreamReader)reader, (String)"value"));
                            continue block11;
                        }
                        case PASS_CREDENTIALS: {
                            policy.setPassCredentials(ParseUtils.readBooleanAttributeElement((XMLExtendedStreamReader)reader, (String)"value"));
                            continue block11;
                        }
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        return policy;
    }

    void parseProperties(XMLExtendedStreamReader reader, Map<String, String> map) throws XMLStreamException {
        while (reader.nextTag() != 2) {
            reader.require(1, Namespace.CURRENT.getUriString(), Element.PROPERTY.getLocalName());
            ParseUtils.readProperty((XMLExtendedStreamReader)reader).addTo(map);
        }
    }
}

