/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.service.descriptor;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.service.descriptor.JBossServiceAttributeConfig;
import org.jboss.as.service.descriptor.JBossServiceConfig;
import org.jboss.as.service.descriptor.JBossServiceConstructorConfig;
import org.jboss.as.service.descriptor.JBossServiceDependencyConfig;
import org.jboss.as.service.descriptor.JBossServiceXmlDescriptor;
import org.jboss.as.service.descriptor.ParseResult;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLExtendedStreamReader;

public final class JBossServiceXmlDescriptorParser
implements XMLElementReader<ParseResult<JBossServiceXmlDescriptor>>,
XMLStreamConstants {
    public static final String NAMESPACE = "urn:jboss:service:7.0";

    public void readElement(XMLExtendedStreamReader reader, ParseResult<JBossServiceXmlDescriptor> value) throws XMLStreamException {
        JBossServiceXmlDescriptor serviceXmlDescriptor = new JBossServiceXmlDescriptor();
        ArrayList<JBossServiceConfig> serviceConfigs = new ArrayList<JBossServiceConfig>();
        serviceXmlDescriptor.setServiceConfigs(serviceConfigs);
        value.setResult(serviceXmlDescriptor);
        int count = reader.getAttributeCount();
        for (int i = 0; i < count; ++i) {
            QName attributeName = reader.getAttributeName(i);
            Attribute attribute = Attribute.of(attributeName);
            String attributeValue = reader.getAttributeValue(i);
            switch (attribute) {
                case MODE: {
                    serviceXmlDescriptor.setControllerMode(JBossServiceXmlDescriptor.ControllerMode.of(attributeValue));
                }
            }
        }
        while (reader.hasNext()) {
            block3 : switch (reader.nextTag()) {
                case 5: {
                    break;
                }
                case 2: {
                    return;
                }
                case 1: {
                    switch (Element.of(reader.getName())) {
                        case MBEAN: {
                            serviceConfigs.add(this.parseMBean(reader));
                            break block3;
                        }
                        case UNKNOWN: {
                            JBossServiceXmlDescriptorParser.unexpectedContent((XMLStreamReader)reader);
                        }
                    }
                }
            }
        }
    }

    private JBossServiceConfig parseMBean(XMLExtendedStreamReader reader) throws XMLStreamException {
        JBossServiceConfig serviceConfig = new JBossServiceConfig();
        int count = reader.getAttributeCount();
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME, Attribute.CODE);
        block17: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            required.remove((Object)attribute);
            String attributeValue = reader.getAttributeValue(i);
            switch (attribute) {
                case NAME: {
                    serviceConfig.setName(attributeValue);
                    continue block17;
                }
                case CODE: {
                    serviceConfig.setCode(attributeValue);
                    continue block17;
                }
                default: {
                    throw JBossServiceXmlDescriptorParser.unexpectedContent((XMLStreamReader)reader);
                }
            }
        }
        if (!required.isEmpty()) {
            throw JBossServiceXmlDescriptorParser.missingAttributes(reader.getLocation(), required);
        }
        ArrayList<JBossServiceDependencyConfig> dependencyConfigs = new ArrayList<JBossServiceDependencyConfig>();
        ArrayList<JBossServiceAttributeConfig> attributes = new ArrayList<JBossServiceAttributeConfig>();
        ArrayList<String> aliases = new ArrayList<String>();
        ArrayList<String> annotations = new ArrayList<String>();
        while (reader.hasNext()) {
            block4 : switch (reader.nextTag()) {
                case 2: {
                    serviceConfig.setDependencyConfigs(dependencyConfigs.toArray(new JBossServiceDependencyConfig[dependencyConfigs.size()]));
                    serviceConfig.setAliases(aliases.toArray(new String[aliases.size()]));
                    serviceConfig.setAnnotations(annotations.toArray(new String[annotations.size()]));
                    serviceConfig.setAttributeConfigs(attributes.toArray(new JBossServiceAttributeConfig[attributes.size()]));
                    return serviceConfig;
                }
                case 1: {
                    switch (Element.of(reader.getName())) {
                        case CONSTRUCTOR: {
                            serviceConfig.setConstructorConfig(this.parseConstructor(reader));
                            break block4;
                        }
                        case DEPENDS: {
                            dependencyConfigs.add(this.parseDepends(reader));
                            break block4;
                        }
                        case DEPENDS_LIST: {
                            dependencyConfigs.addAll(this.parseDependsList(reader));
                            break block4;
                        }
                        case ALIAS: {
                            aliases.add(this.parseTextElement(reader));
                            break block4;
                        }
                        case ANNOTATION: {
                            annotations.add(this.parseTextElement(reader));
                            break block4;
                        }
                        case ATTRIBUTE: {
                            attributes.add(this.parseAttribute(reader));
                            break block4;
                        }
                        case UNKNOWN: {
                            JBossServiceXmlDescriptorParser.unexpectedContent((XMLStreamReader)reader);
                        }
                    }
                }
            }
        }
        throw JBossServiceXmlDescriptorParser.unexpectedContent((XMLStreamReader)reader);
    }

    private JBossServiceConstructorConfig parseConstructor(XMLExtendedStreamReader reader) throws XMLStreamException {
        JBossServiceConstructorConfig constructorConfig = new JBossServiceConstructorConfig();
        ArrayList<JBossServiceConstructorConfig.Argument> arguments = new ArrayList<JBossServiceConstructorConfig.Argument>();
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    constructorConfig.setArguments(arguments.toArray(new JBossServiceConstructorConfig.Argument[arguments.size()]));
                    return constructorConfig;
                }
                case 1: {
                    switch (Element.of(reader.getName())) {
                        case ARG: {
                            arguments.add(this.parseArgument(reader));
                            break block0;
                        }
                        case UNKNOWN: {
                            JBossServiceXmlDescriptorParser.unexpectedContent((XMLStreamReader)reader);
                        }
                    }
                }
            }
        }
        throw JBossServiceXmlDescriptorParser.unexpectedContent((XMLStreamReader)reader);
    }

    private JBossServiceConstructorConfig.Argument parseArgument(XMLExtendedStreamReader reader) throws XMLStreamException {
        String type = null;
        String value = null;
        int count = reader.getAttributeCount();
        EnumSet<Attribute> required = EnumSet.of(Attribute.TYPE, Attribute.VALUE);
        block4: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            required.remove((Object)attribute);
            String attributeValue = reader.getAttributeValue(i);
            switch (attribute) {
                case TYPE: {
                    type = attributeValue;
                    continue block4;
                }
                case VALUE: {
                    value = attributeValue;
                    continue block4;
                }
                default: {
                    throw JBossServiceXmlDescriptorParser.unexpectedContent((XMLStreamReader)reader);
                }
            }
        }
        if (!required.isEmpty()) {
            throw JBossServiceXmlDescriptorParser.missingAttributes(reader.getLocation(), required);
        }
        reader.discardRemainder();
        return new JBossServiceConstructorConfig.Argument(type, value);
    }

    private JBossServiceAttributeConfig parseAttribute(XMLExtendedStreamReader reader) throws XMLStreamException {
        JBossServiceAttributeConfig attributeConfig = new JBossServiceAttributeConfig();
        int count = reader.getAttributeCount();
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME);
        block15: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            required.remove((Object)attribute);
            String attributeValue = reader.getAttributeValue(i);
            switch (attribute) {
                case NAME: {
                    attributeConfig.setName(attributeValue);
                    continue block15;
                }
                case TRIM: {
                    attributeConfig.setTrim(Boolean.parseBoolean(attributeValue));
                    continue block15;
                }
                case REPLACE: {
                    attributeConfig.setReplace(Boolean.parseBoolean(attributeValue));
                    continue block15;
                }
                default: {
                    throw JBossServiceXmlDescriptorParser.unexpectedContent((XMLStreamReader)reader);
                }
            }
        }
        if (!required.isEmpty()) {
            throw JBossServiceXmlDescriptorParser.missingAttributes(reader.getLocation(), required);
        }
        while (reader.hasNext()) {
            block5 : switch (reader.next()) {
                case 2: {
                    return attributeConfig;
                }
                case 1: {
                    switch (Element.of(reader.getName())) {
                        case INJECT: {
                            attributeConfig.setInject(this.parseInject(reader));
                            break block5;
                        }
                        case VALUE_FACTORY: {
                            attributeConfig.setValueFactory(this.parseValueFactory(reader));
                            break block5;
                        }
                        case UNKNOWN: {
                            JBossServiceXmlDescriptorParser.unexpectedContent((XMLStreamReader)reader);
                        }
                    }
                    break;
                }
                case 4: {
                    attributeConfig.setValue(reader.getText());
                }
            }
        }
        throw JBossServiceXmlDescriptorParser.unexpectedContent((XMLStreamReader)reader);
    }

    private JBossServiceAttributeConfig.Inject parseInject(XMLExtendedStreamReader reader) throws XMLStreamException {
        JBossServiceAttributeConfig.Inject injectConfig = new JBossServiceAttributeConfig.Inject();
        int count = reader.getAttributeCount();
        EnumSet<Attribute> required = EnumSet.of(Attribute.BEAN);
        block4: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            required.remove((Object)attribute);
            String attributeValue = reader.getAttributeValue(i);
            switch (attribute) {
                case BEAN: {
                    injectConfig.setBeanName(attributeValue);
                    continue block4;
                }
                case PROPERTY: {
                    injectConfig.setPropertyName(attributeValue);
                    continue block4;
                }
                default: {
                    throw JBossServiceXmlDescriptorParser.unexpectedContent((XMLStreamReader)reader);
                }
            }
        }
        if (!required.isEmpty()) {
            throw JBossServiceXmlDescriptorParser.missingAttributes(reader.getLocation(), required);
        }
        reader.discardRemainder();
        return injectConfig;
    }

    private JBossServiceAttributeConfig.ValueFactory parseValueFactory(XMLExtendedStreamReader reader) throws XMLStreamException {
        JBossServiceAttributeConfig.ValueFactory valueFactory = new JBossServiceAttributeConfig.ValueFactory();
        int count = reader.getAttributeCount();
        EnumSet<Attribute> required = EnumSet.of(Attribute.BEAN, Attribute.METHOD);
        block12: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            required.remove((Object)attribute);
            String attributeValue = reader.getAttributeValue(i);
            switch (attribute) {
                case BEAN: {
                    valueFactory.setBeanName(attributeValue);
                    continue block12;
                }
                case METHOD: {
                    valueFactory.setMethodName(attributeValue);
                    continue block12;
                }
                default: {
                    throw JBossServiceXmlDescriptorParser.unexpectedContent((XMLStreamReader)reader);
                }
            }
        }
        if (!required.isEmpty()) {
            throw JBossServiceXmlDescriptorParser.missingAttributes(reader.getLocation(), required);
        }
        ArrayList<JBossServiceAttributeConfig.ValueFactoryParameter> parameters = new ArrayList<JBossServiceAttributeConfig.ValueFactoryParameter>();
        while (reader.hasNext()) {
            block4 : switch (reader.next()) {
                case 2: {
                    valueFactory.setParameters(parameters.toArray(new JBossServiceAttributeConfig.ValueFactoryParameter[parameters.size()]));
                    return valueFactory;
                }
                case 1: {
                    switch (Element.of(reader.getName())) {
                        case PARAMETER: {
                            parameters.add(this.parseValueFactoryParameter(reader));
                            break block4;
                        }
                        case UNKNOWN: {
                            JBossServiceXmlDescriptorParser.unexpectedContent((XMLStreamReader)reader);
                        }
                    }
                }
            }
        }
        throw JBossServiceXmlDescriptorParser.unexpectedContent((XMLStreamReader)reader);
    }

    private JBossServiceAttributeConfig.ValueFactoryParameter parseValueFactoryParameter(XMLExtendedStreamReader reader) throws XMLStreamException {
        JBossServiceAttributeConfig.ValueFactoryParameter parameterConfig = new JBossServiceAttributeConfig.ValueFactoryParameter();
        int count = reader.getAttributeCount();
        EnumSet<Attribute> required = EnumSet.of(Attribute.CLASS);
        block7: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            required.remove((Object)attribute);
            String attributeValue = reader.getAttributeValue(i);
            switch (attribute) {
                case CLASS: {
                    parameterConfig.setType(attributeValue);
                    continue block7;
                }
                default: {
                    throw JBossServiceXmlDescriptorParser.unexpectedContent((XMLStreamReader)reader);
                }
            }
        }
        if (!required.isEmpty()) {
            throw JBossServiceXmlDescriptorParser.missingAttributes(reader.getLocation(), required);
        }
        while (reader.hasNext()) {
            switch (reader.next()) {
                case 2: {
                    return parameterConfig;
                }
                case 4: {
                    parameterConfig.setValue(reader.getText());
                }
            }
        }
        throw JBossServiceXmlDescriptorParser.unexpectedContent((XMLStreamReader)reader);
    }

    private JBossServiceDependencyConfig parseDepends(XMLExtendedStreamReader reader) throws XMLStreamException {
        JBossServiceDependencyConfig dependencyConfig = new JBossServiceDependencyConfig();
        int count = reader.getAttributeCount();
        block4: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            String attributeValue = reader.getAttributeValue(i);
            switch (attribute) {
                case OPTIONAL_ATTRIBUTE_NAME: {
                    dependencyConfig.setOptionalAttributeName(attributeValue);
                    continue block4;
                }
                case PROXY_TYPE: {
                    dependencyConfig.setProxyType(attributeValue);
                    continue block4;
                }
                default: {
                    throw JBossServiceXmlDescriptorParser.unexpectedContent((XMLStreamReader)reader);
                }
            }
        }
        this.parseDependency(reader, dependencyConfig);
        return dependencyConfig;
    }

    private List<JBossServiceDependencyConfig> parseDependsList(XMLExtendedStreamReader reader) throws XMLStreamException {
        ArrayList<JBossServiceDependencyConfig> dependencyConfigs = new ArrayList<JBossServiceDependencyConfig>();
        String optionalAttributeName = null;
        int count = reader.getAttributeCount();
        block11: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            String attributeValue = reader.getAttributeValue(i);
            switch (attribute) {
                case OPTIONAL_ATTRIBUTE_NAME: {
                    optionalAttributeName = attributeValue;
                    continue block11;
                }
                default: {
                    throw JBossServiceXmlDescriptorParser.unexpectedContent((XMLStreamReader)reader);
                }
            }
        }
        while (reader.hasNext()) {
            block3 : switch (reader.next()) {
                case 2: {
                    return dependencyConfigs;
                }
                case 1: {
                    switch (Element.of(reader.getName())) {
                        case DEPENDS_LIST_ELEMENT: {
                            JBossServiceDependencyConfig dependencyConfig = new JBossServiceDependencyConfig();
                            this.parseDependency(reader, dependencyConfig);
                            dependencyConfigs.add(dependencyConfig);
                            break block3;
                        }
                        case UNKNOWN: {
                            JBossServiceXmlDescriptorParser.unexpectedContent((XMLStreamReader)reader);
                        }
                    }
                }
            }
        }
        throw JBossServiceXmlDescriptorParser.unexpectedContent((XMLStreamReader)reader);
    }

    private void parseDependency(XMLExtendedStreamReader reader, JBossServiceDependencyConfig dependencyConfig) throws XMLStreamException {
        while (reader.hasNext()) {
            block0 : switch (reader.next()) {
                case 2: {
                    return;
                }
                case 1: {
                    switch (Element.of(reader.getName())) {
                        case MBEAN: {
                            dependencyConfig.setServiceConfig(this.parseMBean(reader));
                            break block0;
                        }
                        case UNKNOWN: {
                            JBossServiceXmlDescriptorParser.unexpectedContent((XMLStreamReader)reader);
                        }
                    }
                    break;
                }
                case 4: {
                    dependencyConfig.setDependencyName(reader.getText());
                }
            }
        }
    }

    private String parseTextElement(XMLExtendedStreamReader reader) throws XMLStreamException {
        String value = null;
        while (reader.hasNext()) {
            switch (reader.next()) {
                case 2: {
                    return value;
                }
                case 4: {
                    value = reader.getText();
                }
            }
        }
        throw JBossServiceXmlDescriptorParser.unexpectedContent((XMLStreamReader)reader);
    }

    private static XMLStreamException unexpectedContent(XMLStreamReader reader) {
        String kind;
        switch (reader.getEventType()) {
            case 10: {
                kind = "attribute";
                break;
            }
            case 12: {
                kind = "cdata";
                break;
            }
            case 4: {
                kind = "characters";
                break;
            }
            case 5: {
                kind = "comment";
                break;
            }
            case 11: {
                kind = "dtd";
                break;
            }
            case 8: {
                kind = "document end";
                break;
            }
            case 2: {
                kind = "element end";
                break;
            }
            case 15: {
                kind = "entity decl";
                break;
            }
            case 9: {
                kind = "entity ref";
                break;
            }
            case 13: {
                kind = "namespace";
                break;
            }
            case 14: {
                kind = "notation decl";
                break;
            }
            case 3: {
                kind = "processing instruction";
                break;
            }
            case 6: {
                kind = "whitespace";
                break;
            }
            case 7: {
                kind = "document start";
                break;
            }
            case 1: {
                kind = "element start";
                break;
            }
            default: {
                kind = "unknown";
            }
        }
        StringBuilder b = new StringBuilder("Unexpected content of type '").append(kind).append('\'');
        if (reader.hasName()) {
            b.append(" named '").append(reader.getName()).append('\'');
        }
        if (reader.hasText()) {
            b.append(", text is: '").append(reader.getText()).append('\'');
        }
        return new XMLStreamException(b.toString(), reader.getLocation());
    }

    private static XMLStreamException missingAttributes(Location location, Set<Attribute> required) {
        StringBuilder b = new StringBuilder("Missing one or more required attributes:");
        for (Attribute attribute : required) {
            b.append(' ').append((Object)attribute);
        }
        return new XMLStreamException(b.toString(), location);
    }

    private static enum Attribute {
        MODE(new QName("mode")),
        NAME(new QName("name")),
        CODE(new QName("code")),
        TYPE(new QName("type")),
        VALUE(new QName("value")),
        TRIM(new QName("trim")),
        REPLACE(new QName("replace")),
        BEAN(new QName("bean")),
        PROPERTY(new QName("property")),
        CLASS(new QName("class")),
        METHOD(new QName("method")),
        OPTIONAL_ATTRIBUTE_NAME(new QName("optional-attribute-name")),
        PROXY_TYPE(new QName("proxy-type")),
        UNKNOWN(null);

        private final QName qName;
        private static final Map<QName, Attribute> QNAME_MAP;

        private Attribute(QName qName) {
            this.qName = qName;
        }

        static Attribute of(QName qName) {
            Attribute attribute = QNAME_MAP.get(qName);
            return attribute == null ? UNKNOWN : attribute;
        }

        static {
            QNAME_MAP = new HashMap<QName, Attribute>();
            for (Attribute attribute : Attribute.values()) {
                QNAME_MAP.put(attribute.qName, attribute);
            }
        }
    }

    private static enum Element {
        MBEAN(new QName("urn:jboss:service:7.0", "mbean")),
        CONSTRUCTOR(new QName("urn:jboss:service:7.0", "constructor")),
        ARG(new QName("urn:jboss:service:7.0", "arg")),
        ATTRIBUTE(new QName("urn:jboss:service:7.0", "attribute")),
        INJECT(new QName("urn:jboss:service:7.0", "inject")),
        VALUE_FACTORY(new QName("urn:jboss:service:7.0", "value-factory")),
        PARAMETER(new QName("urn:jboss:service:7.0", "parameter")),
        DEPENDS(new QName("urn:jboss:service:7.0", "depends")),
        DEPENDS_LIST(new QName("urn:jboss:service:7.0", "depends-list")),
        DEPENDS_LIST_ELEMENT(new QName("urn:jboss:service:7.0", "depends-list-element")),
        ALIAS(new QName("urn:jboss:service:7.0", "alias")),
        ANNOTATION(new QName("urn:jboss:service:7.0", "annotation")),
        UNKNOWN(null);

        private final QName qName;
        private static final Map<QName, Element> QNAME_MAP;

        private Element(QName qName) {
            this.qName = qName;
        }

        static Element of(QName qName) {
            Element element = QNAME_MAP.get(qName);
            return element == null ? UNKNOWN : element;
        }

        static {
            QNAME_MAP = new HashMap<QName, Element>();
            for (Element element : Element.values()) {
                QNAME_MAP.put(element.qName, element);
            }
        }
    }
}

