/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.security;

import java.util.Locale;
import java.util.ResourceBundle;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.common.CommonDescriptions;
import org.jboss.as.security.Attribute;
import org.jboss.as.security.Element;
import org.jboss.as.security.Namespace;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

class SecuritySubsystemDescriptions {
    static final String RESOURCE_NAME = SecuritySubsystemDescriptions.class.getPackage().getName() + ".LocalDescriptions";
    static final DescriptionProvider SUBSYSTEM = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            return Descriptions.getSubsystem(locale);
        }
    };
    static final DescriptionProvider SUBSYSTEM_ADD = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            return Descriptions.getSubsystemAdd(locale);
        }
    };
    static final DescriptionProvider SUBSYSTEM_DESCRIBE = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            return CommonDescriptions.getSubsystemDescribeOperation((Locale)locale);
        }
    };
    static final DescriptionProvider SECURITY_DOMAIN = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            return Descriptions.getSecurityDomain(locale);
        }
    };
    static final DescriptionProvider SECURITY_DOMAIN_ADD = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            return Descriptions.getSecurityDomainAdd(locale);
        }
    };
    static final DescriptionProvider SECURITY_DOMAIN_REMOVE = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            return Descriptions.getSecurityDomainRemove(locale);
        }
    };

    SecuritySubsystemDescriptions() {
    }

    private static ResourceBundle getResourceBundle(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return ResourceBundle.getBundle(RESOURCE_NAME, locale);
    }

    private static class Descriptions {
        private Descriptions() {
        }

        static ModelNode getSubsystem(Locale locale) {
            ResourceBundle bundle = SecuritySubsystemDescriptions.getResourceBundle(locale);
            ModelNode subsystem = new ModelNode();
            subsystem.get("description").set(bundle.getString("security"));
            subsystem.get("head-comment-allowed").set(true);
            subsystem.get("tail-comment-allowed").set(true);
            subsystem.get("namespace").set(Namespace.CURRENT.getUriString());
            subsystem.get(new String[]{"attributes", "authentication-manager-class-name", "description"}).set(bundle.getString("authentication-manager"));
            subsystem.get(new String[]{"attributes", "authentication-manager-class-name", "type"}).set(ModelType.STRING);
            subsystem.get(new String[]{"attributes", "authentication-manager-class-name", "required"}).set(false);
            subsystem.get(new String[]{"attributes", "authentication-manager-class-name", "default"}).set("default");
            subsystem.get(new String[]{"attributes", "deep-copy-subject-mode", "description"}).set(bundle.getString("deep-copy-subject-mode"));
            subsystem.get(new String[]{"attributes", "deep-copy-subject-mode", "type"}).set(ModelType.BOOLEAN);
            subsystem.get(new String[]{"attributes", "deep-copy-subject-mode", "required"}).set(false);
            subsystem.get(new String[]{"attributes", "deep-copy-subject-mode", "default"}).set(false);
            subsystem.get(new String[]{"attributes", "default-callback-handler-class-name", "description"}).set(bundle.getString("default-callback-handler-class-name"));
            subsystem.get(new String[]{"attributes", "default-callback-handler-class-name", "type"}).set(ModelType.STRING);
            subsystem.get(new String[]{"attributes", "default-callback-handler-class-name", "required"}).set(false);
            subsystem.get(new String[]{"attributes", "default-callback-handler-class-name", "default"}).set("default");
            subsystem.get(new String[]{"attributes", "subject-factory-class-name", "description"}).set(bundle.getString("subject-factory-class-name"));
            subsystem.get(new String[]{"attributes", "subject-factory-class-name", "type"}).set(ModelType.STRING);
            subsystem.get(new String[]{"attributes", "subject-factory-class-name", "required"}).set(false);
            subsystem.get(new String[]{"attributes", "subject-factory-class-name", "default"}).set("default");
            subsystem.get(new String[]{"attributes", "authorization-manager-class-name", "description"}).set(bundle.getString("authorization-manager-class-name"));
            subsystem.get(new String[]{"attributes", "authorization-manager-class-name", "type"}).set(ModelType.STRING);
            subsystem.get(new String[]{"attributes", "authorization-manager-class-name", "required"}).set(false);
            subsystem.get(new String[]{"attributes", "authorization-manager-class-name", "default"}).set("default");
            subsystem.get(new String[]{"attributes", "audit-manager-class-name", "description"}).set(bundle.getString("audit-manager-class-name"));
            subsystem.get(new String[]{"attributes", "audit-manager-class-name", "type"}).set(ModelType.STRING);
            subsystem.get(new String[]{"attributes", "audit-manager-class-name", "required"}).set(false);
            subsystem.get(new String[]{"attributes", "audit-manager-class-name", "default"}).set("default");
            subsystem.get(new String[]{"attributes", "identity-trust-manager-class-name", "description"}).set(bundle.getString("identity-trust-manager-class-name"));
            subsystem.get(new String[]{"attributes", "identity-trust-manager-class-name", "type"}).set(ModelType.STRING);
            subsystem.get(new String[]{"attributes", "identity-trust-manager-class-name", "required"}).set(false);
            subsystem.get(new String[]{"attributes", "identity-trust-manager-class-name", "default"}).set("default");
            subsystem.get(new String[]{"attributes", "mapping-manager-class-name", "description"}).set(bundle.getString("mapping-manager-class-name"));
            subsystem.get(new String[]{"attributes", "mapping-manager-class-name", "type"}).set(ModelType.STRING);
            subsystem.get(new String[]{"attributes", "mapping-manager-class-name", "required"}).set(false);
            subsystem.get(new String[]{"attributes", "mapping-manager-class-name", "default"}).set("default");
            subsystem.get(new String[]{"children", "security-domain", "description"}).set(bundle.getString("security-domain-children"));
            subsystem.get(new String[]{"children", "security-domain", "required"}).set(false);
            subsystem.get(new String[]{"children", "security-domain", "min-occurs"}).set(0);
            subsystem.get(new String[]{"children", "security-domain", "max-occurs"}).set(Integer.MAX_VALUE);
            subsystem.get(new String[]{"children", "security-domain", "model-description"}).setEmptyObject();
            return subsystem;
        }

        static ModelNode getSubsystemAdd(Locale locale) {
            ResourceBundle bundle = SecuritySubsystemDescriptions.getResourceBundle(locale);
            ModelNode op = new ModelNode();
            op.get("operation-name").set("add");
            op.get("description").set(bundle.getString("security.add"));
            op.get(new String[]{"request-properties", "authentication-manager-class-name", "description"}).set(bundle.getString("authentication-manager"));
            op.get(new String[]{"request-properties", "authentication-manager-class-name", "type"}).set(ModelType.STRING);
            op.get(new String[]{"request-properties", "authentication-manager-class-name", "required"}).set(false);
            op.get(new String[]{"request-properties", "authentication-manager-class-name", "default"}).set("default");
            op.get(new String[]{"request-properties", "deep-copy-subject-mode", "description"}).set(bundle.getString("deep-copy-subject-mode"));
            op.get(new String[]{"request-properties", "deep-copy-subject-mode", "type"}).set(ModelType.BOOLEAN);
            op.get(new String[]{"request-properties", "deep-copy-subject-mode", "required"}).set(false);
            op.get(new String[]{"request-properties", "deep-copy-subject-mode", "default"}).set(false);
            op.get(new String[]{"request-properties", "default-callback-handler-class-name", "description"}).set(bundle.getString("default-callback-handler-class-name"));
            op.get(new String[]{"request-properties", "default-callback-handler-class-name", "type"}).set(ModelType.STRING);
            op.get(new String[]{"request-properties", "default-callback-handler-class-name", "required"}).set(false);
            op.get(new String[]{"request-properties", "default-callback-handler-class-name", "default"}).set("default");
            op.get(new String[]{"request-properties", "subject-factory-class-name", "description"}).set(bundle.getString("subject-factory-class-name"));
            op.get(new String[]{"request-properties", "subject-factory-class-name", "type"}).set(ModelType.STRING);
            op.get(new String[]{"request-properties", "subject-factory-class-name", "required"}).set(false);
            op.get(new String[]{"request-properties", "subject-factory-class-name", "default"}).set("default");
            op.get(new String[]{"request-properties", "authorization-manager-class-name", "description"}).set(bundle.getString("authorization-manager-class-name"));
            op.get(new String[]{"request-properties", "authorization-manager-class-name", "type"}).set(ModelType.STRING);
            op.get(new String[]{"request-properties", "authorization-manager-class-name", "required"}).set(false);
            op.get(new String[]{"request-properties", "authorization-manager-class-name", "default"}).set("default");
            op.get(new String[]{"request-properties", "audit-manager-class-name", "description"}).set(bundle.getString("audit-manager-class-name"));
            op.get(new String[]{"request-properties", "audit-manager-class-name", "type"}).set(ModelType.STRING);
            op.get(new String[]{"request-properties", "audit-manager-class-name", "required"}).set(false);
            op.get(new String[]{"request-properties", "audit-manager-class-name", "default"}).set("default");
            op.get(new String[]{"request-properties", "identity-trust-manager-class-name", "description"}).set(bundle.getString("identity-trust-manager-class-name"));
            op.get(new String[]{"request-properties", "identity-trust-manager-class-name", "type"}).set(ModelType.STRING);
            op.get(new String[]{"request-properties", "identity-trust-manager-class-name", "required"}).set(false);
            op.get(new String[]{"request-properties", "identity-trust-manager-class-name", "default"}).set("default");
            op.get(new String[]{"request-properties", "mapping-manager-class-name", "description"}).set(bundle.getString("mapping-manager-class-name"));
            op.get(new String[]{"request-properties", "mapping-manager-class-name", "type"}).set(ModelType.STRING);
            op.get(new String[]{"request-properties", "mapping-manager-class-name", "required"}).set(false);
            op.get(new String[]{"request-properties", "mapping-manager-class-name", "default"}).set("default");
            op.get("reply-properties").setEmptyObject();
            return op;
        }

        static ModelNode getSecurityDomain(Locale locale) {
            ResourceBundle bundle = SecuritySubsystemDescriptions.getResourceBundle(locale);
            ModelNode op = new ModelNode();
            op.get("description").set(bundle.getString("security-domain"));
            op.get("head-comment-allowed").set(true);
            op.get("tail-comment-allowed").set(true);
            op.get(new String[]{"attributes", Attribute.EXTENDS.getLocalName(), "description"}).set(bundle.getString("extends"));
            op.get(new String[]{"attributes", Attribute.EXTENDS.getLocalName(), "type"}).set(ModelType.STRING);
            op.get(new String[]{"attributes", Attribute.EXTENDS.getLocalName(), "required"}).set(false);
            op.get(new String[]{"children", Element.AUTHENTICATION.getLocalName()}).set(Descriptions.getAuthentication(locale));
            op.get(new String[]{"children", Element.AUTHENTICATION_JASPI.getLocalName()}).set(Descriptions.getAuthenticationJaspi(locale));
            op.get(new String[]{"children", Element.AUTHORIZATION.getLocalName()}).set(Descriptions.getAuthorization(locale));
            op.get(new String[]{"children", Element.ACL.getLocalName()}).set(Descriptions.getAcl(locale));
            op.get(new String[]{"children", Element.AUDIT.getLocalName()}).set(Descriptions.getAudit(locale));
            op.get(new String[]{"children", Element.IDENTITY_TRUST.getLocalName()}).set(Descriptions.getIdentityTrust(locale));
            op.get(new String[]{"children", Element.MAPPING.getLocalName()}).set(Descriptions.getMapping(locale));
            return op;
        }

        static ModelNode getSecurityDomainAdd(Locale locale) {
            ResourceBundle bundle = SecuritySubsystemDescriptions.getResourceBundle(locale);
            ModelNode op = new ModelNode();
            op.get("operation-name").set("add");
            op.get("description").set(bundle.getString("security-domain.add"));
            op.get(new String[]{"request-properties", Attribute.EXTENDS.getLocalName(), "description"}).set(bundle.getString("extends"));
            op.get(new String[]{"request-properties", Attribute.EXTENDS.getLocalName(), "type"}).set(ModelType.STRING);
            op.get(new String[]{"request-properties", Attribute.EXTENDS.getLocalName(), "required"}).set(false);
            op.get(new String[]{"children", Element.AUTHENTICATION.getLocalName()}).set(Descriptions.getAuthenticationAdd(locale));
            op.get(new String[]{"children", Element.AUTHENTICATION_JASPI.getLocalName()}).set(Descriptions.getAuthenticationJaspiAdd(locale));
            op.get(new String[]{"children", Element.AUTHORIZATION.getLocalName()}).set(Descriptions.getAuthorizationAdd(locale));
            op.get(new String[]{"children", Element.ACL.getLocalName()}).set(Descriptions.getAclAdd(locale));
            op.get(new String[]{"children", Element.AUDIT.getLocalName()}).set(Descriptions.getAuditAdd(locale));
            op.get(new String[]{"children", Element.IDENTITY_TRUST.getLocalName()}).set(Descriptions.getIdentityTrustAdd(locale));
            op.get(new String[]{"children", Element.MAPPING.getLocalName()}).set(Descriptions.getMappingAdd(locale));
            return op;
        }

        static ModelNode getSecurityDomainRemove(Locale locale) {
            ResourceBundle bundle = SecuritySubsystemDescriptions.getResourceBundle(locale);
            ModelNode op = new ModelNode();
            op.get("operation-name").set("remove");
            op.get("description").set(bundle.getString("security-domain.remove"));
            return op;
        }

        static ModelNode getModuleOptions(Locale locale) {
            ResourceBundle bundle = SecuritySubsystemDescriptions.getResourceBundle(locale);
            ModelNode node = new ModelNode();
            node.get("type").set(ModelType.LIST);
            node.get("description").set(bundle.getString("module-options"));
            node.get("required").set(false);
            node.get(new String[]{"attributes", Attribute.NAME.getLocalName(), "description"}).set(bundle.getString("module-options.name"));
            node.get(new String[]{"attributes", Attribute.NAME.getLocalName(), "type"}).set(ModelType.STRING);
            node.get(new String[]{"attributes", Attribute.NAME.getLocalName(), "required"}).set(true);
            node.get(new String[]{"attributes", Attribute.VALUE.getLocalName(), "description"}).set(bundle.getString("module-options.value"));
            node.get(new String[]{"attributes", Attribute.VALUE.getLocalName(), "type"}).set(ModelType.STRING);
            node.get(new String[]{"attributes", Attribute.VALUE.getLocalName(), "required"}).set(true);
            return node;
        }

        static ModelNode getModuleOptionsAdd(Locale locale) {
            ResourceBundle bundle = SecuritySubsystemDescriptions.getResourceBundle(locale);
            ModelNode node = new ModelNode();
            node.get("type").set(ModelType.LIST);
            node.get("description").set(bundle.getString("module-options"));
            node.get("required").set(false);
            node.get(new String[]{"request-properties", Attribute.NAME.getLocalName(), "description"}).set(bundle.getString("module-options.name"));
            node.get(new String[]{"request-properties", Attribute.NAME.getLocalName(), "type"}).set(ModelType.STRING);
            node.get(new String[]{"request-properties", Attribute.NAME.getLocalName(), "required"}).set(true);
            node.get(new String[]{"request-properties", Attribute.VALUE.getLocalName(), "description"}).set(bundle.getString("module-options.value"));
            node.get(new String[]{"request-properties", Attribute.VALUE.getLocalName(), "type"}).set(ModelType.STRING);
            node.get(new String[]{"request-properties", Attribute.VALUE.getLocalName(), "required"}).set(true);
            return node;
        }

        static ModelNode getAuthentication(Locale locale) {
            ResourceBundle bundle = SecuritySubsystemDescriptions.getResourceBundle(locale);
            ModelNode node = new ModelNode();
            node.get("type").set(ModelType.LIST);
            node.get("description").set(bundle.getString("authentication"));
            node.get("required").set(false);
            node.get(new String[]{"attributes", Attribute.CODE.getLocalName(), "description"}).set(bundle.getString("code"));
            node.get(new String[]{"attributes", Attribute.CODE.getLocalName(), "type"}).set(ModelType.STRING);
            node.get(new String[]{"attributes", Attribute.CODE.getLocalName(), "required"}).set(true);
            node.get(new String[]{"attributes", Attribute.FLAG.getLocalName(), "description"}).set(bundle.getString("flag"));
            node.get(new String[]{"attributes", Attribute.FLAG.getLocalName(), "type"}).set(ModelType.STRING);
            node.get(new String[]{"attributes", Attribute.FLAG.getLocalName(), "required"}).set(true);
            node.get("module-options").set(Descriptions.getModuleOptions(locale));
            return node;
        }

        static ModelNode getAuthenticationAdd(Locale locale) {
            ResourceBundle bundle = SecuritySubsystemDescriptions.getResourceBundle(locale);
            ModelNode node = new ModelNode();
            node.get("type").set(ModelType.LIST);
            node.get("description").set(bundle.getString("authentication"));
            node.get("required").set(false);
            node.get(new String[]{"request-properties", Attribute.CODE.getLocalName(), "description"}).set(bundle.getString("code"));
            node.get(new String[]{"request-properties", Attribute.CODE.getLocalName(), "type"}).set(ModelType.STRING);
            node.get(new String[]{"request-properties", Attribute.CODE.getLocalName(), "required"}).set(true);
            node.get(new String[]{"request-properties", Attribute.FLAG.getLocalName(), "description"}).set(bundle.getString("flag"));
            node.get(new String[]{"request-properties", Attribute.FLAG.getLocalName(), "type"}).set(ModelType.STRING);
            node.get(new String[]{"request-properties", Attribute.FLAG.getLocalName(), "required"}).set(true);
            node.get("module-options").set(Descriptions.getModuleOptionsAdd(locale));
            return node;
        }

        static ModelNode getAuthenticationJaspi(Locale locale) {
            ResourceBundle bundle = SecuritySubsystemDescriptions.getResourceBundle(locale);
            ModelNode node = new ModelNode();
            node.get("type").set(ModelType.LIST);
            node.get("description").set(bundle.getString("authentication-jaspi"));
            node.get("required").set(false);
            node.get(Element.LOGIN_MODULE_STACK.getLocalName()).set(Descriptions.getLoginModuleStack(locale));
            node.get(Element.AUTH_MODULE.getLocalName()).set(Descriptions.getAuthModule(locale));
            return node;
        }

        static ModelNode getAuthenticationJaspiAdd(Locale locale) {
            ResourceBundle bundle = SecuritySubsystemDescriptions.getResourceBundle(locale);
            ModelNode node = new ModelNode();
            node.get("type").set(ModelType.LIST);
            node.get("description").set(bundle.getString("authentication-jaspi"));
            node.get("required").set(false);
            node.get(Element.LOGIN_MODULE_STACK.getLocalName()).set(Descriptions.getLoginModuleStackAdd(locale));
            node.get(Element.AUTH_MODULE.getLocalName()).set(Descriptions.getAuthModuleAdd(locale));
            return node;
        }

        static ModelNode getLoginModuleStack(Locale locale) {
            ResourceBundle bundle = SecuritySubsystemDescriptions.getResourceBundle(locale);
            ModelNode node = new ModelNode();
            node.get("type").set(ModelType.OBJECT);
            node.get("description").set(bundle.getString("authentication-jaspi.login-module-stack"));
            node.get("required").set(false);
            node.get(new String[]{"attributes", Attribute.NAME.getLocalName(), "description"}).set(bundle.getString("authentication-jaspi.login-module-stack.name"));
            node.get(new String[]{"attributes", Attribute.NAME.getLocalName(), "type"}).set(ModelType.STRING);
            node.get(new String[]{"attributes", Attribute.NAME.getLocalName(), "required"}).set(true);
            node.get(new String[]{"attributes", Attribute.CODE.getLocalName(), "description"}).set(bundle.getString("code"));
            node.get(new String[]{"attributes", Attribute.CODE.getLocalName(), "type"}).set(ModelType.STRING);
            node.get(new String[]{"attributes", Attribute.CODE.getLocalName(), "required"}).set(true);
            node.get(new String[]{"attributes", Attribute.FLAG.getLocalName(), "description"}).set(bundle.getString("flag"));
            node.get(new String[]{"attributes", Attribute.FLAG.getLocalName(), "type"}).set(ModelType.STRING);
            node.get(new String[]{"attributes", Attribute.FLAG.getLocalName(), "required"}).set(true);
            node.get("module-options").set(Descriptions.getModuleOptions(locale));
            return node;
        }

        static ModelNode getLoginModuleStackAdd(Locale locale) {
            ResourceBundle bundle = SecuritySubsystemDescriptions.getResourceBundle(locale);
            ModelNode node = new ModelNode();
            node.get("type").set(ModelType.OBJECT);
            node.get("description").set(bundle.getString("authentication-jaspi.login-module-stack"));
            node.get("required").set(false);
            node.get(new String[]{"request-properties", Attribute.NAME.getLocalName(), "description"}).set(bundle.getString("authentication-jaspi.login-module-stack.name"));
            node.get(new String[]{"request-properties", Attribute.NAME.getLocalName(), "type"}).set(ModelType.STRING);
            node.get(new String[]{"request-properties", Attribute.NAME.getLocalName(), "required"}).set(true);
            node.get(new String[]{"request-properties", Attribute.CODE.getLocalName(), "description"}).set(bundle.getString("code"));
            node.get(new String[]{"request-properties", Attribute.CODE.getLocalName(), "type"}).set(ModelType.STRING);
            node.get(new String[]{"request-properties", Attribute.CODE.getLocalName(), "required"}).set(true);
            node.get(new String[]{"request-properties", Attribute.FLAG.getLocalName(), "description"}).set(bundle.getString("flag"));
            node.get(new String[]{"request-properties", Attribute.FLAG.getLocalName(), "type"}).set(ModelType.STRING);
            node.get(new String[]{"request-properties", Attribute.FLAG.getLocalName(), "required"}).set(true);
            node.get("module-options").set(Descriptions.getModuleOptionsAdd(locale));
            return node;
        }

        static ModelNode getAuthModule(Locale locale) {
            ResourceBundle bundle = SecuritySubsystemDescriptions.getResourceBundle(locale);
            ModelNode node = new ModelNode();
            node.get("type").set(ModelType.OBJECT);
            node.get("description").set(bundle.getString("authentication-jaspi.auth-module"));
            node.get("required").set(false);
            node.get(new String[]{"attributes", Attribute.CODE.getLocalName(), "description"}).set(bundle.getString("code"));
            node.get(new String[]{"attributes", Attribute.CODE.getLocalName(), "type"}).set(ModelType.STRING);
            node.get(new String[]{"attributes", Attribute.CODE.getLocalName(), "required"}).set(true);
            node.get(new String[]{"attributes", Attribute.LOGIN_MODULE_STACK_REF.getLocalName(), "description"}).set(bundle.getString("login-module-stack-ref"));
            node.get(new String[]{"attributes", Attribute.LOGIN_MODULE_STACK_REF.getLocalName(), "type"}).set(ModelType.STRING);
            node.get(new String[]{"attributes", Attribute.LOGIN_MODULE_STACK_REF.getLocalName(), "required"}).set(false);
            node.get("module-options").set(Descriptions.getModuleOptions(locale));
            return node;
        }

        static ModelNode getAuthModuleAdd(Locale locale) {
            ResourceBundle bundle = SecuritySubsystemDescriptions.getResourceBundle(locale);
            ModelNode node = new ModelNode();
            node.get("type").set(ModelType.OBJECT);
            node.get("description").set(bundle.getString("authentication-jaspi.auth-module"));
            node.get("required").set(false);
            node.get(new String[]{"request-properties", Attribute.CODE.getLocalName(), "description"}).set(bundle.getString("code"));
            node.get(new String[]{"request-properties", Attribute.CODE.getLocalName(), "type"}).set(ModelType.STRING);
            node.get(new String[]{"request-properties", Attribute.CODE.getLocalName(), "required"}).set(true);
            node.get(new String[]{"request-properties", Attribute.LOGIN_MODULE_STACK_REF.getLocalName(), "description"}).set(bundle.getString("login-module-stack-ref"));
            node.get(new String[]{"request-properties", Attribute.LOGIN_MODULE_STACK_REF.getLocalName(), "type"}).set(ModelType.STRING);
            node.get(new String[]{"request-properties", Attribute.LOGIN_MODULE_STACK_REF.getLocalName(), "required"}).set(false);
            node.get("module-options").set(Descriptions.getModuleOptionsAdd(locale));
            return node;
        }

        static ModelNode getAuthorization(Locale locale) {
            ResourceBundle bundle = SecuritySubsystemDescriptions.getResourceBundle(locale);
            ModelNode node = new ModelNode();
            node.get("type").set(ModelType.LIST);
            node.get("description").set(bundle.getString("authorization"));
            node.get("required").set(false);
            node.get(new String[]{"attributes", Attribute.CODE.getLocalName(), "description"}).set(bundle.getString("code"));
            node.get(new String[]{"attributes", Attribute.CODE.getLocalName(), "type"}).set(ModelType.STRING);
            node.get(new String[]{"attributes", Attribute.CODE.getLocalName(), "required"}).set(true);
            node.get(new String[]{"attributes", Attribute.FLAG.getLocalName(), "description"}).set(bundle.getString("flag"));
            node.get(new String[]{"attributes", Attribute.FLAG.getLocalName(), "type"}).set(ModelType.STRING);
            node.get(new String[]{"attributes", Attribute.FLAG.getLocalName(), "required"}).set(true);
            node.get("module-options").set(Descriptions.getModuleOptions(locale));
            return node;
        }

        static ModelNode getAuthorizationAdd(Locale locale) {
            ResourceBundle bundle = SecuritySubsystemDescriptions.getResourceBundle(locale);
            ModelNode node = new ModelNode();
            node.get("type").set(ModelType.LIST);
            node.get("description").set(bundle.getString("authorization"));
            node.get("required").set(false);
            node.get(new String[]{"request-properties", Attribute.CODE.getLocalName(), "description"}).set(bundle.getString("code"));
            node.get(new String[]{"request-properties", Attribute.CODE.getLocalName(), "type"}).set(ModelType.STRING);
            node.get(new String[]{"request-properties", Attribute.CODE.getLocalName(), "required"}).set(true);
            node.get(new String[]{"request-properties", Attribute.FLAG.getLocalName(), "description"}).set(bundle.getString("flag"));
            node.get(new String[]{"request-properties", Attribute.FLAG.getLocalName(), "type"}).set(ModelType.STRING);
            node.get(new String[]{"request-properties", Attribute.FLAG.getLocalName(), "required"}).set(true);
            node.get("module-options").set(Descriptions.getModuleOptionsAdd(locale));
            return node;
        }

        static ModelNode getAcl(Locale locale) {
            ResourceBundle bundle = SecuritySubsystemDescriptions.getResourceBundle(locale);
            ModelNode node = new ModelNode();
            node.get("type").set(ModelType.LIST);
            node.get("description").set(bundle.getString("acl"));
            node.get("required").set(false);
            node.get(new String[]{"attributes", Attribute.CODE.getLocalName(), "description"}).set(bundle.getString("code"));
            node.get(new String[]{"attributes", Attribute.CODE.getLocalName(), "type"}).set(ModelType.STRING);
            node.get(new String[]{"attributes", Attribute.CODE.getLocalName(), "required"}).set(true);
            node.get(new String[]{"attributes", Attribute.FLAG.getLocalName(), "description"}).set(bundle.getString("flag"));
            node.get(new String[]{"attributes", Attribute.FLAG.getLocalName(), "type"}).set(ModelType.STRING);
            node.get(new String[]{"attributes", Attribute.FLAG.getLocalName(), "required"}).set(true);
            node.get("module-options").set(Descriptions.getModuleOptions(locale));
            return node;
        }

        static ModelNode getAclAdd(Locale locale) {
            ResourceBundle bundle = SecuritySubsystemDescriptions.getResourceBundle(locale);
            ModelNode node = new ModelNode();
            node.get("type").set(ModelType.LIST);
            node.get("description").set(bundle.getString("acl"));
            node.get("required").set(false);
            node.get(new String[]{"request-properties", Attribute.CODE.getLocalName(), "description"}).set(bundle.getString("code"));
            node.get(new String[]{"request-properties", Attribute.CODE.getLocalName(), "type"}).set(ModelType.STRING);
            node.get(new String[]{"request-properties", Attribute.CODE.getLocalName(), "required"}).set(true);
            node.get(new String[]{"request-properties", Attribute.FLAG.getLocalName(), "description"}).set(bundle.getString("flag"));
            node.get(new String[]{"request-properties", Attribute.FLAG.getLocalName(), "type"}).set(ModelType.STRING);
            node.get(new String[]{"request-properties", Attribute.FLAG.getLocalName(), "required"}).set(true);
            node.get("module-options").set(Descriptions.getModuleOptionsAdd(locale));
            return node;
        }

        static ModelNode getAudit(Locale locale) {
            ResourceBundle bundle = SecuritySubsystemDescriptions.getResourceBundle(locale);
            ModelNode node = new ModelNode();
            node.get("type").set(ModelType.LIST);
            node.get("description").set(bundle.getString("audit"));
            node.get("required").set(false);
            node.get(new String[]{"attributes", Attribute.CODE.getLocalName(), "description"}).set(bundle.getString("code"));
            node.get(new String[]{"attributes", Attribute.CODE.getLocalName(), "type"}).set(ModelType.STRING);
            node.get(new String[]{"attributes", Attribute.CODE.getLocalName(), "required"}).set(true);
            node.get("module-options").set(Descriptions.getModuleOptions(locale));
            return node;
        }

        static ModelNode getAuditAdd(Locale locale) {
            ResourceBundle bundle = SecuritySubsystemDescriptions.getResourceBundle(locale);
            ModelNode node = new ModelNode();
            node.get("type").set(ModelType.LIST);
            node.get("description").set(bundle.getString("audit"));
            node.get("required").set(false);
            node.get(new String[]{"request-properties", Attribute.CODE.getLocalName(), "description"}).set(bundle.getString("code"));
            node.get(new String[]{"request-properties", Attribute.CODE.getLocalName(), "type"}).set(ModelType.STRING);
            node.get(new String[]{"request-properties", Attribute.CODE.getLocalName(), "required"}).set(true);
            node.get("module-options").set(Descriptions.getModuleOptionsAdd(locale));
            return node;
        }

        static ModelNode getIdentityTrust(Locale locale) {
            ResourceBundle bundle = SecuritySubsystemDescriptions.getResourceBundle(locale);
            ModelNode node = new ModelNode();
            node.get("type").set(ModelType.LIST);
            node.get("description").set(bundle.getString("identity-trust"));
            node.get("required").set(false);
            node.get(new String[]{"attributes", Attribute.CODE.getLocalName(), "description"}).set(bundle.getString("code"));
            node.get(new String[]{"attributes", Attribute.CODE.getLocalName(), "type"}).set(ModelType.STRING);
            node.get(new String[]{"attributes", Attribute.CODE.getLocalName(), "required"}).set(true);
            node.get(new String[]{"attributes", Attribute.FLAG.getLocalName(), "description"}).set(bundle.getString("flag"));
            node.get(new String[]{"attributes", Attribute.FLAG.getLocalName(), "type"}).set(ModelType.STRING);
            node.get(new String[]{"attributes", Attribute.FLAG.getLocalName(), "required"}).set(true);
            node.get("module-options").set(Descriptions.getModuleOptions(locale));
            return node;
        }

        static ModelNode getIdentityTrustAdd(Locale locale) {
            ResourceBundle bundle = SecuritySubsystemDescriptions.getResourceBundle(locale);
            ModelNode node = new ModelNode();
            node.get("type").set(ModelType.LIST);
            node.get("description").set(bundle.getString("identity-trust"));
            node.get("required").set(false);
            node.get(new String[]{"request-properties", Attribute.CODE.getLocalName(), "description"}).set(bundle.getString("code"));
            node.get(new String[]{"request-properties", Attribute.CODE.getLocalName(), "type"}).set(ModelType.STRING);
            node.get(new String[]{"request-properties", Attribute.CODE.getLocalName(), "required"}).set(true);
            node.get(new String[]{"request-properties", Attribute.FLAG.getLocalName(), "description"}).set(bundle.getString("flag"));
            node.get(new String[]{"request-properties", Attribute.FLAG.getLocalName(), "type"}).set(ModelType.STRING);
            node.get(new String[]{"request-properties", Attribute.FLAG.getLocalName(), "required"}).set(true);
            node.get("module-options").set(Descriptions.getModuleOptionsAdd(locale));
            return node;
        }

        static ModelNode getMapping(Locale locale) {
            ResourceBundle bundle = SecuritySubsystemDescriptions.getResourceBundle(locale);
            ModelNode node = new ModelNode();
            node.get("type").set(ModelType.LIST);
            node.get("description").set(bundle.getString("mapping"));
            node.get("required").set(false);
            node.get(new String[]{"attributes", Attribute.CODE.getLocalName(), "description"}).set(bundle.getString("code"));
            node.get(new String[]{"attributes", Attribute.CODE.getLocalName(), "type"}).set(ModelType.STRING);
            node.get(new String[]{"attributes", Attribute.CODE.getLocalName(), "required"}).set(true);
            node.get(new String[]{"attributes", Attribute.TYPE.getLocalName(), "description"}).set(bundle.getString("type"));
            node.get(new String[]{"attributes", Attribute.TYPE.getLocalName(), "type"}).set(ModelType.STRING);
            node.get(new String[]{"attributes", Attribute.TYPE.getLocalName(), "required"}).set(false);
            node.get("module-options").set(Descriptions.getModuleOptions(locale));
            return node;
        }

        static ModelNode getMappingAdd(Locale locale) {
            ResourceBundle bundle = SecuritySubsystemDescriptions.getResourceBundle(locale);
            ModelNode node = new ModelNode();
            node.get("type").set(ModelType.LIST);
            node.get("description").set(bundle.getString("mapping"));
            node.get("required").set(false);
            node.get(new String[]{"request-properties", Attribute.CODE.getLocalName(), "description"}).set(bundle.getString("code"));
            node.get(new String[]{"request-properties", Attribute.CODE.getLocalName(), "type"}).set(ModelType.STRING);
            node.get(new String[]{"request-properties", Attribute.CODE.getLocalName(), "required"}).set(true);
            node.get(new String[]{"request-properties", Attribute.TYPE.getLocalName(), "description"}).set(bundle.getString("type"));
            node.get(new String[]{"request-properties", Attribute.TYPE.getLocalName(), "type"}).set(ModelType.STRING);
            node.get(new String[]{"request-properties", Attribute.TYPE.getLocalName(), "required"}).set(false);
            node.get("module-options").set(Descriptions.getModuleOptionsAdd(locale));
            return node;
        }
    }
}

