/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.security;

import java.util.Collection;
import java.util.List;
import java.util.Properties;
import javax.security.auth.login.Configuration;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.naming.NamingStore;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.naming.service.BinderService;
import org.jboss.as.security.ModuleName;
import org.jboss.as.security.context.SecurityDomainJndiInjectable;
import org.jboss.as.security.processors.SecurityDependencyProcessor;
import org.jboss.as.security.service.JaasConfigurationService;
import org.jboss.as.security.service.SecurityBootstrapService;
import org.jboss.as.security.service.SecurityManagementService;
import org.jboss.as.security.service.SimpleSecurityManagerService;
import org.jboss.as.security.service.SubjectFactoryService;
import org.jboss.as.server.AbstractDeploymentChainStep;
import org.jboss.as.server.DeploymentProcessorTarget;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Phase;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.logging.Logger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.security.ISecurityManagement;
import org.jboss.security.auth.callback.JBossCallbackHandler;
import org.jboss.security.auth.login.XMLLoginConfigImpl;
import org.jboss.security.authentication.JBossCachedAuthenticationManager;
import org.jboss.security.plugins.JBossAuthorizationManager;
import org.jboss.security.plugins.JBossSecuritySubjectFactory;
import org.jboss.security.plugins.audit.JBossAuditManager;
import org.jboss.security.plugins.identitytrust.JBossIdentityTrustManager;
import org.jboss.security.plugins.mapping.JBossMappingManager;

class SecuritySubsystemAdd
implements OperationStepHandler {
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.security");
    private static final String AUTHENTICATION_MANAGER = ModuleName.PICKETBOX.getName() + ":" + ModuleName.PICKETBOX.getSlot() + ":" + JBossCachedAuthenticationManager.class.getName();
    private static final String CALLBACK_HANDLER = ModuleName.PICKETBOX.getName() + ":" + ModuleName.PICKETBOX.getSlot() + ":" + JBossCallbackHandler.class.getName();
    private static final String AUTHORIZATION_MANAGER = ModuleName.PICKETBOX.getName() + ":" + ModuleName.PICKETBOX.getSlot() + ":" + JBossAuthorizationManager.class.getName();
    private static final String AUDIT_MANAGER = ModuleName.PICKETBOX.getName() + ":" + ModuleName.PICKETBOX.getSlot() + ":" + JBossAuditManager.class.getName();
    private static final String IDENTITY_TRUST_MANAGER = ModuleName.PICKETBOX.getName() + ":" + ModuleName.PICKETBOX.getSlot() + ":" + JBossIdentityTrustManager.class.getName();
    private static final String MAPPING_MANAGER = ModuleName.PICKETBOX.getName() + ":" + ModuleName.PICKETBOX.getSlot() + ":" + JBossMappingManager.class.getName();
    private static final boolean DEFAULT_DEEP_COPY_OPERATION_MODE = false;
    private static final String SUBJECT_FACTORY = ModuleName.PICKETBOX.getName() + ":" + ModuleName.PICKETBOX.getSlot() + ":" + JBossSecuritySubjectFactory.class.getName();
    static final SecuritySubsystemAdd INSTANCE = new SecuritySubsystemAdd();

    private SecuritySubsystemAdd() {
    }

    public void execute(OperationContext context, ModelNode operation) {
        boolean deepCopySubject;
        String authenticationManagerClassName = "default";
        String callbackHandlerClassName = "default";
        String subjectFactoryClassName = "default";
        String authorizationManagerClassName = "default";
        String auditManagerClassName = "default";
        String identityTrustManagerClassName = "default";
        String mappingManagerClassName = "default";
        ModelNode subModel = context.readModelForUpdate(PathAddress.EMPTY_ADDRESS);
        Properties securityProperties = null;
        if (operation.hasDefined("security-properties")) {
            List securityPropertiesList = operation.get("security-properties").asList();
            subModel.get("security-properties").set((Collection)securityPropertiesList);
            securityProperties = new Properties();
            for (ModelNode node : securityPropertiesList) {
                Property prop = node.asProperty();
                securityProperties.setProperty(prop.getName(), prop.getValue().asString());
            }
        }
        if (operation.hasDefined("authentication-manager-class-name")) {
            authenticationManagerClassName = operation.get("authentication-manager-class-name").asString();
            subModel.get("authentication-manager-class-name").set(authenticationManagerClassName);
        }
        if (operation.hasDefined("deep-copy-subject-mode")) {
            deepCopySubject = operation.get("deep-copy-subject-mode").asBoolean();
            subModel.get("deep-copy-subject-mode").set(deepCopySubject);
        } else {
            deepCopySubject = false;
        }
        if (operation.hasDefined("default-callback-handler-class-name")) {
            callbackHandlerClassName = operation.get("default-callback-handler-class-name").asString();
            subModel.get("default-callback-handler-class-name").set(callbackHandlerClassName);
        }
        if (operation.hasDefined("subject-factory-class-name")) {
            subjectFactoryClassName = operation.get("subject-factory-class-name").asString();
            subModel.get("subject-factory-class-name").set(subjectFactoryClassName);
        }
        if (operation.hasDefined("authorization-manager-class-name")) {
            authorizationManagerClassName = operation.get("authorization-manager-class-name").asString();
            subModel.get("authorization-manager-class-name").set(authorizationManagerClassName);
        }
        if (operation.hasDefined("audit-manager-class-name")) {
            auditManagerClassName = operation.get("audit-manager-class-name").asString();
            subModel.get("audit-manager-class-name").set(auditManagerClassName);
        }
        if (operation.hasDefined("identity-trust-manager-class-name")) {
            identityTrustManagerClassName = operation.get("identity-trust-manager-class-name").asString();
            subModel.get("identity-trust-manager-class-name").set(identityTrustManagerClassName);
        }
        if (operation.hasDefined("mapping-manager-class-name")) {
            mappingManagerClassName = operation.get("mapping-manager-class-name").asString();
            subModel.get("mapping-manager-class-name").set(mappingManagerClassName);
        }
        subModel.get("security-domain").setEmptyObject();
        final String resolvedAuthenticationManagerClassName = "default".equals(authenticationManagerClassName) ? AUTHENTICATION_MANAGER : authenticationManagerClassName;
        final String resolvedCallbackHandlerClassName = "default".equals(callbackHandlerClassName) ? CALLBACK_HANDLER : callbackHandlerClassName;
        final String resolvedAuthorizationManagerClassName = "default".equals(authorizationManagerClassName) ? AUTHORIZATION_MANAGER : authorizationManagerClassName;
        final String resolvedAuditManagerClassName = "default".equals(auditManagerClassName) ? AUDIT_MANAGER : auditManagerClassName;
        final String resolvedIdentityTrustManagerClassName = "default".equals(identityTrustManagerClassName) ? IDENTITY_TRUST_MANAGER : identityTrustManagerClassName;
        final String resolvedMappingManagerClassName = "default".equals(mappingManagerClassName) ? MAPPING_MANAGER : mappingManagerClassName;
        final String resolvedSubjectFactoryClassName = "default".equals(subjectFactoryClassName) ? SUBJECT_FACTORY : subjectFactoryClassName;
        if (context.getType() == OperationContext.Type.SERVER) {
            if (!context.isBooting()) {
                context.reloadRequired();
            } else {
                context.addStep((OperationStepHandler)new AbstractDeploymentChainStep(){

                    protected void execute(DeploymentProcessorTarget processorTarget) {
                        processorTarget.addDeploymentProcessor(Phase.DEPENDENCIES, 256, (DeploymentUnitProcessor)new SecurityDependencyProcessor());
                    }
                }, OperationContext.Stage.RUNTIME);
                final Properties securityPropertiesStr = securityProperties;
                context.addStep(new OperationStepHandler(){

                    public void execute(OperationContext context, ModelNode operation) {
                        ServiceVerificationHandler verificationHandler = new ServiceVerificationHandler();
                        log.info((Object)"Activating Security Subsystem");
                        ServiceTarget target = context.getServiceTarget();
                        SecurityBootstrapService bootstrapService = new SecurityBootstrapService();
                        if (securityPropertiesStr != null && !securityPropertiesStr.isEmpty()) {
                            bootstrapService.setSecurityProperties(securityPropertiesStr);
                        }
                        target.addService(SecurityBootstrapService.SERVICE_NAME, (Service)bootstrapService).setInitialMode(ServiceController.Mode.ACTIVE).install();
                        SecurityDomainJndiInjectable securityDomainJndiInjectable = new SecurityDomainJndiInjectable();
                        BinderService binderService = new BinderService("jaas");
                        target.addService(ContextNames.JAVA_CONTEXT_SERVICE_NAME.append(new String[]{"jboss", "jaas"}), (Service)binderService).addInjection(binderService.getManagedObjectInjector(), (Object)securityDomainJndiInjectable).addDependency(ContextNames.JAVA_CONTEXT_SERVICE_NAME.append(new String[]{"jboss"}), NamingStore.class, binderService.getNamingStoreInjector()).addDependency(SecurityManagementService.SERVICE_NAME, ISecurityManagement.class, securityDomainJndiInjectable.getSecurityManagementInjector()).setInitialMode(ServiceController.Mode.ACTIVE).install();
                        SecurityManagementService securityManagementService = new SecurityManagementService(resolvedAuthenticationManagerClassName, deepCopySubject, resolvedCallbackHandlerClassName, resolvedAuthorizationManagerClassName, resolvedAuditManagerClassName, resolvedIdentityTrustManagerClassName, resolvedMappingManagerClassName);
                        target.addService(SecurityManagementService.SERVICE_NAME, (Service)securityManagementService).setInitialMode(ServiceController.Mode.ACTIVE).install();
                        SubjectFactoryService subjectFactoryService = new SubjectFactoryService(resolvedSubjectFactoryClassName);
                        target.addService(SubjectFactoryService.SERVICE_NAME, (Service)subjectFactoryService).addDependency(SecurityManagementService.SERVICE_NAME, ISecurityManagement.class, subjectFactoryService.getSecurityManagementInjector()).setInitialMode(ServiceController.Mode.ACTIVE).install();
                        XMLLoginConfigImpl loginConfig = XMLLoginConfigImpl.getInstance();
                        JaasConfigurationService jaasConfigurationService = new JaasConfigurationService((Configuration)loginConfig);
                        target.addService(JaasConfigurationService.SERVICE_NAME, (Service)jaasConfigurationService).addListener((ServiceListener)verificationHandler).setInitialMode(ServiceController.Mode.ACTIVE).install();
                        target.addService(SimpleSecurityManagerService.SERVICE_NAME, (Service)new SimpleSecurityManagerService()).addListener((ServiceListener)verificationHandler).install();
                        context.addStep((OperationStepHandler)verificationHandler, OperationContext.Stage.VERIFY);
                        if (context.completeStep() == OperationContext.ResultAction.ROLLBACK) {
                            context.removeService(JaasConfigurationService.SERVICE_NAME);
                        }
                    }
                }, OperationContext.Stage.RUNTIME);
            }
        }
        if (context.completeStep() != OperationContext.ResultAction.KEEP && context.getType() == OperationContext.Type.SERVER && !context.isBooting()) {
            context.revertReloadRequired();
        }
    }
}

