/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.security;

import java.util.Locale;
import java.util.ResourceBundle;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.ListAttributeDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.ParametersOfValidator;
import org.jboss.as.controller.operations.validation.ParametersValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.security.Attribute;
import org.jboss.as.security.Element;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class JASPIAuthenticationModulesAttributeDefinition
extends ListAttributeDefinition {
    private static final ParameterValidator validator;
    private static final ParameterValidator fieldValidator;

    public JASPIAuthenticationModulesAttributeDefinition() {
        super("auth-modules", "auth-module", false, 1, Integer.MAX_VALUE, validator, null, null, new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES});
    }

    protected void addValueTypeDescription(ModelNode node, ResourceBundle bundle2) {
        throw new UnsupportedOperationException("Use the ResourceDescriptionResolver variant");
    }

    protected void addAttributeValueTypeDescription(ModelNode node, ResourceDescriptionResolver resolver, Locale locale, ResourceBundle bundle2) {
        ModelNode valueType = this.getNoTextValueTypeDescription(node);
        valueType.get(new String[]{"code", "description"}).set(resolver.getResourceAttributeValueTypeDescription(this.getName(), locale, bundle2, new String[]{"code"}));
        valueType.get(new String[]{"module-options", "description"}).set(resolver.getResourceAttributeValueTypeDescription(this.getName(), locale, bundle2, new String[]{"module-options"}));
        valueType.get(new String[]{"login-module-stack-ref", "description"}).set(resolver.getResourceAttributeValueTypeDescription(this.getName(), locale, bundle2, new String[]{"login-module-stack-ref"}));
    }

    protected void addOperationParameterValueTypeDescription(ModelNode node, String operationName, ResourceDescriptionResolver resolver, Locale locale, ResourceBundle bundle2) {
        ModelNode valueType = this.getNoTextValueTypeDescription(node);
        valueType.get(new String[]{"code", "description"}).set(resolver.getOperationParameterValueTypeDescription(operationName, this.getName(), locale, bundle2, new String[]{"code"}));
        valueType.get(new String[]{"module-options", "description"}).set(resolver.getOperationParameterValueTypeDescription(operationName, this.getName(), locale, bundle2, new String[]{"module-options"}));
        valueType.get(new String[]{"login-module-stack-ref", "description"}).set(resolver.getOperationParameterValueTypeDescription(operationName, this.getName(), locale, bundle2, new String[]{"login-module-stack-ref"}));
    }

    public void marshallAsElement(ModelNode resourceModel, XMLStreamWriter writer) throws XMLStreamException {
        if (resourceModel.hasDefined(this.getName()) && resourceModel.asInt() > 0) {
            ModelNode modules = resourceModel.get(this.getName());
            for (ModelNode module : modules.asList()) {
                writer.writeStartElement(this.getXmlName());
                writer.writeAttribute(Attribute.CODE.getLocalName(), module.get("code").asString());
                if (module.hasDefined("login-module-stack-ref")) {
                    writer.writeAttribute(Attribute.LOGIN_MODULE_STACK_REF.getLocalName(), module.get("login-module-stack-ref").asString());
                }
                if (module.hasDefined("module-options")) {
                    for (ModelNode option : module.get("module-options").asList()) {
                        writer.writeEmptyElement(Element.MODULE_OPTION.getLocalName());
                        writer.writeAttribute(Attribute.NAME.getLocalName(), option.asProperty().getName());
                        writer.writeAttribute(Attribute.VALUE.getLocalName(), option.asProperty().getValue().asString());
                    }
                }
                writer.writeEndElement();
            }
        }
    }

    public static ModelNode parseField(String name, String value, XMLStreamReader reader) throws XMLStreamException {
        String trimmed = value == null ? null : value.trim();
        ModelNode node = trimmed != null ? new ModelNode().set(trimmed) : new ModelNode();
        try {
            fieldValidator.validateParameter(name, node);
        }
        catch (OperationFailedException e) {
            throw new XMLStreamException(e.getFailureDescription().toString(), reader.getLocation());
        }
        return node;
    }

    private ModelNode getNoTextValueTypeDescription(ModelNode parent) {
        ModelNode valueType = parent.get("value-type");
        ModelNode code = valueType.get("code");
        code.get("description");
        code.get("type").set(ModelType.STRING);
        code.get("nillable").set(false);
        code.get("min-length").set(1);
        ModelNode moduleOptions = valueType.get("module-options");
        moduleOptions.get("description");
        moduleOptions.get("type").set(ModelType.OBJECT);
        moduleOptions.get("value-type").set(ModelType.STRING);
        moduleOptions.get("nillable").set(true);
        ModelNode ref = valueType.get("login-module-stack-ref");
        ref.get("description");
        ref.get("type").set(ModelType.STRING);
        ref.get("nillable").set(true);
        ref.get("min-length").set(1);
        return valueType;
    }

    static {
        ParametersValidator delegate = new ParametersValidator();
        delegate.registerValidator("code", (ParameterValidator)new StringLengthValidator(1));
        delegate.registerValidator("module-options", (ParameterValidator)new ModelTypeValidator(ModelType.OBJECT, true));
        delegate.registerValidator("login-module-stack-ref", (ParameterValidator)new StringLengthValidator(1, true));
        validator = new ParametersOfValidator(delegate);
        fieldValidator = delegate;
    }
}

