package org.jboss.as.server.manager;

import java.io.IOException;
import java.io.InputStream;

import org.jboss.as.model.HostModel;

/**
 * Handles persistence of the {@link HostModel}.
 *
 * @author Brian Stansberry
 */
public interface HostConfigurationPersister {

    /**
     * Gets an input stream from which the persisted form of the host configuration
     * can be read.
     *
     * @return the input stream. Will not be <code>null</code>
     * @throws IOException if a problem accessing the persisted form occurs
     */
    InputStream getConfigurationInputStream() throws IOException;

    /**
     * Persist the given host model.
     *
     * @param hostModel the model. Cannot be <code>null</code>
     */
    void persistConfiguration(HostModel hostModel);

}

