/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.manager;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.model.Element;
import org.jboss.as.model.HostModel;
import org.jboss.as.server.manager.HostConfigurationPersister;
import org.jboss.logging.Logger;
import org.jboss.staxmapper.XMLContentWriter;
import org.jboss.staxmapper.XMLExtendedStreamWriter;
import org.jboss.staxmapper.XMLMapper;

public class HostConfigurationPersisterImpl
implements HostConfigurationPersister {
    public static final String CONFIG_FILE = "host.xml";
    public static final String BACKUP_SUFFIX = ".last-known-good";
    private static Logger logger = Logger.getLogger((String)"org.jboss.as.server.manager");
    private final File configFile;

    public HostConfigurationPersisterImpl(File configDir) {
        if (configDir == null) {
            throw new IllegalArgumentException("Domain configuration directory is null");
        }
        File configFile = new File(configDir, CONFIG_FILE);
        if (configFile.exists()) {
            if (configFile.isDirectory()) {
                throw new IllegalArgumentException(configFile.getAbsolutePath() + " is a directory");
            }
        } else if (configFile.isDirectory() || !configDir.canWrite()) {
            throw new IllegalArgumentException(configFile.getAbsolutePath() + " is not a writable");
        }
        this.configFile = configFile;
    }

    @Override
    public InputStream getConfigurationInputStream() throws IOException {
        return new FileInputStream(this.configFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void persistConfiguration(HostModel hostModel) {
        FileOutputStream fos = null;
        BufferedOutputStream bos = null;
        XMLStreamWriter writer = null;
        try {
            this.backupConfigFile();
            this.configFile.createNewFile();
            fos = new FileOutputStream(this.configFile);
            bos = new BufferedOutputStream(fos);
            writer = XMLOutputFactory.newInstance().createXMLStreamWriter(bos);
            XMLMapper mapper = XMLMapper.Factory.create();
            mapper.deparseDocument((XMLContentWriter)new RootElementWriter(hostModel), writer);
        }
        catch (Exception e) {
            logger.errorf((Throwable)e, "Failed persisting configuration file %s", (Object)this.configFile.getAbsolutePath());
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (XMLStreamException e) {
                    logger.warnf((Throwable)e, "Failed closing writer to configuration file %s", (Object)this.configFile.getAbsolutePath());
                }
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    logger.warnf((Throwable)e, "Failed closing output stream to configuration file %s", (Object)this.configFile.getAbsolutePath());
                }
            }
        }
    }

    private void backupConfigFile() throws IOException {
        File backup = new File(this.configFile.getParent(), this.configFile.getName() + BACKUP_SUFFIX);
        HostConfigurationPersisterImpl.copyFile(this.configFile, backup);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyFile(File file, File backup) throws IOException {
        if (backup.exists()) {
            backup.delete();
        }
        if (!file.renameTo(backup)) {
            FileOutputStream fos = null;
            FilterOutputStream bos = null;
            FileInputStream fis = null;
            try {
                int read;
                fos = new FileOutputStream(backup);
                bos = new BufferedOutputStream(fos);
                fis = new FileInputStream(file);
                BufferedInputStream bis = new BufferedInputStream(fis);
                byte[] bytes = new byte[8192];
                while ((read = bis.read(bytes)) > -1) {
                    ((BufferedOutputStream)bos).write(bytes, 0, read);
                }
            }
            finally {
                try {
                    if (bos != null) {
                        bos.close();
                    }
                }
                catch (Exception ignored) {}
                try {
                    if (fos != null) {
                        fos.close();
                    }
                }
                catch (Exception ignored) {}
                try {
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (Exception ignored) {}
            }
        }
    }

    private static class RootElementWriter
    implements XMLContentWriter {
        private final HostModel hostModel;

        private RootElementWriter(HostModel hostModel) {
            this.hostModel = hostModel;
        }

        public void writeContent(XMLExtendedStreamWriter streamWriter) throws XMLStreamException {
            streamWriter.writeStartDocument();
            streamWriter.writeStartElement(Element.HOST.getLocalName());
            this.hostModel.writeContent(streamWriter);
            streamWriter.writeEndDocument();
        }
    }
}

