/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.manager;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jboss.as.domain.client.api.HostUpdateResult;
import org.jboss.as.domain.client.api.ServerIdentity;
import org.jboss.as.domain.client.api.ServerStatus;
import org.jboss.as.domain.controller.ModelUpdateResponse;
import org.jboss.as.domain.controller.ServerManagerClient;
import org.jboss.as.model.AbstractDomainModelUpdate;
import org.jboss.as.model.AbstractHostModelUpdate;
import org.jboss.as.model.AbstractServerModelUpdate;
import org.jboss.as.model.DomainModel;
import org.jboss.as.model.HostModel;
import org.jboss.as.model.ServerModel;
import org.jboss.as.model.UpdateFailedException;
import org.jboss.as.model.UpdateResultHandlerResponse;
import org.jboss.as.server.manager.ServerManager;

public class LocalDomainControllerClient
implements ServerManagerClient {
    private final ServerManager serverManager;

    public LocalDomainControllerClient(ServerManager serverManager) {
        this.serverManager = serverManager;
    }

    public String getId() {
        return this.serverManager.getName();
    }

    public boolean isActive() {
        return true;
    }

    public void updateDomainModel(DomainModel domain) {
        this.serverManager.setDomain(domain);
    }

    public HostModel getHostModel() {
        return this.serverManager.getHostModel();
    }

    public List<HostUpdateResult<?>> updateHostModel(List<AbstractHostModelUpdate<?>> updates) {
        return this.serverManager.applyHostUpdates(updates);
    }

    public List<ModelUpdateResponse<List<ServerIdentity>>> updateDomainModel(List<AbstractDomainModelUpdate<?>> updates) {
        ArrayList<ModelUpdateResponse<List<ServerIdentity>>> responses = new ArrayList<ModelUpdateResponse<List<ServerIdentity>>>(updates.size());
        for (AbstractDomainModelUpdate<?> update : updates) {
            ModelUpdateResponse<List<ServerIdentity>> response = this.executeUpdate(update);
            responses.add(response);
            if (response.isSuccess()) continue;
            break;
        }
        return responses;
    }

    public Map<ServerIdentity, ServerStatus> getServerStatuses() {
        return this.serverManager.getServerStatuses();
    }

    public ServerModel getServerModel(String serverName) {
        return this.serverManager.getServerModel(serverName);
    }

    public List<UpdateResultHandlerResponse<?>> updateServerModel(String serverName, List<AbstractServerModelUpdate<?>> updates, boolean allowOverallRollback) {
        return this.serverManager.applyServerUpdates(serverName, updates, allowOverallRollback);
    }

    public ServerStatus restartServer(String serverName, long gracefulTimeout) {
        return this.serverManager.restartServer(serverName, gracefulTimeout);
    }

    public ServerStatus startServer(String serverName) {
        return this.serverManager.startServer(serverName);
    }

    public ServerStatus stopServer(String serverName, long gracefulTimeout) {
        return this.serverManager.stopServer(serverName, gracefulTimeout);
    }

    private ModelUpdateResponse<List<ServerIdentity>> executeUpdate(AbstractDomainModelUpdate<?> domainUpdate) {
        try {
            List<ServerIdentity> result = this.serverManager.getModelManager().applyDomainModelUpdate(domainUpdate, false);
            return new ModelUpdateResponse(result);
        }
        catch (UpdateFailedException e) {
            return new ModelUpdateResponse(e);
        }
    }

    private ModelUpdateResponse<List<ServerIdentity>> executeUpdate(AbstractHostModelUpdate<?> hostUpdate) {
        try {
            List<ServerIdentity> result = this.serverManager.getModelManager().applyHostModelUpdate(hostUpdate);
            return new ModelUpdateResponse(result);
        }
        catch (UpdateFailedException e) {
            return new ModelUpdateResponse(e);
        }
    }
}

