/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.manager;

import java.io.DataInput;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.as.model.AbstractServerModelUpdate;
import org.jboss.as.model.DomainModel;
import org.jboss.as.model.Element;
import org.jboss.as.model.HostModel;
import org.jboss.as.model.JvmElement;
import org.jboss.as.model.PropertiesElement;
import org.jboss.as.model.ServerElement;
import org.jboss.as.model.ServerFactory;
import org.jboss.as.model.ServerGroupElement;
import org.jboss.as.model.ServerModel;
import org.jboss.as.model.UpdateResultHandlerResponse;
import org.jboss.as.process.ProcessManagerClient;
import org.jboss.as.protocol.Connection;
import org.jboss.as.protocol.ProtocolUtils;
import org.jboss.as.protocol.mgmt.ManagementRequest;
import org.jboss.as.protocol.mgmt.ManagementRequestConnectionStrategy;
import org.jboss.as.server.ServerController;
import org.jboss.as.server.ServerManagerClient;
import org.jboss.as.server.ServerManagerConnectionService;
import org.jboss.as.server.ServerStartTask;
import org.jboss.as.server.ServerState;
import org.jboss.as.server.manager.JvmOptionsBuilderFactory;
import org.jboss.as.server.manager.ServerManagerEnvironment;
import org.jboss.marshalling.ClassTable;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.MarshallerFactory;
import org.jboss.marshalling.Marshalling;
import org.jboss.marshalling.MarshallingConfiguration;
import org.jboss.marshalling.ModularClassTable;
import org.jboss.marshalling.Unmarshaller;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.msc.service.BatchBuilder;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceActivator;
import org.jboss.msc.service.ServiceActivatorContext;
import org.jboss.msc.service.ServiceController;

public final class ManagedServer {
    private static final MarshallerFactory MARSHALLER_FACTORY;
    private static final MarshallingConfiguration CONFIG;
    static final String SERVER_PROCESS_NAME_PREFIX = "Server:";
    private final String serverName;
    private final String serverProcessName;
    private final Map<String, String> systemProperties;
    private final JvmElement jvmElement;
    private final ServerManagerEnvironment environment;
    private final int portOffset;
    private final ProcessManagerClient processManagerClient;
    private final AtomicInteger respawnCount = new AtomicInteger();
    private final List<AbstractServerModelUpdate<?>> updateList = new ArrayList();
    private final InetSocketAddress managementSocket;
    private volatile ServerState state;
    private Connection serverManagementConnection;
    private final byte[] authKey;

    public static String getServerProcessName(String serverName) {
        return SERVER_PROCESS_NAME_PREFIX + serverName;
    }

    public ManagedServer(String serverName, DomainModel domainModel, HostModel hostModel, ServerManagerEnvironment environment, ProcessManagerClient processManagerClient, InetSocketAddress managementSocket) {
        String ourVMName;
        assert (domainModel != null) : "domainModel is null";
        assert (hostModel != null) : "hostModel is null";
        assert (serverName != null) : "serverName is null";
        assert (environment != null) : "environment is null";
        assert (processManagerClient != null) : "processManagerSlave is null";
        assert (managementSocket != null) : "managementSocket is null";
        byte[] authKey = new byte[16];
        new Random().nextBytes(authKey);
        this.authKey = authKey;
        this.serverName = serverName;
        this.serverProcessName = ManagedServer.getServerProcessName(serverName);
        this.environment = environment;
        this.processManagerClient = processManagerClient;
        this.managementSocket = managementSocket;
        ServerFactory.combine((DomainModel)domainModel, (HostModel)hostModel, (String)serverName, this.updateList);
        ServerElement server = hostModel.getServer(serverName);
        if (server == null) {
            throw new IllegalStateException("Server " + serverName + " is not listed in Host");
        }
        String serverGroupName = server.getServerGroup();
        ServerGroupElement serverGroup = domainModel.getServerGroup(serverGroupName);
        if (serverGroup == null) {
            throw new IllegalStateException("Server group" + serverGroupName + " is not listed in Domain");
        }
        this.portOffset = server.getSocketBindingGroupName() == null ? serverGroup.getSocketBindingPortOffset() : server.getSocketBindingPortOffset();
        JvmElement serverVM = server.getJvm();
        String serverVMName = serverVM != null ? serverVM.getName() : null;
        JvmElement groupVM = serverGroup.getJvm();
        String groupVMName = groupVM != null ? groupVM.getName() : null;
        String string = ourVMName = serverVMName != null ? serverVMName : groupVMName;
        if (ourVMName == null) {
            throw new IllegalStateException("Neither " + Element.SERVER_GROUP.getLocalName() + " nor " + Element.SERVER.getLocalName() + " has declared a JVM configuration; one or the other must");
        }
        if (!ourVMName.equals(groupVMName)) {
            groupVM = null;
        }
        JvmElement hostVM = hostModel.getJvm(ourVMName);
        this.jvmElement = new JvmElement(new JvmElement[]{groupVM, hostVM, serverVM});
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.putAll(domainModel.getSystemProperties().getProperties());
        properties.putAll(serverGroup.getSystemProperties().getProperties());
        properties.putAll(hostModel.getSystemProperties().getProperties());
        properties.putAll(server.getSystemProperties().getProperties());
        properties.putAll(this.jvmElement.getSystemProperties().getProperties());
        this.addStandardProperties(properties);
        this.systemProperties = properties;
        this.state = ServerState.BOOTING;
    }

    public ServerState getState() {
        return this.state;
    }

    void setState(ServerState state) {
        this.state = state;
    }

    int incrementAndGetRespawnCount() {
        return this.respawnCount.incrementAndGet();
    }

    void resetRespawnCount() {
        this.respawnCount.set(0);
    }

    String getServerProcessName() {
        return this.serverProcessName;
    }

    String getServerName() {
        return this.serverName;
    }

    List<AbstractServerModelUpdate<?>> getUpdates() {
        return new ArrayList(this.updateList);
    }

    List<String> getServerLaunchCommand() {
        ArrayList<String> command = new ArrayList<String>();
        command.add(this.getJavaCommand());
        JvmOptionsBuilderFactory.getInstance().addOptions(this.jvmElement, command);
        for (Map.Entry<String, String> prop : this.systemProperties.entrySet()) {
            StringBuilder sb = new StringBuilder("-D");
            sb.append(prop.getKey());
            sb.append('=');
            sb.append(prop.getValue() == null ? "true" : prop.getValue());
            command.add(sb.toString());
        }
        command.add("-Dorg.jboss.boot.log.file=domain/servers/" + this.serverName + "/log/boot.log");
        command.add("-Dlogging.configuration=file:" + new File("").getAbsolutePath() + "/domain/configuration/logging.properties");
        command.add("-jar");
        command.add("jboss-modules.jar");
        command.add("-mp");
        command.add("modules");
        command.add("-logmodule");
        command.add("org.jboss.logmanager");
        command.add("org.jboss.as.server");
        return command;
    }

    Map<String, String> getServerLaunchEnvironment() {
        Map env = null;
        PropertiesElement pe = this.jvmElement.getEnvironmentVariables();
        env = pe != null ? pe.getProperties() : Collections.emptyMap();
        return env;
    }

    public void addServerProcess() throws IOException {
        List<String> command = this.getServerLaunchCommand();
        Map<String, String> env = this.getServerLaunchEnvironment();
        this.processManagerClient.addProcess(this.serverProcessName, this.authKey, command.toArray(new String[command.size()]), this.environment.getHomeDir().getAbsolutePath(), env);
    }

    public void startServerProcess() throws IOException {
        this.setState(ServerState.BOOTING);
        this.processManagerClient.startProcess(this.serverProcessName);
        ServerManagerCommServiceActivator serverManagerCommActivator = new ServerManagerCommServiceActivator(this.managementSocket);
        ServerStartTask startTask = new ServerStartTask(this.serverName, this.portOffset, Collections.singletonList(serverManagerCommActivator), this.updateList);
        Marshaller marshaller = MARSHALLER_FACTORY.createMarshaller(CONFIG);
        OutputStream os = this.processManagerClient.sendStdin(this.serverProcessName);
        marshaller.start(Marshalling.createByteOutput((OutputStream)os));
        marshaller.writeObject((Object)startTask);
        marshaller.finish();
        marshaller.close();
        os.close();
        this.setState(ServerState.STARTING);
    }

    public void stopServerProcess() throws IOException {
        this.processManagerClient.stopProcess(this.serverProcessName);
    }

    public void removeServerProcess() throws IOException {
        this.processManagerClient.removeProcess(this.serverProcessName);
    }

    public List<UpdateResultHandlerResponse<?>> applyUpdates(List<AbstractServerModelUpdate<?>> updates, boolean allowOverallRollback) {
        if (this.serverManagementConnection == null) {
            IllegalStateException e = new IllegalStateException("Updates can not be applied to a managed server without a management connection");
            UpdateResultHandlerResponse urhr = UpdateResultHandlerResponse.createFailureResponse((Throwable)e);
            ArrayList result = new ArrayList(updates.size());
            for (int i = 0; i < updates.size(); ++i) {
                result.add(urhr);
            }
            return result;
        }
        try {
            return (List)new ApplyUpdatesRequest(updates, allowOverallRollback).executeForResult((ManagementRequestConnectionStrategy)new ManagementRequestConnectionStrategy.ExistingConnectionStrategy(this.serverManagementConnection));
        }
        catch (Exception e) {
            UpdateResultHandlerResponse urhr = UpdateResultHandlerResponse.createFailureResponse((Throwable)e);
            ArrayList result = new ArrayList(updates.size());
            for (int i = 0; i < updates.size(); ++i) {
                result.add(urhr);
            }
            return result;
        }
    }

    public void gracefulShutdown(long timeout) throws IOException {
        throw new UnsupportedOperationException("ServerManager to Server RPC is not implemented");
    }

    public ServerModel getServerModel() {
        try {
            return (ServerModel)new GetServerModelRequest().executeForResult((ManagementRequestConnectionStrategy)new ManagementRequestConnectionStrategy.ExistingConnectionStrategy(this.serverManagementConnection));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to get ServerModel from server [" + this.serverName + "]", e);
        }
    }

    private String getJavaCommand() {
        String javaHome = this.jvmElement.getJavaHome();
        if (javaHome == null) {
            if (this.environment.getDefaultJVM() != null) {
                return this.environment.getDefaultJVM().getAbsolutePath();
            }
            return "java";
        }
        File f = new File(javaHome);
        f = new File(f, "bin");
        f = new File(f, "java");
        return f.getAbsolutePath();
    }

    public void setServerManagementConnection(Connection serverManagementConnection) {
        this.serverManagementConnection = serverManagementConnection;
        this.setState(ServerState.STARTED);
    }

    private void addStandardProperties(Map<String, String> sysProps) {
        File serverDeploymentDir;
        if (!sysProps.containsKey("sun.rmi.dgc.client.gcInterval")) {
            sysProps.put("sun.rmi.dgc.client.gcInterval", "3600000");
        }
        if (!sysProps.containsKey("sun.rmi.dgc.server.gcInterval")) {
            sysProps.put("sun.rmi.dgc.server.gcInterval", "3600000");
        }
        sysProps.put("jboss.home.dir", this.environment.getHomeDir().getAbsolutePath());
        String key = "jboss.server.base.dir";
        if (sysProps.get(key) == null) {
            File serverBaseDir = new File(this.environment.getDomainServersDir(), this.serverName);
            sysProps.put(key, serverBaseDir.getAbsolutePath());
        }
        if (sysProps.get(key = "jboss.server.deploy.dir") == null) {
            serverDeploymentDir = this.environment.getDomainDeploymentDir();
            sysProps.put(key, serverDeploymentDir.getAbsolutePath());
        }
        if (sysProps.get(key = "jboss.server.system.deploy.dir") == null) {
            serverDeploymentDir = this.environment.getDomainSystemDeploymentDir();
            sysProps.put(key, serverDeploymentDir.getAbsolutePath());
        }
    }

    private static Marshaller getMarshaller() throws IOException {
        return ProtocolUtils.getMarshaller((MarshallingConfiguration)ProtocolUtils.MODULAR_CONFIG);
    }

    private static Unmarshaller getUnmarshaller() throws IOException {
        return ProtocolUtils.getUnmarshaller((MarshallingConfiguration)ProtocolUtils.MODULAR_CONFIG);
    }

    static {
        try {
            MARSHALLER_FACTORY = Marshalling.getMarshallerFactory((String)"river", (ClassLoader)Module.getModuleFromDefaultLoader((ModuleIdentifier)ModuleIdentifier.fromString((String)"org.jboss.marshalling.river")).getClassLoader());
        }
        catch (ModuleLoadException e) {
            throw new RuntimeException(e);
        }
        MarshallingConfiguration config = new MarshallingConfiguration();
        config.setVersion(2);
        config.setClassTable((ClassTable)ModularClassTable.getInstance());
        CONFIG = config;
    }

    private class GetServerModelRequest
    extends ManagementRequest<ServerModel> {
        private GetServerModelRequest() {
        }

        protected byte getHandlerId() {
            return 127;
        }

        protected byte getRequestCode() {
            return 32;
        }

        protected byte getResponseCode() {
            return 34;
        }

        protected final ServerModel receiveResponse(InputStream input) throws IOException {
            Unmarshaller unmarshaller = ManagedServer.getUnmarshaller();
            unmarshaller.start(Marshalling.createByteInput((InputStream)input));
            ProtocolUtils.expectHeader((DataInput)unmarshaller, (int)33);
            ServerModel serverModel = (ServerModel)ProtocolUtils.unmarshal((Unmarshaller)unmarshaller, ServerModel.class);
            unmarshaller.finish();
            return serverModel;
        }
    }

    private static class ApplyUpdatesRequest
    extends ManagementRequest<List<UpdateResultHandlerResponse<?>>> {
        private final List<AbstractServerModelUpdate<?>> updates;
        private final boolean allowOverallRollback;

        private ApplyUpdatesRequest(List<AbstractServerModelUpdate<?>> updates, boolean allowOverallRollback) {
            this.updates = updates;
            this.allowOverallRollback = allowOverallRollback;
        }

        protected byte getHandlerId() {
            return 127;
        }

        protected byte getRequestCode() {
            return 16;
        }

        protected byte getResponseCode() {
            return 21;
        }

        protected void sendRequest(int protocolVersion, OutputStream output) throws IOException {
            Marshaller marshaller = ManagedServer.getMarshaller();
            marshaller.start(Marshalling.createByteOutput((OutputStream)output));
            marshaller.writeByte(40);
            marshaller.writeBoolean(this.allowOverallRollback);
            marshaller.writeByte(41);
            marshaller.writeInt(this.updates.size());
            for (AbstractServerModelUpdate<?> update : this.updates) {
                marshaller.writeByte(48);
                marshaller.writeObject(update);
            }
            marshaller.finish();
        }

        protected final List<UpdateResultHandlerResponse<?>> receiveResponse(InputStream input) throws IOException {
            Unmarshaller unmarshaller = ManagedServer.getUnmarshaller();
            unmarshaller.start(Marshalling.createByteInput((InputStream)input));
            ProtocolUtils.expectHeader((DataInput)unmarshaller, (int)49);
            int updateCount = unmarshaller.readInt();
            ArrayList results = new ArrayList(updateCount);
            for (int i = 0; i < updateCount; ++i) {
                ProtocolUtils.expectHeader((DataInput)unmarshaller, (int)50);
                UpdateResultHandlerResponse updateResult = (UpdateResultHandlerResponse)ProtocolUtils.unmarshal((Unmarshaller)unmarshaller, UpdateResultHandlerResponse.class);
                results.add(updateResult);
            }
            unmarshaller.finish();
            return results;
        }
    }

    private static class ServerManagerCommServiceActivator
    implements ServiceActivator,
    Serializable {
        private final InetSocketAddress managementSocket;
        private static final long serialVersionUID = 2522252040771977214L;

        private ServerManagerCommServiceActivator(InetSocketAddress managementSocket) {
            this.managementSocket = managementSocket;
        }

        public void activate(ServiceActivatorContext serviceActivatorContext) {
            BatchBuilder batchBuilder = serviceActivatorContext.getBatchBuilder();
            ServerManagerConnectionService smConnection = new ServerManagerConnectionService();
            batchBuilder.addService(ServerManagerConnectionService.SERVICE_NAME, (Service)smConnection).addInjection(smConnection.getSmAddressInjector(), (Object)this.managementSocket).setInitialMode(ServiceController.Mode.ACTIVE);
            ServerManagerClient client = new ServerManagerClient();
            batchBuilder.addService(ServerManagerClient.SERVICE_NAME, (Service)client).addDependency(ServerManagerConnectionService.SERVICE_NAME, Connection.class, client.getSmConnectionInjector()).addDependency(ServerController.SERVICE_NAME, ServerController.class, client.getServerControllerInjector()).setInitialMode(ServiceController.Mode.ACTIVE);
        }
    }
}

