/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.manager;

import java.net.InetSocketAddress;
import org.jboss.as.model.DomainModel;
import org.jboss.as.server.manager.DomainControllerConnection;
import org.jboss.as.server.manager.ServerManager;
import org.jboss.as.services.net.NetworkInterfaceBinding;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class ServerManagerService
implements Service<Void> {
    private final ServerManager serverManager;
    private final InjectedValue<NetworkInterfaceBinding> managementInterface = new InjectedValue();
    private final InjectedValue<Integer> managementPort = new InjectedValue();
    private final InjectedValue<DomainControllerConnection> domainControllerConnection = new InjectedValue();

    public ServerManagerService(ServerManager serverManager) {
        this.serverManager = serverManager;
    }

    public void start(StartContext context) throws StartException {
        DomainControllerConnection domainControllerConnection = (DomainControllerConnection)this.domainControllerConnection.getValue();
        this.serverManager.setDomainControllerConnection(domainControllerConnection);
        DomainModel domainModel = domainControllerConnection.register();
        this.serverManager.setDomain(domainModel);
        NetworkInterfaceBinding interfaceBinding = (NetworkInterfaceBinding)this.managementInterface.getValue();
        InetSocketAddress managementSocketAddress = new InetSocketAddress(interfaceBinding.getAddress(), (int)((Integer)this.managementPort.getValue()));
        this.serverManager.setManagementSocketAddress(managementSocketAddress);
        this.serverManager.startServers();
    }

    public void stop(StopContext context) {
    }

    public Void getValue() throws IllegalStateException {
        return null;
    }

    public Injector<NetworkInterfaceBinding> getManagementInterfaceInjector() {
        return this.managementInterface;
    }

    public Injector<Integer> getManagementPortInjector() {
        return this.managementPort;
    }

    public Injector<DomainControllerConnection> getDomainControllerConnectionInjector() {
        return this.domainControllerConnection;
    }
}

