/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.InetSocketAddress;
import java.util.Arrays;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.as.server.ServerTask;
import org.jboss.logmanager.Level;
import org.jboss.logmanager.Logger;
import org.jboss.logmanager.log4j.BridgeRepositorySelector;
import org.jboss.marshalling.ByteInput;
import org.jboss.marshalling.ClassTable;
import org.jboss.marshalling.MarshallerFactory;
import org.jboss.marshalling.Marshalling;
import org.jboss.marshalling.MarshallingConfiguration;
import org.jboss.marshalling.ModularClassTable;
import org.jboss.marshalling.Unmarshaller;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.msc.service.ServiceActivator;
import org.jboss.msc.service.ServiceActivatorContext;
import org.jboss.stdio.LoggingOutputStream;
import org.jboss.stdio.NullInputStream;
import org.jboss.stdio.SimpleStdioContextSelector;
import org.jboss.stdio.StdioContext;
import org.jboss.stdio.StdioContextSelector;

public final class DomainServerMain {
    private DomainServerMain() {
    }

    public static void main(String[] args) {
        ByteInput byteInput;
        Unmarshaller unmarshaller;
        MarshallerFactory factory;
        System.setProperty("log4j.defaultInitOverride", "true");
        new BridgeRepositorySelector().start();
        InputStream initialInput = System.in;
        PrintStream initialError = System.err;
        StdioContext.install();
        StdioContext context = StdioContext.create((InputStream)new NullInputStream(), (OutputStream)new LoggingOutputStream((java.util.logging.Logger)Logger.getLogger((String)"stdout"), (java.util.logging.Level)Level.INFO), (OutputStream)new LoggingOutputStream((java.util.logging.Logger)Logger.getLogger((String)"stderr"), (java.util.logging.Level)Level.ERROR));
        StdioContext.setStdioContextSelector((StdioContextSelector)new SimpleStdioContextSelector(context));
        byte[] authKey = new byte[16];
        try {
            StreamUtils.readFully((InputStream)initialInput, (byte[])authKey);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
            throw new IllegalStateException();
        }
        try {
            factory = Marshalling.getMarshallerFactory((String)"river", (ClassLoader)Module.getModuleFromDefaultLoader((ModuleIdentifier)ModuleIdentifier.fromString((String)"org.jboss.marshalling.river")).getClassLoader());
        }
        catch (ModuleLoadException e) {
            throw new IllegalStateException("Failed to start server", e);
        }
        try {
            MarshallingConfiguration configuration = new MarshallingConfiguration();
            configuration.setVersion(2);
            configuration.setClassTable((ClassTable)ModularClassTable.getInstance());
            unmarshaller = factory.createUnmarshaller(configuration);
            byteInput = Marshalling.createByteInput((InputStream)initialInput);
            unmarshaller.start(byteInput);
            ServerTask task = (ServerTask)unmarshaller.readObject(ServerTask.class);
            unmarshaller.finish();
            task.run(Arrays.asList(new ServiceActivator(){

                public void activate(ServiceActivatorContext serviceActivatorContext) {
                }
            }));
        }
        catch (Exception e) {
            e.printStackTrace(initialError);
            System.exit(1);
            throw new IllegalStateException();
        }
        while (true) {
            try {
                unmarshaller.start(byteInput);
                InetSocketAddress socketAddress = (InetSocketAddress)unmarshaller.readObject(InetSocketAddress.class);
                unmarshaller.finish();
            }
            catch (InterruptedIOException e) {
                Thread.interrupted();
                continue;
            }
            catch (EOFException e) {
            }
            catch (Exception e) {
                // empty catch block
            }
            break;
        }
        System.exit(0);
        throw new IllegalStateException();
    }
}

