/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server;

import java.io.File;
import java.util.Properties;

public class ServerEnvironment {
    public static final String HOME_DIR = "jboss.home.dir";
    public static final String MODULES_DIR = "jboss.modules.dir";
    public static final String SERVER_BASE_DIR = "jboss.server.base.dir";
    public static final String SERVER_CONFIG_DIR = "jboss.server.config.dir";
    public static final String SERVER_DATA_DIR = "jboss.server.data.dir";
    public static final String SERVER_DEPLOY_DIR = "jboss.server.deploy.dir";
    public static final String SERVER_LOG_DIR = "jboss.server.log.dir";
    public static final String SERVER_TEMP_DIR = "jboss.server.temp.dir";
    public static final String SERVER_SYSTEM_DEPLOY_DIR = "jboss.server.system.deploy.dir";
    private final String processName;
    private final File homeDir;
    private final File modulesDir;
    private final File serverBaseDir;
    private final File serverConfigurationDir;
    private final File serverDataDir;
    private final File serverDeployDir;
    private final File serverLogDir;
    private final File serverTempDir;
    private final boolean standalone;
    private final File serverSystemDeployDir;

    public ServerEnvironment(Properties props, String processName, boolean standalone) {
        this.standalone = standalone;
        if (props == null) {
            throw new IllegalArgumentException("props is null");
        }
        if (processName == null && !standalone) {
            throw new IllegalArgumentException("processName is null");
        }
        this.processName = processName;
        this.homeDir = this.getFileFromProperty(HOME_DIR, props);
        if (this.homeDir == null) {
            throw new IllegalStateException("Missing configuration value for: jboss.home.dir");
        }
        System.setProperty(HOME_DIR, this.homeDir.getAbsolutePath());
        File tmp = this.getFileFromProperty(MODULES_DIR, props);
        if (tmp == null) {
            tmp = new File(this.homeDir, "modules");
        }
        this.modulesDir = tmp;
        System.setProperty(MODULES_DIR, this.modulesDir.getAbsolutePath());
        tmp = this.getFileFromProperty(SERVER_BASE_DIR, props);
        if (tmp == null) {
            tmp = new File(this.homeDir, "standalone");
        }
        this.serverBaseDir = tmp;
        System.setProperty(SERVER_BASE_DIR, this.serverBaseDir.getAbsolutePath());
        tmp = this.getFileFromProperty(SERVER_CONFIG_DIR, props);
        if (tmp == null) {
            tmp = new File(this.serverBaseDir, "configuration");
        }
        this.serverConfigurationDir = tmp;
        System.setProperty(SERVER_CONFIG_DIR, this.serverConfigurationDir.getAbsolutePath());
        tmp = this.getFileFromProperty(SERVER_DATA_DIR, props);
        if (tmp == null) {
            tmp = new File(this.serverBaseDir, "data");
        }
        this.serverDataDir = tmp;
        System.setProperty(SERVER_DATA_DIR, this.serverDataDir.getAbsolutePath());
        tmp = this.getFileFromProperty(SERVER_DEPLOY_DIR, props);
        if (tmp == null) {
            tmp = new File(this.serverDataDir, "content");
        }
        this.serverDeployDir = tmp;
        System.setProperty(SERVER_DEPLOY_DIR, this.serverDeployDir.getAbsolutePath());
        tmp = this.getFileFromProperty(SERVER_SYSTEM_DEPLOY_DIR, props);
        if (tmp == null) {
            tmp = new File(this.serverDataDir, "system-content");
        }
        this.serverSystemDeployDir = tmp;
        System.setProperty(SERVER_SYSTEM_DEPLOY_DIR, this.serverSystemDeployDir.getAbsolutePath());
        tmp = this.getFileFromProperty(SERVER_LOG_DIR, props);
        if (tmp == null) {
            tmp = new File(this.serverBaseDir, "log");
        }
        this.serverLogDir = tmp;
        System.setProperty(SERVER_LOG_DIR, this.serverLogDir.getAbsolutePath());
        tmp = this.getFileFromProperty(SERVER_TEMP_DIR, props);
        if (tmp == null) {
            tmp = new File(this.serverBaseDir, "tmp");
        }
        this.serverTempDir = tmp;
        System.setProperty(SERVER_TEMP_DIR, this.serverTempDir.getAbsolutePath());
    }

    public String getProcessName() {
        return this.processName;
    }

    public File getHomeDir() {
        return this.homeDir;
    }

    public File getModulesDir() {
        return this.modulesDir;
    }

    public File getServerBaseDir() {
        return this.serverBaseDir;
    }

    public File getServerConfigurationDir() {
        return this.serverConfigurationDir;
    }

    public File getServerDataDir() {
        return this.serverDataDir;
    }

    public File getServerDeployDir() {
        return this.serverDeployDir;
    }

    public File getServerSystemDeployDir() {
        return this.serverSystemDeployDir;
    }

    public File getServerLogDir() {
        return this.serverLogDir;
    }

    public File getServerTempDir() {
        return this.serverTempDir;
    }

    public boolean isStandalone() {
        return this.standalone;
    }

    private File getFileFromProperty(String name, Properties props) {
        String value = props.getProperty(name, null);
        if (value != null) {
            File f = new File(value);
            return f;
        }
        return null;
    }
}

