/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server;

import java.io.Closeable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.jboss.as.model.AbstractServerModelUpdate;
import org.jboss.as.model.ServerModel;
import org.jboss.as.model.UpdateResultHandlerResponse;
import org.jboss.as.protocol.Connection;
import org.jboss.as.protocol.MessageHandler;
import org.jboss.as.protocol.ProtocolUtils;
import org.jboss.as.protocol.SimpleByteDataInput;
import org.jboss.as.protocol.SimpleByteDataOutput;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.as.protocol.mgmt.AbstractMessageHandler;
import org.jboss.as.protocol.mgmt.ManagementRequest;
import org.jboss.as.protocol.mgmt.ManagementRequestConnectionStrategy;
import org.jboss.as.protocol.mgmt.ManagementRequestHeader;
import org.jboss.as.protocol.mgmt.ManagementResponse;
import org.jboss.as.protocol.mgmt.ManagementResponseHeader;
import org.jboss.as.server.ServerController;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.Marshalling;
import org.jboss.marshalling.MarshallingConfiguration;
import org.jboss.marshalling.Unmarshaller;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class ServerManagerClient
implements Service<Void> {
    public static final ServiceName SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"server", "manager", "client"});
    private final InjectedValue<Connection> smConnection = new InjectedValue();
    private final InjectedValue<ServerController> serverController = new InjectedValue();
    private MessageHandler managementHeaderMessageHandler = new AbstractMessageHandler(){

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void handle(Connection connection, InputStream dataStream) throws IOException {
            SimpleByteDataInput input = null;
            input = new SimpleByteDataInput(dataStream);
            ManagementRequestHeader requestHeader = new ManagementRequestHeader((DataInput)input);
            int workingVersion = Math.min(1, requestHeader.getVersion());
            byte handlerId = requestHeader.getOperationHandlerId();
            if (handlerId == -1) {
                throw new IOException("Management request failed.  Invalid handler id");
            }
            connection.setMessageHandler(ServerManagerClient.this.requestStartHeader);
            StreamUtils.safeClose((Closeable)input);
            OutputStream dataOutput = null;
            SimpleByteDataOutput output = null;
            try {
                dataOutput = connection.writeMessage();
                output = new SimpleByteDataOutput(dataOutput);
                ManagementResponseHeader responseHeader = new ManagementResponseHeader(workingVersion, requestHeader.getRequestId());
                responseHeader.write((DataOutput)output);
                output.close();
                dataOutput.close();
            }
            catch (IOException e) {
                try {
                    throw e;
                    catch (Throwable t) {
                        throw new IOException("Failed to write management response headers", t);
                    }
                }
                catch (Throwable throwable) {
                    StreamUtils.safeClose(output);
                    StreamUtils.safeClose((Closeable)dataOutput);
                    throw throwable;
                }
            }
            catch (IOException e) {
                try {
                    throw e;
                    catch (Throwable t) {
                        throw new IOException("Failed to read request header", t);
                    }
                }
                catch (Throwable throwable) {
                    StreamUtils.safeClose(input);
                    throw throwable;
                }
            }
            StreamUtils.safeClose((Closeable)output);
            StreamUtils.safeClose((Closeable)dataOutput);
        }
    };
    private MessageHandler requestStartHeader = new AbstractMessageHandler(){

        public void handle(Connection connection, InputStream input) throws IOException {
            ProtocolUtils.expectHeader((InputStream)input, (int)2);
            byte commandCode = StreamUtils.readByte((InputStream)input);
            ManagementResponse operation = ServerManagerClient.this.operationFor(commandCode);
            if (operation == null) {
                throw new IOException("Invalid command code " + commandCode + " received");
            }
            operation.handle(connection, input);
        }
    };

    public void start(StartContext context) throws StartException {
        Connection smConnection = (Connection)this.smConnection.getValue();
        try {
            new ServerRegisterRequest().executeForResult((ManagementRequestConnectionStrategy)new ManagementRequestConnectionStrategy.ExistingConnectionStrategy(smConnection));
        }
        catch (Exception e) {
            throw new StartException("Failed to send registration message to server manager", (Throwable)e);
        }
        smConnection.setMessageHandler(this.managementHeaderMessageHandler);
    }

    public void stop(StopContext context) {
    }

    public Void getValue() throws IllegalStateException {
        return null;
    }

    public Injector<Connection> getSmConnectionInjector() {
        return this.smConnection;
    }

    public Injector<ServerController> getServerControllerInjector() {
        return this.serverController;
    }

    private ManagementResponse operationFor(byte commandByte) {
        switch (commandByte) {
            case 16: {
                return new ApplyServerModelUpdatesOperation();
            }
            case 32: {
                return new GetServerModelOperation();
            }
        }
        return null;
    }

    private static Marshaller getMarshaller() throws IOException {
        return ProtocolUtils.getMarshaller((MarshallingConfiguration)ProtocolUtils.MODULAR_CONFIG);
    }

    private static Unmarshaller getUnmarshaller() throws IOException {
        return ProtocolUtils.getUnmarshaller((MarshallingConfiguration)ProtocolUtils.MODULAR_CONFIG);
    }

    private class GetServerModelOperation
    extends ManagementResponse {
        private GetServerModelOperation() {
            super(ServerManagerClient.this.managementHeaderMessageHandler);
        }

        protected byte getResponseCode() {
            return 34;
        }

        protected void readRequest(InputStream input) throws IOException {
            super.readRequest(input);
        }

        protected void sendResponse(OutputStream output) throws IOException {
            ServerModel sm = ((ServerController)ServerManagerClient.this.serverController.getValue()).getServerModel();
            Marshaller marshaller = ServerManagerClient.getMarshaller();
            marshaller.start(Marshalling.createByteOutput((OutputStream)output));
            marshaller.writeByte(33);
            marshaller.writeObject((Object)sm);
            marshaller.finish();
        }
    }

    private class ApplyServerModelUpdatesOperation
    extends ManagementResponse {
        private List<AbstractServerModelUpdate<?>> updates;
        private boolean allowRollback;

        private ApplyServerModelUpdatesOperation() {
            super(ServerManagerClient.this.managementHeaderMessageHandler);
        }

        protected byte getResponseCode() {
            return 21;
        }

        protected final void readRequest(InputStream inputStream) throws IOException {
            Unmarshaller unmarshaller = ServerManagerClient.getUnmarshaller();
            unmarshaller.start(Marshalling.createByteInput((InputStream)inputStream));
            ProtocolUtils.expectHeader((DataInput)unmarshaller, (int)40);
            this.allowRollback = unmarshaller.readBoolean();
            ProtocolUtils.expectHeader((DataInput)unmarshaller, (int)41);
            int count = unmarshaller.readInt();
            this.updates = new ArrayList(count);
            for (int i = 0; i < count; ++i) {
                ProtocolUtils.expectHeader((DataInput)unmarshaller, (int)48);
                AbstractServerModelUpdate update = (AbstractServerModelUpdate)ProtocolUtils.unmarshal((Unmarshaller)unmarshaller, AbstractServerModelUpdate.class);
                this.updates.add(update);
            }
            unmarshaller.finish();
        }

        protected void sendResponse(OutputStream output) throws IOException {
            List<UpdateResultHandlerResponse<?>> responses = this.processUpdates();
            Marshaller marshaller = ServerManagerClient.getMarshaller();
            marshaller.start(Marshalling.createByteOutput((OutputStream)output));
            marshaller.writeByte(49);
            marshaller.writeInt(responses.size());
            for (UpdateResultHandlerResponse<?> response : responses) {
                marshaller.writeByte(50);
                marshaller.writeObject(response);
            }
            marshaller.finish();
        }

        private List<UpdateResultHandlerResponse<?>> processUpdates() {
            return ((ServerController)ServerManagerClient.this.serverController.getValue()).applyUpdates(this.updates, this.allowRollback, false);
        }
    }

    private class ServerRegisterRequest
    extends ManagementRequest<Void> {
        private ServerRegisterRequest() {
        }

        protected byte getHandlerId() {
            return 127;
        }

        protected byte getRequestCode() {
            return 0;
        }

        protected byte getResponseCode() {
            return 2;
        }

        protected void sendRequest(int protocolVersion, OutputStream output) throws IOException {
            output.write(1);
            StreamUtils.writeUTFZBytes((OutputStream)output, (String)((ServerController)ServerManagerClient.this.serverController.getValue()).getServerModel().getServerName());
        }
    }
}

