/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server;

import java.util.Collection;
import org.jboss.as.server.ServerStartupListener;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.BatchBuilder;
import org.jboss.msc.service.BatchServiceBuilder;
import org.jboss.msc.service.Location;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistryException;
import org.jboss.msc.value.Value;

public class ServerStartBatchBuilder
implements BatchBuilder {
    private final BatchBuilder delegate;
    private final ServerStartupListener serverStartupListener;

    public ServerStartBatchBuilder(BatchBuilder delegate, ServerStartupListener serverStartupListener) {
        this.delegate = delegate;
        this.serverStartupListener = serverStartupListener;
    }

    public <T> BatchServiceBuilder<T> addServiceValue(ServiceName name, Value<? extends Service<T>> value) throws IllegalArgumentException {
        return new ServerStartBatchServiceBuilder(name, this.delegate.addServiceValue(name, value));
    }

    public <T> BatchServiceBuilder<T> addService(ServiceName name, Service<T> service) throws IllegalArgumentException {
        return new ServerStartBatchServiceBuilder(name, this.delegate.addService(name, service));
    }

    public <T> BatchServiceBuilder<T> addServiceValueIfNotExist(ServiceName name, Value<? extends Service<T>> value) throws IllegalArgumentException {
        return new ServerStartBatchServiceBuilder(name, this.delegate.addServiceValueIfNotExist(name, value));
    }

    public BatchBuilder addListener(ServiceListener<Object> listener) {
        this.delegate.addListener(listener);
        return this;
    }

    public BatchBuilder addListener(ServiceListener<Object> ... listeners) {
        this.delegate.addListener(listeners);
        return this;
    }

    public BatchBuilder addListener(Collection<ServiceListener<Object>> listeners) {
        this.delegate.addListener(listeners);
        return this;
    }

    public BatchBuilder addDependency(ServiceName dependency) {
        this.delegate.addDependency(dependency);
        return this;
    }

    public BatchBuilder addDependency(ServiceName ... dependencies) {
        this.delegate.addDependency(dependencies);
        return this;
    }

    public BatchBuilder addDependency(Collection<ServiceName> dependencies) {
        this.delegate.addDependency(dependencies);
        return this;
    }

    public void install() throws ServiceRegistryException {
        this.delegate.install();
    }

    public BatchBuilder subBatchBuilder() {
        return new ServerStartBatchBuilder(this.delegate.subBatchBuilder(), this.serverStartupListener);
    }

    private class ServerStartBatchServiceBuilder<T>
    implements BatchServiceBuilder<T> {
        private final ServiceName serviceName;
        final BatchServiceBuilder<T> delegate;

        private ServerStartBatchServiceBuilder(ServiceName serviceName, BatchServiceBuilder<T> delegate) {
            this.serviceName = serviceName;
            this.delegate = delegate;
        }

        public BatchServiceBuilder<T> addAliases(ServiceName ... aliases) {
            this.delegate.addAliases(aliases);
            return this;
        }

        public BatchServiceBuilder<T> setLocation() {
            this.delegate.setLocation();
            return this;
        }

        public BatchServiceBuilder<T> setLocation(Location location) {
            this.delegate.setLocation(location);
            return this;
        }

        public BatchServiceBuilder<T> setInitialMode(ServiceController.Mode mode) {
            if (mode != ServiceController.Mode.ACTIVE) {
                ServerStartBatchBuilder.this.serverStartupListener.expectNonActive(this.serviceName);
            } else {
                ServerStartBatchBuilder.this.serverStartupListener.unexpectNonActive(this.serviceName);
            }
            this.delegate.setInitialMode(mode);
            return this;
        }

        public BatchServiceBuilder<T> addDependencies(ServiceName ... dependencies) {
            this.delegate.addDependencies(dependencies);
            return this;
        }

        public BatchServiceBuilder<T> addOptionalDependencies(ServiceName ... dependencies) {
            this.delegate.addOptionalDependencies(dependencies);
            return this;
        }

        public BatchServiceBuilder<T> addDependencies(Iterable<ServiceName> dependencies) {
            this.delegate.addDependencies(dependencies);
            return this;
        }

        public BatchServiceBuilder<T> addOptionalDependencies(Iterable<ServiceName> dependencies) {
            this.delegate.addOptionalDependencies(dependencies);
            return this;
        }

        public BatchServiceBuilder<T> addDependency(ServiceName dependency) {
            this.delegate.addDependency(dependency);
            return this;
        }

        public BatchServiceBuilder<T> addOptionalDependency(ServiceName dependency) {
            this.delegate.addOptionalDependency(dependency);
            return this;
        }

        public BatchServiceBuilder<T> addDependency(ServiceName dependency, Injector<Object> target) {
            this.delegate.addDependency(dependency, target);
            return this;
        }

        public BatchServiceBuilder<T> addOptionalDependency(ServiceName dependency, Injector<Object> target) {
            this.delegate.addOptionalDependency(dependency, target);
            return this;
        }

        public <I> BatchServiceBuilder<T> addDependency(ServiceName dependency, Class<I> type, Injector<I> target) {
            this.delegate.addDependency(dependency, type, target);
            return this;
        }

        public <I> BatchServiceBuilder<T> addOptionalDependency(ServiceName dependency, Class<I> type, Injector<I> target) {
            this.delegate.addOptionalDependency(dependency, type, target);
            return this;
        }

        public <I> BatchServiceBuilder<T> addInjection(Injector<? super I> target, I value) {
            this.delegate.addInjection(target, value);
            return this;
        }

        public <I> BatchServiceBuilder<T> addInjectionValue(Injector<? super I> target, Value<I> value) {
            this.delegate.addInjectionValue(target, value);
            return this;
        }

        public BatchServiceBuilder<T> addListener(ServiceListener<? super T> serviceListener) {
            this.delegate.addListener(serviceListener);
            return this;
        }

        public BatchServiceBuilder<T> addListener(ServiceListener<? super T> ... serviceListeners) {
            this.delegate.addListener(serviceListeners);
            return this;
        }

        public BatchServiceBuilder<T> addListener(Collection<? extends ServiceListener<? super T>> collection) {
            this.delegate.addListener(collection);
            return this;
        }
    }
}

