/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.jboss.logging.Logger;
import org.jboss.modules.Module;
import org.jboss.msc.service.AbstractServiceListener;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartException;

public class ServerStartupListener
extends AbstractServiceListener<Object> {
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.server");
    private volatile int totalServices;
    private volatile int startedServices;
    private volatile int startedNonActiveServices;
    private volatile int count = 0;
    private final long start = Module.getStartTime();
    private final Map<ServiceName, StartException> serviceFailures = new HashMap<ServiceName, StartException>();
    private final Callback finishCallback;
    private Runnable batchCallback;
    private final Set<ServiceName> expectedNonActiveServices = new HashSet<ServiceName>();
    private final AtomicBoolean finished = new AtomicBoolean();
    private final AtomicBoolean callbackRan = new AtomicBoolean();
    private static final AtomicIntegerFieldUpdater<ServerStartupListener> countUpdater = AtomicIntegerFieldUpdater.newUpdater(ServerStartupListener.class, "count");
    private static final AtomicIntegerFieldUpdater<ServerStartupListener> totalServicesUpdater = AtomicIntegerFieldUpdater.newUpdater(ServerStartupListener.class, "totalServices");
    private static final AtomicIntegerFieldUpdater<ServerStartupListener> startedServicesUpdater = AtomicIntegerFieldUpdater.newUpdater(ServerStartupListener.class, "startedServices");
    private static final AtomicIntegerFieldUpdater<ServerStartupListener> startedOnDemandServicesUpdater = AtomicIntegerFieldUpdater.newUpdater(ServerStartupListener.class, "startedNonActiveServices");

    public ServerStartupListener(Callback finishCallback) {
        this.finishCallback = finishCallback;
    }

    public void listenerAdded(ServiceController<? extends Object> serviceController) {
        totalServicesUpdater.incrementAndGet(this);
        if (!this.expectedNonActiveServices.contains(serviceController.getName())) {
            countUpdater.incrementAndGet(this);
        }
    }

    public void serviceStarted(ServiceController<? extends Object> serviceController) {
        startedServicesUpdater.incrementAndGet(this);
        if (this.expectedNonActiveServices.contains(serviceController.getName())) {
            startedOnDemandServicesUpdater.incrementAndGet(this);
        }
        if (!this.expectedNonActiveServices.contains(serviceController.getName()) && countUpdater.decrementAndGet(this) == 0) {
            this.batchComplete();
        }
        serviceController.removeListener((ServiceListener)this);
    }

    public void serviceFailed(ServiceController<? extends Object> serviceController, StartException reason) {
        ServiceName serviceName = serviceController.getName();
        log.errorf((Throwable)reason, "Service [%s] start failed", (Object)serviceName);
        this.serviceFailures.put(serviceName, reason);
        if (!this.expectedNonActiveServices.contains(serviceController.getName()) && countUpdater.decrementAndGet(this) == 0) {
            this.batchComplete();
        }
        serviceController.removeListener((ServiceListener)this);
    }

    public void startBatch(Runnable batchCallback) {
        if (this.finished.get()) {
            throw new IllegalStateException("Listener is already finished");
        }
        if (!countUpdater.compareAndSet(this, 0, 1)) {
            throw new IllegalStateException("Listener already has a started batch");
        }
        this.batchCallback = batchCallback;
    }

    public void finishBatch() {
        if (countUpdater.decrementAndGet(this) == 0) {
            this.batchComplete();
        }
    }

    public void finish() {
        this.finished.set(true);
    }

    private void batchComplete() {
        boolean finished = this.finished.get();
        if (this.batchCallback != null) {
            this.batchCallback.run();
        }
        if (finished && this.callbackRan.compareAndSet(false, true)) {
            long end = System.currentTimeMillis();
            this.finishCallback.run(this.serviceFailures, end - this.start, this.totalServices, this.expectedNonActiveServices.size() - startedOnDemandServicesUpdater.get(this), this.startedServices);
        }
    }

    public void expectNonActive(ServiceName serviceName) {
        this.expectedNonActiveServices.add(serviceName);
    }

    public void unexpectNonActive(ServiceName serviceName) {
        this.expectedNonActiveServices.remove(serviceName);
    }

    public static interface Callback {
        public void run(Map<ServiceName, StartException> var1, long var2, int var4, int var5, int var6);
    }
}

