/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.stream.XMLInputFactory;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.as.server.ServerStartException;
import org.jboss.as.server.ServerStartTask;
import org.jboss.as.server.StandardElementReaderRegistrar;
import org.jboss.logging.Logger;
import org.jboss.msc.service.ServiceActivator;
import org.jboss.staxmapper.XMLMapper;

public class StandaloneServer {
    private static final String STANDALONE_XML = "standalone.xml";
    private final StandardElementReaderRegistrar extensionRegistrar;
    static final Logger log = Logger.getLogger((String)"org.jboss.as.server");
    private final ServerEnvironment environment;

    public StandaloneServer(ServerEnvironment environment) {
        if (environment == null) {
            throw new IllegalArgumentException("bootstrapConfig is null");
        }
        this.environment = environment;
        this.extensionRegistrar = StandardElementReaderRegistrar.Factory.getRegistrar();
    }

    public void start() throws ServerStartException {
        this.start(Collections.<ServiceActivator>emptyList());
    }

    public void start(List<ServiceActivator> serviceActivators) throws ServerStartException {
        File standalone = new File(this.environment.getServerConfigurationDir(), STANDALONE_XML);
        if (!standalone.isFile()) {
            throw new ServerStartException("File " + standalone.getAbsolutePath() + " does not exist.");
        }
        if (!standalone.canWrite()) {
            throw new ServerStartException("File " + standalone.getAbsolutePath() + " is not writable.");
        }
        ArrayList updates = new ArrayList();
        try {
            XMLMapper mapper = XMLMapper.Factory.create();
            this.extensionRegistrar.registerStandardStandaloneReaders(mapper);
            mapper.parseDocument(updates, XMLInputFactory.newInstance().createXMLStreamReader(new BufferedInputStream(new FileInputStream(standalone))));
        }
        catch (Exception e) {
            throw new ServerStartException("Caught exception during processing of standalone.xml", e);
        }
        ServerStartTask startTask = new ServerStartTask(0, serviceActivators, updates, this.environment);
        startTask.run(Collections.<ServiceActivator>emptyList());
        new Thread(){
            {
                this.setName("Server Life Thread");
                this.setDaemon(false);
                this.setPriority(1);
            }

            @Override
            public void run() {
                while (true) {
                    try {
                        while (true) {
                            1.sleep(1000000L);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    break;
                }
            }
        }.start();
    }
}

