/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.mgmt;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.model.Element;
import org.jboss.as.model.ServerModel;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.as.server.ServerEnvironmentService;
import org.jboss.as.server.mgmt.ServerConfigurationPersister;
import org.jboss.logging.Logger;
import org.jboss.msc.service.BatchBuilder;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.staxmapper.XMLContentWriter;
import org.jboss.staxmapper.XMLExtendedStreamWriter;
import org.jboss.staxmapper.XMLMapper;

public class ServerConfigurationPersisterImpl
implements ServerConfigurationPersister,
Service<ServerConfigurationPersister> {
    private static Logger logger = Logger.getLogger((String)"org.jboss.as.server");
    private final InjectedValue<ServerEnvironment> serverEnvironment = new InjectedValue();
    private final ServerModel configuration;
    private File configFile;

    public static void addService(ServerModel configuration, BatchBuilder batchBuilder) {
        ServerConfigurationPersisterImpl service = new ServerConfigurationPersisterImpl(configuration);
        batchBuilder.addService(SERVICE_NAME, (Service)service).addDependency(ServerEnvironmentService.SERVICE_NAME, ServerEnvironment.class, service.serverEnvironment);
    }

    public ServerConfigurationPersisterImpl(ServerModel configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException("configuration is null");
        }
        this.configuration = configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void configurationModified() {
        if (this.configFile != null) {
            FileOutputStream fos = null;
            BufferedOutputStream bos = null;
            XMLStreamWriter writer = null;
            try {
                this.backupConfigFile();
                this.configFile.createNewFile();
                fos = new FileOutputStream(this.configFile);
                bos = new BufferedOutputStream(fos);
                writer = XMLOutputFactory.newInstance().createXMLStreamWriter(bos);
                XMLMapper mapper = XMLMapper.Factory.create();
                mapper.deparseDocument((XMLContentWriter)new RootElementWriter(), writer);
            }
            catch (Exception e) {
                logger.errorf((Throwable)e, "Failed persisting configuration file %s", (Object)this.configFile.getAbsolutePath());
            }
            finally {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (XMLStreamException e) {
                        logger.warnf((Throwable)e, "Failed closing writer to configuration file %s", (Object)this.configFile.getAbsolutePath());
                    }
                }
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException e) {
                        logger.warnf((Throwable)e, "Failed closing output stream to configuration file %s", (Object)this.configFile.getAbsolutePath());
                    }
                }
            }
        }
    }

    private void backupConfigFile() throws IOException {
        File backup = new File(this.configFile.getParent(), this.configFile.getName() + ".last-known-good");
        this.copyFile(this.configFile, backup);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyFile(File file, File backup) throws IOException {
        if (backup.exists()) {
            backup.delete();
        }
        if (!file.renameTo(backup)) {
            FileOutputStream fos = null;
            FilterOutputStream bos = null;
            FileInputStream fis = null;
            try {
                int read;
                fos = new FileOutputStream(backup);
                bos = new BufferedOutputStream(fos);
                fis = new FileInputStream(file);
                BufferedInputStream bis = new BufferedInputStream(fis);
                byte[] bytes = new byte[8192];
                while ((read = bis.read(bytes)) > -1) {
                    ((BufferedOutputStream)bos).write(bytes, 0, read);
                }
            }
            finally {
                try {
                    if (bos != null) {
                        bos.close();
                    }
                }
                catch (Exception ignored) {}
                try {
                    if (fos != null) {
                        fos.close();
                    }
                }
                catch (Exception ignored) {}
                try {
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (Exception ignored) {}
            }
        }
    }

    public void start(StartContext context) throws StartException {
        ServerEnvironment env;
        try {
            env = (ServerEnvironment)this.serverEnvironment.getValue();
        }
        catch (IllegalStateException ise) {
            throw new StartException(ServerEnvironment.class.getSimpleName() + " was not injected");
        }
        if (env.isStandalone()) {
            File configDir = env.getServerConfigurationDir();
            if (configDir.exists()) {
                if (!configDir.isDirectory()) {
                    throw new StartException(configDir.getAbsolutePath() + " is not a directory");
                }
                if (!configDir.canWrite()) {
                    throw new StartException(configDir.getAbsolutePath() + " is not a writable");
                }
            } else if (!configDir.mkdirs()) {
                throw new StartException("Cannot create directory " + configDir.getAbsolutePath());
            }
            this.configFile = new File(configDir, "standalone.xml");
            if (this.configFile.exists()) {
                if (this.configFile.isDirectory()) {
                    throw new StartException(this.configFile.getAbsolutePath() + " is a directory");
                }
                if (!configDir.canWrite()) {
                    throw new StartException(this.configFile.getAbsolutePath() + " is not a writable");
                }
            }
        }
    }

    public void stop(StopContext context) {
        this.configFile = null;
    }

    public ServerConfigurationPersister getValue() throws IllegalStateException {
        return this;
    }

    private class RootElementWriter
    implements XMLContentWriter {
        private RootElementWriter() {
        }

        public void writeContent(XMLExtendedStreamWriter streamWriter) throws XMLStreamException {
            streamWriter.writeStartDocument();
            streamWriter.writeStartElement(Element.SERVER.getLocalName());
            ServerConfigurationPersisterImpl.this.configuration.writeContent(streamWriter);
            streamWriter.writeEndDocument();
        }
    }
}

