/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.mgmt.deployment;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.jboss.as.deployment.ServerDeploymentRepository;
import org.jboss.as.model.ServerGroupDeploymentElement;
import org.jboss.as.model.ServerModel;
import org.jboss.as.model.ServerModelDeploymentAdd;
import org.jboss.as.model.ServerModelDeploymentFullReplaceUpdate;
import org.jboss.as.model.ServerModelDeploymentRemove;
import org.jboss.as.model.ServerModelDeploymentReplaceUpdate;
import org.jboss.as.model.ServerModelDeploymentStartStopUpdate;
import org.jboss.as.model.UpdateResultHandler;
import org.jboss.as.server.mgmt.ServerConfigurationPersister;
import org.jboss.as.server.mgmt.ServerUpdateController;
import org.jboss.as.server.mgmt.ShutdownHandler;
import org.jboss.as.server.mgmt.SimpleFuture;
import org.jboss.as.standalone.client.api.deployment.AbstractServerUpdateActionResult;
import org.jboss.as.standalone.client.api.deployment.DeploymentPlan;
import org.jboss.as.standalone.client.api.deployment.DuplicateDeploymentNameException;
import org.jboss.as.standalone.client.api.deployment.InitialDeploymentPlanBuilder;
import org.jboss.as.standalone.client.api.deployment.ServerDeploymentActionResult;
import org.jboss.as.standalone.client.api.deployment.ServerDeploymentManager;
import org.jboss.as.standalone.client.api.deployment.ServerDeploymentPlanResult;
import org.jboss.as.standalone.client.api.deployment.ServerUpdateActionResult;
import org.jboss.as.standalone.client.api.deployment.SimpleServerDeploymentActionResult;
import org.jboss.as.standalone.client.impl.deployment.DeploymentActionImpl;
import org.jboss.as.standalone.client.impl.deployment.DeploymentContentDistributor;
import org.jboss.as.standalone.client.impl.deployment.DeploymentPlanImpl;
import org.jboss.as.standalone.client.impl.deployment.DeploymentPlanResultImpl;
import org.jboss.as.standalone.client.impl.deployment.InitialDeploymentPlanBuilderFactory;
import org.jboss.logging.Logger;
import org.jboss.msc.service.BatchBuilder;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class ServerDeploymentManagerImpl
implements ServerDeploymentManager,
Service<ServerDeploymentManager> {
    private static Logger logger = Logger.getLogger((String)"org.jboss.as.server.deployment");
    private final ServerModel serverConfiguration;
    private final ServiceContainer serviceContainer;
    private final InjectedValue<ServerDeploymentRepository> injectedDeploymentRepository = new InjectedValue();
    private final InjectedValue<Executor> injectedDeploymentExecutor = new InjectedValue();
    private final InjectedValue<ServerConfigurationPersister> injectedConfigurationPersister = new InjectedValue();
    private final InjectedValue<ShutdownHandler> injectedShutdownHandler = new InjectedValue();
    private final DeploymentContentDistributor contentDistributor;

    public static void addService(ServerModel serverConfiguration, ServiceContainer serviceContainer, BatchBuilder batchBuilder) {
        ServerDeploymentManagerImpl service = new ServerDeploymentManagerImpl(serverConfiguration, serviceContainer);
        batchBuilder.addService(SERVICE_NAME_LOCAL, (Service)service).addDependency(ServerDeploymentRepository.SERVICE_NAME, ServerDeploymentRepository.class, service.injectedDeploymentRepository).addDependency(ServerConfigurationPersister.SERVICE_NAME, ServerConfigurationPersister.class, service.injectedConfigurationPersister).addDependency(ShutdownHandler.SERVICE_NAME, ShutdownHandler.class, service.injectedShutdownHandler);
        ExecutorService hack = Executors.newCachedThreadPool();
        service.injectedDeploymentExecutor.inject((Object)hack);
    }

    public ServerDeploymentManagerImpl(ServerModel serverConfiguration, ServiceContainer serviceContainer) {
        if (serverConfiguration == null) {
            throw new IllegalArgumentException("serverConfiguration is null");
        }
        if (serviceContainer == null) {
            throw new IllegalArgumentException("serviceContainer is null");
        }
        this.serverConfiguration = serverConfiguration;
        this.serviceContainer = serviceContainer;
        this.contentDistributor = new DeploymentContentDistributor(){

            public byte[] distributeDeploymentContent(String name, String runtimeName, InputStream stream) throws IOException, DuplicateDeploymentNameException {
                if (ServerDeploymentManagerImpl.this.serverConfiguration.getDeployment(name) != null) {
                    throw new DuplicateDeploymentNameException(name, false);
                }
                return ServerDeploymentManagerImpl.this.getDeploymentRepository().addDeploymentContent(name, runtimeName, stream);
            }

            public byte[] distributeReplacementDeploymentContent(String name, String runtimeName, InputStream stream) throws IOException {
                return ServerDeploymentManagerImpl.this.getDeploymentRepository().addDeploymentContent(name, runtimeName, stream);
            }
        };
    }

    public String addDeploymentContent(File file) throws IOException, DuplicateDeploymentNameException {
        String name = file.getName();
        this.getDeploymentContentDistributor().distributeDeploymentContent(name, name, (InputStream)new FileInputStream(file));
        return name;
    }

    public String addDeploymentContent(URL url) throws IOException, DuplicateDeploymentNameException {
        String name = ServerDeploymentManagerImpl.getName(url);
        this.addDeploymentContent(name, name, url);
        return name;
    }

    public void addDeploymentContent(String name, File file) throws IOException, DuplicateDeploymentNameException {
        String commonName = file.getName();
        this.getDeploymentContentDistributor().distributeDeploymentContent(name, commonName, (InputStream)new FileInputStream(file));
    }

    public void addDeploymentContent(String name, URL url) throws IOException, DuplicateDeploymentNameException {
        String commonName = ServerDeploymentManagerImpl.getName(url);
        this.addDeploymentContent(name, commonName, url);
    }

    private void addDeploymentContent(String name, String commonName, URL url) throws IOException, DuplicateDeploymentNameException {
        URLConnection conn = url.openConnection();
        conn.connect();
        this.getDeploymentContentDistributor().distributeDeploymentContent(name, commonName, conn.getInputStream());
    }

    public void addDeploymentContent(String name, InputStream stream) throws IOException, DuplicateDeploymentNameException {
        this.addDeploymentContent(name, name, stream);
    }

    public void addDeploymentContent(String name, String commonName, InputStream stream) throws IOException, DuplicateDeploymentNameException {
        this.getDeploymentContentDistributor().distributeDeploymentContent(name, commonName, stream);
    }

    public Future<ServerDeploymentPlanResult> execute(final DeploymentPlan plan) {
        if (!(plan instanceof DeploymentPlanImpl)) {
            throw new IllegalArgumentException("unexpected " + DeploymentPlan.class.getSimpleName() + " type " + plan.getClass().getName());
        }
        SimpleFuture<ServerDeploymentPlanResult> resultFuture = new SimpleFuture<ServerDeploymentPlanResult>();
        UpdateResultHandlerImpl resultHandler = new UpdateResultHandlerImpl(resultFuture, plan);
        final ServerUpdateController controller = new ServerUpdateController(this.getServerConfiguration(), this.getServiceContainer(), this.getDeploymentExecutor(), resultHandler, plan.isGlobalRollback(), !plan.isShutdown());
        DeploymentPlanImpl planImpl = (DeploymentPlanImpl)plan;
        for (DeploymentActionImpl action : planImpl.getDeploymentActionImpls()) {
            this.addServerGroupDeploymentUpdate(action, resultHandler, controller);
        }
        Runnable r = new Runnable(){

            @Override
            public void run() {
                logger.debugf("Executing deployment plan %s", (Object)plan.getId().toString());
                controller.executeUpdates();
            }
        };
        this.getDeploymentExecutor().execute(r);
        return resultFuture;
    }

    public InitialDeploymentPlanBuilder newDeploymentPlan() {
        return InitialDeploymentPlanBuilderFactory.newInitialDeploymentPlanBuilder((DeploymentContentDistributor)this.getDeploymentContentDistributor());
    }

    public void start(StartContext context) throws StartException {
        String type = null;
        try {
            type = ServerConfigurationPersister.class.getSimpleName();
            this.injectedConfigurationPersister.getValue();
            type = Executor.class.getSimpleName();
            this.injectedDeploymentExecutor.getValue();
            type = ServerDeploymentRepository.class.getSimpleName();
            this.injectedDeploymentRepository.getValue();
            type = ShutdownHandler.class.getSimpleName();
            this.injectedShutdownHandler.getValue();
        }
        catch (IllegalStateException ise) {
            throw new StartException(type + " was not injected");
        }
    }

    public void stop(StopContext context) {
    }

    public ServerDeploymentManager getValue() throws IllegalStateException {
        return this;
    }

    private ServerModel getServerConfiguration() {
        return this.serverConfiguration;
    }

    private Executor getDeploymentExecutor() {
        return (Executor)this.injectedDeploymentExecutor.getValue();
    }

    private DeploymentContentDistributor getDeploymentContentDistributor() {
        return this.contentDistributor;
    }

    private ServerDeploymentRepository getDeploymentRepository() {
        return (ServerDeploymentRepository)this.injectedDeploymentRepository.getValue();
    }

    private ServiceContainer getServiceContainer() {
        return this.serviceContainer;
    }

    private ShutdownHandler getShutdownHandler() {
        return (ShutdownHandler)this.injectedShutdownHandler.getValue();
    }

    private void addServerGroupDeploymentUpdate(DeploymentActionImpl action, UpdateResultHandler<Object, UUID> resultHandler, ServerUpdateController controller) {
        switch (action.getType()) {
            case ADD: {
                controller.addServerModelUpdate(new ServerModelDeploymentAdd(action.getDeploymentUnitUniqueName(), action.getNewContentFileName(), action.getNewContentHash()), resultHandler, action.getId());
                break;
            }
            case REMOVE: {
                controller.addServerModelUpdate(new ServerModelDeploymentRemove(action.getDeploymentUnitUniqueName()), resultHandler, action.getId());
                break;
            }
            case DEPLOY: {
                controller.addServerModelUpdate(new ServerModelDeploymentStartStopUpdate(action.getDeploymentUnitUniqueName(), true), resultHandler, action.getId());
                break;
            }
            case UNDEPLOY: {
                controller.addServerModelUpdate(new ServerModelDeploymentStartStopUpdate(action.getDeploymentUnitUniqueName(), false), resultHandler, action.getId());
                break;
            }
            case REDEPLOY: {
                controller.addServerModelUpdate(new ServerModelDeploymentReplaceUpdate(action.getDeploymentUnitUniqueName(), action.getDeploymentUnitUniqueName()), resultHandler, action.getId());
                break;
            }
            case REPLACE: {
                controller.addServerModelUpdate(new ServerModelDeploymentReplaceUpdate(action.getDeploymentUnitUniqueName(), action.getReplacedDeploymentUnitUniqueName()), resultHandler, action.getId());
                break;
            }
            case FULL_REPLACE: {
                ServerGroupDeploymentElement deployment = this.serverConfiguration.getDeployment(action.getDeploymentUnitUniqueName());
                boolean redeploy = deployment != null && deployment.isStart();
                controller.addServerModelUpdate(new ServerModelDeploymentFullReplaceUpdate(action.getDeploymentUnitUniqueName(), action.getNewContentFileName(), action.getNewContentHash(), redeploy), resultHandler, action.getId());
                break;
            }
            default: {
                throw new IllegalStateException("Unknown type " + action.getType());
            }
        }
    }

    private ServerConfigurationPersister getConfigurationPersister() {
        return (ServerConfigurationPersister)this.injectedConfigurationPersister.getValue();
    }

    private static String getName(URL url) {
        if ("file".equals(url.getProtocol())) {
            try {
                File f = new File(url.toURI());
                return f.getName();
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(url + " is not a valid URI", e);
            }
        }
        String path = url.getPath();
        int idx = path.lastIndexOf(47);
        while (idx == path.length() - 1) {
            path = path.substring(0, idx);
            idx = path.lastIndexOf(47);
        }
        if (idx == -1) {
            throw new IllegalArgumentException("Cannot derive a deployment name from " + url + " -- use an overloaded method variant that takes a 'name' parameter");
        }
        return path.substring(idx + 1);
    }

    private class UpdateResultHandlerImpl
    implements UpdateResultHandler<Object, UUID>,
    ServerUpdateController.ServerUpdateCommitHandler {
        private final Map<UUID, ServerDeploymentActionResult> updateResults = new HashMap<UUID, ServerDeploymentActionResult>();
        private final Set<UUID> successfulRollbacks = new HashSet<UUID>();
        private final Map<UUID, Throwable> failedRollbacks = new HashMap<UUID, Throwable>();
        private final SimpleFuture<ServerDeploymentPlanResult> future;
        private final DeploymentPlan plan;
        private final ServerUpdateActionResult.Result successResult;

        private UpdateResultHandlerImpl(SimpleFuture<ServerDeploymentPlanResult> future, DeploymentPlan plan) {
            this.future = future;
            this.plan = plan;
            this.successResult = plan.isGracefulShutdown() || plan.isShutdown() ? ServerUpdateActionResult.Result.CONFIGURATION_MODIFIED_REQUIRES_RESTART : ServerUpdateActionResult.Result.EXECUTED;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleCancellation(UUID param) {
            Map<UUID, ServerDeploymentActionResult> map = this.updateResults;
            synchronized (map) {
                this.updateResults.put(param, (ServerDeploymentActionResult)new SimpleServerDeploymentActionResult(param, ServerUpdateActionResult.Result.NOT_EXECUTED));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleFailure(Throwable cause, UUID param) {
            Map<UUID, ServerDeploymentActionResult> map = this.updateResults;
            synchronized (map) {
                this.updateResults.put(param, (ServerDeploymentActionResult)new SimpleServerDeploymentActionResult(param, cause));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleRollbackCancellation(UUID param) {
            Map<UUID, Throwable> map = this.failedRollbacks;
            synchronized (map) {
                this.failedRollbacks.put(param, null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleRollbackFailure(Throwable cause, UUID param) {
            Map<UUID, Throwable> map = this.failedRollbacks;
            synchronized (map) {
                this.failedRollbacks.put(param, cause);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleRollbackSuccess(UUID param) {
            Set<UUID> set = this.successfulRollbacks;
            synchronized (set) {
                this.successfulRollbacks.add(param);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleRollbackTimeout(UUID param) {
            Map<UUID, Throwable> map = this.failedRollbacks;
            synchronized (map) {
                this.failedRollbacks.put(param, null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleSuccess(Object result, UUID param) {
            Map<UUID, ServerDeploymentActionResult> map = this.updateResults;
            synchronized (map) {
                this.updateResults.put(param, (ServerDeploymentActionResult)new SimpleServerDeploymentActionResult(param, this.successResult));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleTimeout(UUID param) {
            Map<UUID, ServerDeploymentActionResult> map = this.updateResults;
            synchronized (map) {
                this.updateResults.put(param, (ServerDeploymentActionResult)new SimpleServerDeploymentActionResult(param, ServerUpdateActionResult.Result.FAILED));
            }
        }

        @Override
        public void handleUpdateCommit(ServerUpdateController controller, ServerUpdateController.Status priorStatus) {
            ServerDeploymentManagerImpl.this.getConfigurationPersister().configurationModified();
            this.generateResult(priorStatus);
            if (this.plan.isShutdown()) {
                if (this.plan.getGracefulShutdownTimeout() > -1L) {
                    ServerDeploymentManagerImpl.this.getShutdownHandler().gracefulShutdownRequested(this.plan.getGracefulShutdownTimeout(), TimeUnit.MILLISECONDS);
                } else {
                    ServerDeploymentManagerImpl.this.getShutdownHandler().shutdownRequested();
                }
            }
        }

        private void generateResult(ServerUpdateController.Status status) {
            HashMap<UUID, ServerDeploymentActionResult> planResults = new HashMap<UUID, ServerDeploymentActionResult>();
            for (Map.Entry<UUID, ServerDeploymentActionResult> entry : this.updateResults.entrySet()) {
                ServerDeploymentActionResult actionResult = entry.getValue();
                if (actionResult == null) {
                    actionResult = new SimpleServerDeploymentActionResult(entry.getKey(), ServerUpdateActionResult.Result.EXECUTED);
                }
                if (actionResult.getResult() != ServerUpdateActionResult.Result.NOT_EXECUTED) {
                    SimpleServerDeploymentActionResult rollbackResult = null;
                    if (this.successfulRollbacks.contains(entry.getKey())) {
                        rollbackResult = new SimpleServerDeploymentActionResult(entry.getKey(), ServerUpdateActionResult.Result.EXECUTED);
                    } else if (this.failedRollbacks.containsKey(entry.getKey())) {
                        Throwable cause = this.failedRollbacks.get(entry.getKey());
                        rollbackResult = new SimpleServerDeploymentActionResult(entry.getKey(), cause);
                    }
                    if (rollbackResult != null) {
                        AbstractServerUpdateActionResult.installRollbackResult((AbstractServerUpdateActionResult)((AbstractServerUpdateActionResult)entry.getValue()), (ServerUpdateActionResult)rollbackResult);
                    }
                }
                planResults.put(entry.getKey(), actionResult);
            }
            DeploymentPlanResultImpl result = new DeploymentPlanResultImpl(this.plan.getId(), planResults);
            this.future.set((ServerDeploymentPlanResult)result);
        }
    }
}

