/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.standalone.deployment;

import java.io.File;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.jboss.as.deployment.scanner.DeploymentScanner;
import org.jboss.as.deployment.scanner.DeploymentScannerFactory;
import org.jboss.as.model.ServerModel;
import org.jboss.as.server.standalone.deployment.FileSystemDeploymentService;
import org.jboss.as.standalone.client.api.deployment.ServerDeploymentManager;
import org.jboss.msc.service.BatchBuilder;
import org.jboss.msc.service.BatchServiceBuilder;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class DeploymentScannerFactoryService
implements DeploymentScannerFactory,
Service<DeploymentScannerFactory> {
    private final InjectedValue<ScheduledExecutorService> injectedScheduleExecutor = new InjectedValue();
    private final InjectedValue<ServerDeploymentManager> injectedDeploymentManager = new InjectedValue();
    private final InjectedValue<ServerModel> injectedServerModel = new InjectedValue();
    private ScheduledExecutorService executorService;
    private ServerDeploymentManager deploymentMgr;
    private ServerModel model;

    public static BatchServiceBuilder<?> addService(BatchBuilder builder) {
        DeploymentScannerFactoryService service = new DeploymentScannerFactoryService();
        ScheduledExecutorService hack = Executors.newSingleThreadScheduledExecutor();
        service.injectedScheduleExecutor.inject((Object)hack);
        return builder.addService(DeploymentScannerFactory.SERVICE_NAME, (Service)service).addDependency(ServerDeploymentManager.SERVICE_NAME_LOCAL, ServerDeploymentManager.class, service.injectedDeploymentManager).addDependency(ServerModel.SERVICE_NAME, ServerModel.class, service.injectedServerModel).setInitialMode(ServiceController.Mode.ON_DEMAND);
    }

    public synchronized void start(StartContext context) throws StartException {
        this.model = (ServerModel)this.injectedServerModel.getValue();
        this.executorService = (ScheduledExecutorService)this.injectedScheduleExecutor.getValue();
        this.deploymentMgr = (ServerDeploymentManager)this.injectedDeploymentManager.getValue();
    }

    public synchronized void stop(StopContext context) {
        this.model = null;
        this.executorService = null;
        this.deploymentMgr = null;
    }

    public synchronized DeploymentScanner create(String path, long scanInterval) {
        File deploymentDir = new File(path);
        FileSystemDeploymentService scanner = new FileSystemDeploymentService(deploymentDir, scanInterval);
        scanner.setScheduledExecutor(this.executorService);
        scanner.setDeploymentManager(this.deploymentMgr);
        scanner.setServerModel(this.model);
        scanner.validateAndCreate();
        return scanner;
    }

    public synchronized DeploymentScannerFactory getValue() throws IllegalStateException {
        return this;
    }
}

