/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.standalone.deployment;

import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jboss.as.deployment.scanner.DeploymentScanner;
import org.jboss.as.model.ServerGroupDeploymentElement;
import org.jboss.as.model.ServerModel;
import org.jboss.as.server.standalone.deployment.ExtensibleFilter;
import org.jboss.as.standalone.client.api.deployment.DeploymentAction;
import org.jboss.as.standalone.client.api.deployment.DeploymentPlan;
import org.jboss.as.standalone.client.api.deployment.DeploymentPlanBuilder;
import org.jboss.as.standalone.client.api.deployment.DuplicateDeploymentNameException;
import org.jboss.as.standalone.client.api.deployment.InitialDeploymentPlanBuilder;
import org.jboss.as.standalone.client.api.deployment.ServerDeploymentManager;
import org.jboss.as.standalone.client.api.deployment.ServerDeploymentPlanResult;
import org.jboss.logging.Logger;

class FileSystemDeploymentService
implements DeploymentScanner {
    private static final Set<String> ARCHIVES = new HashSet<String>(Arrays.asList(".jar", ".war", ".ear", ".rar", ".sar", ".beans"));
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.deployment");
    private static final String DEPLOYED = ".deployed";
    private File deploymentDir;
    private long scanInterval = 0L;
    private volatile boolean scanEnabled = false;
    private ScheduledFuture<?> scanTask;
    private final Lock scanLock = new ReentrantLock();
    private Set<String> deployed = new HashSet<String>();
    private ServerModel serverModel;
    private ServerDeploymentManager deploymentManager;
    private ScheduledExecutorService scheduledExecutor;
    private FileFilter filter = new ExtensibleFilter();

    FileSystemDeploymentService(File deploymentDir, long scanInterval) {
        this.deploymentDir = deploymentDir;
        this.scanInterval = scanInterval;
    }

    public boolean isEnabled() {
        return false;
    }

    public long getScanInterval() {
        return this.scanInterval;
    }

    public synchronized void setScanInterval(long scanInterval) {
        if (scanInterval != this.scanInterval) {
            this.cancelScan();
        }
        this.scanInterval = scanInterval;
        this.startScan();
    }

    public boolean isScanEnabled() {
        return this.scanEnabled;
    }

    public synchronized void startScanner() {
        boolean scanEnabled = this.scanEnabled;
        if (scanEnabled) {
            return;
        }
        this.scanEnabled = true;
        this.startScan();
    }

    public synchronized void stopScanner() {
        this.scanEnabled = false;
        this.cancelScan();
    }

    void setDeploymentManager(ServerDeploymentManager deploymentManager) {
        this.deploymentManager = deploymentManager;
    }

    void setScheduledExecutor(ScheduledExecutorService scheduledExecutor) {
        this.scheduledExecutor = scheduledExecutor;
    }

    void setServerModel(ServerModel serverModel) {
        this.serverModel = serverModel;
    }

    void validateAndCreate() {
        if (this.scheduledExecutor == null) {
            throw new IllegalStateException("null scheduled executor");
        }
        if (this.deploymentManager == null) {
            throw new IllegalStateException("null deployment manager");
        }
        if (this.serverModel == null) {
            throw new IllegalStateException("null server model");
        }
        if (this.deploymentDir == null) {
            throw new IllegalStateException("null deployment dir");
        }
        if (!this.deploymentDir.exists()) {
            throw new IllegalArgumentException(this.deploymentDir.getAbsolutePath() + " does not exist");
        }
        if (!this.deploymentDir.isDirectory()) {
            throw new IllegalArgumentException(this.deploymentDir.getAbsolutePath() + " is not a directory");
        }
        if (!this.deploymentDir.canWrite()) {
            throw new IllegalArgumentException(this.deploymentDir.getAbsolutePath() + " is not writable");
        }
        this.establishDeployedContentList(this.deploymentDir);
        this.startScan();
        log.infof("Started %s for directory %s", (Object)this.getClass().getSimpleName(), (Object)this.deploymentDir.getAbsolutePath());
    }

    private void establishDeployedContentList(File dir) {
        File[] children;
        ServerModel serverModel = this.serverModel;
        for (File child : children = dir.listFiles()) {
            String fileName = child.getName();
            if (child.isDirectory()) {
                this.establishDeployedContentList(child);
                continue;
            }
            if (!fileName.endsWith(DEPLOYED)) continue;
            String deploymentName = fileName.substring(0, fileName.length() - DEPLOYED.length());
            if (serverModel.getDeployment(deploymentName) != null) {
                this.deployed.add(deploymentName);
                continue;
            }
            if (child.delete()) continue;
            log.warnf("Cannot removed extraneous deployment marker file %s", (Object)fileName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scan() {
        block15: {
            try {
                this.scanLock.lockInterruptibly();
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                return;
            }
            try {
                if (!this.scanEnabled) break block15;
                log.tracef("Scanning directory %s for deployment content changes", (Object)this.deploymentDir.getAbsolutePath());
                InitialDeploymentPlanBuilder builder = this.deploymentManager.newDeploymentPlan();
                HashMap<String, File> foundDeployed = new HashMap<String, File>();
                HashSet<String> newlyAdded = new HashSet<String>();
                builder = this.scanDirectory(this.deploymentDir, (DeploymentPlanBuilder)builder, foundDeployed, newlyAdded);
                HashSet<String> toRemove = new HashSet<String>(this.deployed);
                toRemove.removeAll(foundDeployed.keySet());
                toRemove.removeAll(newlyAdded);
                for (String missing : toRemove) {
                    builder = builder.undeploy(missing).andRemoveUndeployed();
                }
                Set<String> validFinds = this.cleanSpuriousMarkerFiles(foundDeployed);
                validFinds.addAll(newlyAdded);
                this.deployed = validFinds;
                DeploymentPlan plan = builder.build();
                if (plan.getDeploymentActions().size() > 0) {
                    if (log.isDebugEnabled()) {
                        for (DeploymentAction action : plan.getDeploymentActions()) {
                            log.debugf("Deployment plan %s includes action of type %s affecting deployment %s", (Object)plan.getId(), (Object)action.getType(), (Object)action.getDeploymentUnitUniqueName());
                        }
                    }
                    Future future = this.deploymentManager.execute(plan);
                    try {
                        ServerDeploymentPlanResult result = (ServerDeploymentPlanResult)future.get(60L, TimeUnit.SECONDS);
                    }
                    catch (TimeoutException e) {
                        log.infof("Deployment plan %s did not complete within 60 seconds. Resuming scanning for deployment changes.", (Object)plan.getId());
                    }
                }
                log.tracef("Scan complete", new Object[0]);
            }
            catch (InterruptedException e) {
                log.warn((Object)"Interrupted waiting on completion of deployment plan");
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException e) {
                log.error((Object)("Retrieval of " + ServerDeploymentPlanResult.class.getName() + " threw an exception."), (Throwable)e);
            }
            finally {
                this.scanLock.unlock();
            }
        }
    }

    private Set<String> cleanSpuriousMarkerFiles(Map<String, File> found) {
        HashSet<String> valid = new HashSet<String>();
        for (Map.Entry<String, File> entry : found.entrySet()) {
            if (this.deployed.contains(entry.getKey())) {
                valid.add(entry.getKey());
                continue;
            }
            entry.getValue().delete();
        }
        return valid;
    }

    private DeploymentPlanBuilder scanDirectory(File directory, DeploymentPlanBuilder builder, Map<String, File> foundDeployed, Set<String> newlyAdded) {
        File[] children = directory.listFiles(this.filter);
        if (children == null) {
            return builder;
        }
        for (File child : children) {
            String fileName = child.getName();
            if (fileName.endsWith(DEPLOYED)) {
                String origName = fileName.substring(0, fileName.length() - DEPLOYED.length());
                foundDeployed.put(origName, child);
                continue;
            }
            if (child.isDirectory()) {
                int idx = fileName.lastIndexOf(46);
                if (idx > -1 && ARCHIVES.contains(fileName.substring(idx))) {
                    log.warnf("%s is an exploded deployment and exploded deployments are not currently handled by %s", (Object)child.getName(), (Object)this.getClass().getSimpleName());
                    continue;
                }
                builder = this.scanDirectory(child, builder, foundDeployed, newlyAdded);
                continue;
            }
            DeploymentPlanBuilder currentBuilder = builder;
            boolean uploaded = false;
            boolean replace = false;
            ServerGroupDeploymentElement deployment = this.serverModel.getDeployment(fileName);
            if (deployment != null) {
                if (deployment.isStart()) {
                    replace = true;
                } else {
                    builder = builder.remove(fileName);
                }
            }
            try {
                builder = replace ? builder.replace(child) : builder.add(child).andDeploy();
                uploaded = true;
            }
            catch (IOException e) {
                log.errorf((Throwable)e, "Failed adding deployment content at %s", (Object)child.getAbsolutePath());
            }
            catch (DuplicateDeploymentNameException e) {
                log.warnf("Deployment content with name %s is already installed but was unknown to this filesystem deployment scanner. Replacing the existing content with new content %s.", (Object)fileName, (Object)child.getAbsolutePath());
                try {
                    builder = builder.replace(child);
                    uploaded = true;
                }
                catch (IOException e1) {
                    log.errorf((Throwable)e1, "Failed replacing %s with content at %s", (Object)fileName, (Object)child.getAbsolutePath());
                }
            }
            if (!uploaded) continue;
            if (this.replaceWithDeployedMarker(child)) {
                newlyAdded.add(fileName);
                continue;
            }
            builder = currentBuilder;
        }
        return builder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean replaceWithDeployedMarker(File child) {
        boolean ok = false;
        File marker = new File(child.getParent(), child.getName() + DEPLOYED);
        FileOutputStream fos = null;
        try {
            marker.createNewFile();
            fos = new FileOutputStream(marker);
            fos.write(child.getName().getBytes());
            ok = true;
        }
        catch (IOException io) {
            log.errorf((Throwable)io, "Caught exception writing deployment marker file %s", (Object)marker.getAbsolutePath());
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException ignored) {
                    log.warnf("Could not close output stream for deployment marker file %s", (Object)marker.getAbsolutePath());
                }
            }
        }
        if (ok && !(ok = child.delete())) {
            log.errorf("Cannot remove deployment content file %s", (Object)child.getAbsolutePath());
            marker.delete();
        }
        return ok;
    }

    private synchronized void startScan() {
        if (this.scanEnabled) {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    try {
                        FileSystemDeploymentService.this.scan();
                    }
                    catch (RuntimeException e) {
                        log.errorf((Throwable)e, "Scan of %s threw RuntimeException", (Object)FileSystemDeploymentService.this.deploymentDir.getAbsolutePath());
                    }
                }
            };
            this.scanTask = this.scanInterval > 0L ? this.scheduledExecutor.scheduleWithFixedDelay(r, 0L, this.scanInterval, TimeUnit.MILLISECONDS) : this.scheduledExecutor.schedule(r, this.scanInterval, TimeUnit.MILLISECONDS);
        }
    }

    private void cancelScan() {
        if (this.scanTask != null) {
            this.scanTask.cancel(false);
            this.scanTask = null;
        }
    }
}

