/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.standalone.management;

import java.io.Closeable;
import java.io.DataInput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import org.jboss.as.deployment.ServerDeploymentRepository;
import org.jboss.as.model.AbstractServerModelUpdate;
import org.jboss.as.model.UpdateFailedException;
import org.jboss.as.model.UpdateResultHandler;
import org.jboss.as.protocol.Connection;
import org.jboss.as.protocol.ProtocolUtils;
import org.jboss.as.protocol.SimpleByteDataInput;
import org.jboss.as.protocol.SimpleByteDataOutput;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.as.protocol.mgmt.AbstractMessageHandler;
import org.jboss.as.protocol.mgmt.ManagementException;
import org.jboss.as.protocol.mgmt.ManagementOperationHandler;
import org.jboss.as.protocol.mgmt.ManagementResponse;
import org.jboss.as.server.ServerController;
import org.jboss.as.server.SystemExiter;
import org.jboss.as.server.mgmt.ServerConfigurationPersister;
import org.jboss.as.server.mgmt.ServerUpdateController;
import org.jboss.as.server.mgmt.ShutdownHandler;
import org.jboss.as.standalone.client.api.deployment.DeploymentPlan;
import org.jboss.as.standalone.client.api.deployment.ServerDeploymentManager;
import org.jboss.logging.Logger;
import org.jboss.marshalling.ClassResolver;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.Marshalling;
import org.jboss.marshalling.MarshallingConfiguration;
import org.jboss.marshalling.SimpleClassResolver;
import org.jboss.marshalling.Unmarshaller;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

class ServerControllerOperationHandler
extends AbstractMessageHandler
implements ManagementOperationHandler,
Service<ManagementOperationHandler> {
    private static final MarshallingConfiguration CONFIG = new MarshallingConfiguration();
    private static final Logger log;
    public static final ServiceName SERVICE_NAME;
    private final InjectedValue<ServerController> serverControllerValue = new InjectedValue();
    private final InjectedValue<ShutdownHandler> shutdownHandlerValue = new InjectedValue();
    private final InjectedValue<ServerConfigurationPersister> configurationPersisterValue = new InjectedValue();
    private final InjectedValue<ServerDeploymentManager> deploymentManagerValue = new InjectedValue();
    private final InjectedValue<ServerDeploymentRepository> deploymentRepositoryValue = new InjectedValue();
    private final InjectedValue<Executor> executorValue = new InjectedValue();
    private final ServiceContainer serviceContainer;
    private ServerController serverController;
    private ShutdownHandler shutdownHandler;
    private ServerConfigurationPersister configurationPersister;
    private ServerDeploymentManager deploymentManager;
    private ServerDeploymentRepository deploymentRepository;
    private Executor executor;

    ServerControllerOperationHandler(ServiceContainer serviceContainer) {
        this.serviceContainer = serviceContainer;
    }

    InjectedValue<ServerController> getServerControllerInjector() {
        return this.serverControllerValue;
    }

    InjectedValue<ServerConfigurationPersister> getConfigurationPersisterValue() {
        return this.configurationPersisterValue;
    }

    InjectedValue<ShutdownHandler> getShutdownHandlerValue() {
        return this.shutdownHandlerValue;
    }

    InjectedValue<ServerDeploymentManager> getDeploymentManagerInjector() {
        return this.deploymentManagerValue;
    }

    InjectedValue<ServerDeploymentRepository> getDeploymentRepositoryInjector() {
        return this.deploymentRepositoryValue;
    }

    InjectedValue<Executor> getExecutorValue() {
        return this.executorValue;
    }

    public void start(StartContext context) throws StartException {
        try {
            this.serverController = (ServerController)this.serverControllerValue.getValue();
            this.configurationPersister = (ServerConfigurationPersister)this.configurationPersisterValue.getValue();
            this.shutdownHandler = (ShutdownHandler)this.shutdownHandlerValue.getValue();
            this.deploymentManager = (ServerDeploymentManager)this.deploymentManagerValue.getValue();
            this.deploymentRepository = (ServerDeploymentRepository)this.deploymentRepositoryValue.getValue();
            this.executor = (Executor)this.executorValue.getValue();
        }
        catch (IllegalStateException e) {
            throw new StartException((Throwable)e);
        }
    }

    public void stop(StopContext context) {
        this.serverController = null;
    }

    public ServerControllerOperationHandler getValue() throws IllegalStateException {
        return this;
    }

    public void handle(Connection connection, InputStream input) throws IOException {
        ProtocolUtils.expectHeader((InputStream)input, (int)2);
        byte commandCode = StreamUtils.readByte((InputStream)input);
        AbstractMessageHandler operation = this.operationFor(commandCode);
        if (operation == null) {
            throw new IOException("Invalid command code " + commandCode + " received from standalone client");
        }
        log.debugf("Received operation [%s]", (Object)operation);
        operation.handle(connection, input);
    }

    public byte getIdentifier() {
        return 117;
    }

    private AbstractMessageHandler operationFor(byte commandByte) {
        switch (commandByte) {
            case 118: {
                return new GetServerModel();
            }
            case 85: {
                return new AddDeploymentContentOperation();
            }
            case 69: {
                return new ApplyUpdates();
            }
            case 98: {
                return new CheckUnitDeploymentNameOperation();
            }
            case 81: {
                return new ExecuteDeploymentPlanOperation();
            }
        }
        return null;
    }

    private static Marshaller getMarshaller() throws IOException {
        return ProtocolUtils.getMarshaller((MarshallingConfiguration)CONFIG);
    }

    private static Unmarshaller getUnmarshaller() throws IOException {
        return ProtocolUtils.getUnmarshaller((MarshallingConfiguration)CONFIG);
    }

    static {
        try {
            ModuleClassLoader cl = Module.getModuleFromDefaultLoader((ModuleIdentifier)ModuleIdentifier.create((String)"org.jboss.as.aggregate")).getClassLoader();
            CONFIG.setClassResolver((ClassResolver)new SimpleClassResolver((ClassLoader)cl));
        }
        catch (ModuleLoadException e) {
            throw new RuntimeException(e);
        }
        log = Logger.getLogger((String)"org.jboss.server.management");
        SERVICE_NAME = ServerController.SERVICE_NAME.append(new String[]{"operation", "handler"});
    }

    private class ResultHandler<R, P>
    implements UpdateResultHandler<R, P> {
        UpdateFailedException failure;
        R result;

        private ResultHandler() {
        }

        public void handleSuccess(R result, P param) {
            this.result = result;
        }

        public void handleFailure(Throwable cause, P param) {
            this.failure = cause instanceof UpdateFailedException ? (UpdateFailedException)cause : new UpdateFailedException(cause);
        }

        public void handleCancellation(P param) {
        }

        public void handleTimeout(P param) {
        }

        public void handleRollbackSuccess(P param) {
        }

        public void handleRollbackFailure(Throwable cause, P param) {
        }

        public void handleRollbackCancellation(P param) {
        }

        public void handleRollbackTimeout(P param) {
        }
    }

    private class CheckUnitDeploymentNameOperation
    extends ManagementResponse {
        private String deploymentName;

        private CheckUnitDeploymentNameOperation() {
        }

        protected final byte getResponseCode() {
            return 100;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final void readRequest(InputStream inputStream) throws IOException {
            SimpleByteDataInput input = null;
            try {
                input = new SimpleByteDataInput(inputStream);
                ProtocolUtils.expectHeader((DataInput)input, (int)86);
                this.deploymentName = input.readUTF();
            }
            catch (Throwable throwable) {
                StreamUtils.safeClose(input);
                throw throwable;
            }
            StreamUtils.safeClose((Closeable)input);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void sendResponse(OutputStream outputStream) throws IOException {
            boolean unique = ServerControllerOperationHandler.this.serverController.getServerModel().getDeployment(this.deploymentName) == null;
            SimpleByteDataOutput output = null;
            try {
                output = new SimpleByteDataOutput(outputStream);
                output.writeByte(99);
                output.writeBoolean(unique);
                output.close();
            }
            catch (Throwable throwable) {
                StreamUtils.safeClose(output);
                throw throwable;
            }
            StreamUtils.safeClose((Closeable)output);
        }
    }

    private class ExecuteDeploymentPlanOperation
    extends ManagementResponse {
        private DeploymentPlan deploymentPlan;

        private ExecuteDeploymentPlanOperation() {
        }

        protected final byte getResponseCode() {
            return 84;
        }

        protected final void readRequest(InputStream input) throws IOException {
            Unmarshaller unmarshaller = ServerControllerOperationHandler.getUnmarshaller();
            unmarshaller.start(Marshalling.createByteInput((InputStream)input));
            ProtocolUtils.expectHeader((DataInput)unmarshaller, (int)82);
            this.deploymentPlan = (DeploymentPlan)ProtocolUtils.unmarshal((Unmarshaller)unmarshaller, DeploymentPlan.class);
            unmarshaller.finish();
        }

        protected void sendResponse(OutputStream output) throws IOException {
            Future result = ServerControllerOperationHandler.this.deploymentManager.execute(this.deploymentPlan);
            Marshaller marshaller = ServerControllerOperationHandler.getMarshaller();
            marshaller.start(Marshalling.createByteOutput((OutputStream)output));
            marshaller.writeByte(83);
            try {
                marshaller.writeObject(result.get());
            }
            catch (Exception e) {
                throw new ManagementException("Failed get deployment plan result.", (Throwable)e);
            }
            marshaller.finish();
        }
    }

    private class AddDeploymentContentOperation
    extends ManagementResponse {
        private byte[] deploymentHash;

        private AddDeploymentContentOperation() {
        }

        protected final byte getResponseCode() {
            return 97;
        }

        protected final void readRequest(InputStream inputStream) throws IOException {
            ProtocolUtils.expectHeader((InputStream)inputStream, (int)86);
            String deploymentName = StreamUtils.readUTFZBytes((InputStream)inputStream);
            ProtocolUtils.expectHeader((InputStream)inputStream, (int)87);
            String deploymentRuntimeName = StreamUtils.readUTFZBytes((InputStream)inputStream);
            ProtocolUtils.expectHeader((InputStream)inputStream, (int)88);
            this.deploymentHash = ServerControllerOperationHandler.this.deploymentRepository.addDeploymentContent(deploymentName, deploymentRuntimeName, inputStream);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void sendResponse(OutputStream outputStream) throws IOException {
            SimpleByteDataOutput output = null;
            try {
                output = new SimpleByteDataOutput(outputStream);
                output.writeByte(89);
                output.writeInt(this.deploymentHash.length);
                output.writeByte(96);
                output.write(this.deploymentHash);
                output.close();
            }
            catch (Throwable throwable) {
                StreamUtils.safeClose(output);
                throw throwable;
            }
            StreamUtils.safeClose((Closeable)output);
        }
    }

    private class ApplyUpdates
    extends ManagementResponse {
        private final boolean preventShutdown = false;
        private List<AbstractServerModelUpdate<?>> updates;

        private ApplyUpdates() {
        }

        protected byte getResponseCode() {
            return 80;
        }

        protected void readRequest(InputStream input) throws IOException {
            Unmarshaller unmarshaller = ServerControllerOperationHandler.getUnmarshaller();
            unmarshaller.start(Marshalling.createByteInput((InputStream)input));
            ProtocolUtils.expectHeader((DataInput)unmarshaller, (int)70);
            int count = unmarshaller.readInt();
            this.updates = new ArrayList();
            for (int i = 0; i < count; ++i) {
                ProtocolUtils.expectHeader((DataInput)unmarshaller, (int)105);
                AbstractServerModelUpdate update = (AbstractServerModelUpdate)ProtocolUtils.unmarshal((Unmarshaller)unmarshaller, AbstractServerModelUpdate.class);
                this.updates.add(update);
            }
            unmarshaller.finish();
        }

        protected void sendResponse(OutputStream output) throws IOException {
            ArrayList results = new ArrayList(this.updates.size());
            final CountDownLatch latch = new CountDownLatch(1);
            ServerUpdateController controller = new ServerUpdateController(ServerControllerOperationHandler.this.serverController.getServerModel(), ServerControllerOperationHandler.this.serviceContainer, ServerControllerOperationHandler.this.executor, new ServerUpdateController.ServerUpdateCommitHandler(){

                @Override
                public void handleUpdateCommit(ServerUpdateController controller, ServerUpdateController.Status priorStatus) {
                    ServerControllerOperationHandler.this.configurationPersister.configurationModified();
                    latch.countDown();
                }
            }, true, true);
            boolean requiresRestart = false;
            for (AbstractServerModelUpdate<?> update : this.updates) {
                requiresRestart |= update.requiresRestart();
                results.add(this.addUpdate(update, controller));
            }
            controller.executeUpdates();
            try {
                latch.await();
            }
            catch (Exception e) {
                throw new ManagementException("failed to execute updates", (Throwable)e);
            }
            Marshaller marshaller = ServerControllerOperationHandler.getMarshaller();
            marshaller.start(Marshalling.createByteOutput((OutputStream)output));
            marshaller.writeByte(70);
            marshaller.writeInt(results.size());
            for (ResultHandler resultHandler : results) {
                marshaller.writeByte(72);
                if (resultHandler.failure != null) {
                    marshaller.writeByte(73);
                    marshaller.writeObject((Object)resultHandler.failure);
                    continue;
                }
                marshaller.writeByte(121);
                marshaller.writeObject(resultHandler.result);
            }
            marshaller.finish();
            if (requiresRestart) {
                ServerControllerOperationHandler.this.executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        ServerControllerOperationHandler.this.serverController.shutdown();
                        SystemExiter.exit(10);
                    }
                });
            }
        }

        private <T> ResultHandler<T, Void> addUpdate(AbstractServerModelUpdate<T> update, ServerUpdateController controller) {
            ResultHandler handler = new ResultHandler();
            controller.addServerModelUpdate(update, handler, null);
            return handler;
        }
    }

    private class GetServerModel
    extends ManagementResponse {
        private GetServerModel() {
        }

        protected final byte getResponseCode() {
            return 119;
        }

        protected void sendResponse(OutputStream outputStream) throws IOException {
            Marshaller marshaller = ServerControllerOperationHandler.getMarshaller();
            marshaller.start(Marshalling.createByteOutput((OutputStream)outputStream));
            marshaller.writeByte(120);
            marshaller.writeObject((Object)ServerControllerOperationHandler.this.serverController.getServerModel());
            marshaller.finish();
        }
    }
}

