/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment;

import java.util.Map;
import java.util.Set;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.RuntimeTask;
import org.jboss.as.controller.RuntimeTaskContext;
import org.jboss.as.server.deployment.AbstractDeploymentUnitService;
import org.jboss.as.server.deployment.DeployerChains;
import org.jboss.as.server.deployment.RootDeploymentUnitService;
import org.jboss.as.server.deployment.Services;
import org.jboss.as.server.deployment.api.ServerDeploymentRepository;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.AbstractServiceListener;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartException;

public class DeploymentHandlerUtil {
    private DeploymentHandlerUtil() {
    }

    public static void deploy(final ModelNode deploymentModel, OperationContext context, final ResultHandler resultHandler) throws OperationFailedException {
        if (context.getRuntimeContext() != null) {
            context.getRuntimeContext().setRuntimeTask(new RuntimeTask(){

                public void execute(RuntimeTaskContext runtimeContext) throws OperationFailedException {
                    DeploymentHandlerUtil.deploy(deploymentModel, resultHandler, runtimeContext);
                }
            });
        } else {
            resultHandler.handleResultComplete();
        }
    }

    private static void deploy(ModelNode deploymentModel, final ResultHandler resultHandler, RuntimeTaskContext context) {
        String deploymentUnitName = deploymentModel.require("name").asString();
        ServiceName deploymentUnitServiceName = Services.deploymentUnitName(deploymentUnitName);
        ServiceRegistry serviceRegistry = context.getServiceRegistry();
        ServiceController controller = serviceRegistry.getService(deploymentUnitServiceName);
        if (controller != null) {
            controller.setMode(ServiceController.Mode.ACTIVE);
        } else {
            ServiceTarget serviceTarget = context.getServiceTarget();
            String runtimeName = deploymentModel.require("runtime-name").asString();
            byte[] hash = deploymentModel.require("hash").asBytes();
            RootDeploymentUnitService service = new RootDeploymentUnitService(deploymentUnitName, runtimeName, hash, null, new AbstractDeploymentUnitService.DeploymentCompletionCallback(){

                @Override
                public void handleComplete() {
                    resultHandler.handleResultComplete();
                }

                @Override
                public void handleFailure(Map<ServiceName, StartException> startExceptions, Set<ServiceName> failedDependencies) {
                    StringBuilder failure = new StringBuilder("Deployment failed.  ");
                    if (!startExceptions.isEmpty()) {
                        failure.append("Service failures: ").append(startExceptions.values());
                    }
                    if (!failedDependencies.isEmpty()) {
                        failure.append("Failed Dependencies: ").append(failedDependencies);
                    }
                    resultHandler.handleFailed(new ModelNode().set(failure.toString()));
                }
            });
            serviceTarget.addService(deploymentUnitServiceName, (Service)service).addDependency(Services.JBOSS_DEPLOYMENT_CHAINS, DeployerChains.class, service.getDeployerChainsInjector()).addDependency(ServerDeploymentRepository.SERVICE_NAME, ServerDeploymentRepository.class, service.getServerDeploymentRepositoryInjector()).setInitialMode(ServiceController.Mode.ACTIVE).install();
        }
    }

    public static void redeploy(final ModelNode deploymentModel, OperationContext operationContext, final ResultHandler resultHandler) throws OperationFailedException {
        if (operationContext.getRuntimeContext() != null) {
            operationContext.getRuntimeContext().setRuntimeTask(new RuntimeTask(){

                public void execute(RuntimeTaskContext context) throws OperationFailedException {
                    String deploymentUnitName = deploymentModel.require("name").asString();
                    final ServiceController controller = context.getServiceRegistry().getService(Services.JBOSS_DEPLOYMENT_UNIT.append(new String[]{deploymentUnitName}));
                    if (controller != null) {
                        controller.addListener((ServiceListener)new AbstractServiceListener<Object>(){

                            public void listenerAdded(ServiceController<? extends Object> serviceController) {
                                controller.setMode(ServiceController.Mode.NEVER);
                            }

                            public void serviceStopped(ServiceController<? extends Object> serviceController) {
                                controller.removeListener((ServiceListener)this);
                                controller.addListener((ServiceListener)new ResultHandler.ServiceStartListener(resultHandler));
                                controller.setMode(ServiceController.Mode.ACTIVE);
                            }
                        });
                    } else {
                        DeploymentHandlerUtil.deploy(deploymentModel, resultHandler, context);
                    }
                }
            });
        } else {
            resultHandler.handleResultComplete();
        }
    }

    public static void replace(final ModelNode deploymentModel, final String toReplace, OperationContext operationContext, final ResultHandler resultHandler) throws OperationFailedException {
        if (operationContext.getRuntimeContext() != null) {
            operationContext.getRuntimeContext().setRuntimeTask(new RuntimeTask(){

                public void execute(final RuntimeTaskContext runtimeContext) throws OperationFailedException {
                    final ServiceController controller = runtimeContext.getServiceRegistry().getService(Services.JBOSS_DEPLOYMENT_UNIT.append(new String[]{toReplace}));
                    if (controller != null) {
                        controller.addListener((ServiceListener)new AbstractServiceListener<Object>(){

                            public void listenerAdded(ServiceController<? extends Object> serviceController) {
                                controller.setMode(ServiceController.Mode.REMOVE);
                            }

                            public void serviceRemoved(ServiceController<? extends Object> serviceController) {
                                controller.removeListener((ServiceListener)this);
                                DeploymentHandlerUtil.deploy(deploymentModel, resultHandler, runtimeContext);
                            }
                        });
                    } else {
                        DeploymentHandlerUtil.deploy(deploymentModel, resultHandler, runtimeContext);
                    }
                }
            });
        } else {
            resultHandler.handleResultComplete();
        }
    }
}

