/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment.module;

import org.jboss.as.server.deployment.AttachmentKey;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.logging.Logger;
import org.jboss.vfs.VirtualFile;

public class IgnoreMetaInfMarker {
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.server.deployment.module");
    private static AttachmentKey<Boolean> IGNORE_META_INF = AttachmentKey.create(Boolean.class);

    public static void mark(ResourceRoot root) {
        VirtualFile file = root.getRoot().getChild("META-INF");
        if (file.exists()) {
            log.warnf("META-INF directory %s ignored as it is not a valid location for META-INF", (Object)file.getPathName());
        }
        root.putAttachment(IGNORE_META_INF, true);
    }

    public static boolean isIgnoreMetaInf(ResourceRoot resourceRoot) {
        Boolean res = resourceRoot.getAttachment(IGNORE_META_INF);
        return res != null && res != false;
    }
}

