/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import org.jboss.as.server.Bootstrap;
import org.jboss.as.server.SecurityActions;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.as.server.SystemExiter;
import org.jboss.logmanager.Level;
import org.jboss.logmanager.Logger;
import org.jboss.logmanager.log4j.BridgeRepositorySelector;
import org.jboss.modules.Module;
import org.jboss.msc.service.ServiceActivator;
import org.jboss.stdio.LoggingOutputStream;
import org.jboss.stdio.NullInputStream;
import org.jboss.stdio.SimpleStdioContextSelector;
import org.jboss.stdio.StdioContext;
import org.jboss.stdio.StdioContextSelector;

public final class Main {
    private Main() {
    }

    public static void main(String[] args) {
        SecurityActions.setSystemProperty("log4j.defaultInitOverride", "true");
        new BridgeRepositorySelector().start();
        StdioContext.install();
        StdioContext context = StdioContext.create((InputStream)new NullInputStream(), (OutputStream)new LoggingOutputStream((java.util.logging.Logger)Logger.getLogger((String)"stdout"), (java.util.logging.Level)Level.INFO), (OutputStream)new LoggingOutputStream((java.util.logging.Logger)Logger.getLogger((String)"stderr"), (java.util.logging.Level)Level.ERROR));
        StdioContext.setStdioContextSelector((StdioContextSelector)new SimpleStdioContextSelector(context));
        try {
            ServerEnvironment serverEnvironment = Main.determineEnvironment(args, new Properties(SecurityActions.getSystemProperties()), SecurityActions.getSystemEnvironment());
            if (serverEnvironment != null) {
                Bootstrap bootstrap = Bootstrap.Factory.newInstance();
                Bootstrap.Configuration configuration = new Bootstrap.Configuration();
                configuration.setServerEnvironment(serverEnvironment);
                configuration.setModuleLoader(Module.getBootModuleLoader());
                bootstrap.bootstrap(configuration, Collections.<ServiceActivator>emptyList()).get();
                return;
            }
            Main.abort(null);
        }
        catch (Throwable t) {
            Main.abort(t);
        }
    }

    private static void abort(Throwable t) {
        if (t != null) {
            t.printStackTrace(System.err);
        }
        try {
            throw new UnsupportedOperationException("implement me");
        }
        catch (Throwable throwable) {
            SystemExiter.exit(1);
            throw throwable;
        }
    }

    public static ServerEnvironment determineEnvironment(String[] args, Properties systemProperties, Map<String, String> systemEnvironment) {
        int argsLength = args.length;
        String serverConfig = null;
        for (int i = 0; i < argsLength; ++i) {
            String arg = args[i];
            try {
                if ("-server-config".equals(arg)) {
                    serverConfig = args[++i];
                    continue;
                }
                if ("-properties".equals(arg) || "-P".equals(arg)) {
                    URL url = null;
                    try {
                        url = Main.makeURL(args[++i]);
                        Properties props = System.getProperties();
                        props.load(url.openConnection().getInputStream());
                        continue;
                    }
                    catch (MalformedURLException e) {
                        System.err.printf("Malformed URL provided for option %s\n", arg);
                        return null;
                    }
                    catch (IOException e) {
                        System.err.printf("Unable to load properties from URL %s\n", url);
                        return null;
                    }
                }
                if (arg.startsWith("-D")) {
                    String value;
                    String name;
                    int idx = arg.indexOf("=");
                    if (idx == -1) {
                        name = arg.substring(2);
                        value = "true";
                    } else {
                        name = arg.substring(2, idx);
                        value = arg.substring(idx + 1, arg.length());
                    }
                    systemProperties.setProperty(name, value);
                    SecurityActions.setSystemProperty(name, value);
                    continue;
                }
                System.err.printf("Invalid option '%s'\n", arg);
                return null;
            }
            catch (IndexOutOfBoundsException e) {
                System.err.printf("Argument expected for option %s\n", arg);
                return null;
            }
        }
        return new ServerEnvironment(systemProperties, systemEnvironment, serverConfig, true);
    }

    private static URL makeURL(String urlspec) throws MalformedURLException {
        URL url;
        urlspec = urlspec.trim();
        try {
            url = new URL(urlspec);
            if (url.getProtocol().equals("file")) {
                File file = new File(url.getFile()).getCanonicalFile();
                url = file.toURI().toURL();
            }
        }
        catch (Exception e) {
            try {
                File file = new File(urlspec).getCanonicalFile();
                url = file.toURI().toURL();
            }
            catch (Exception n) {
                throw new MalformedURLException(n.toString());
            }
        }
        return url;
    }
}

