/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.jboss.as.server.deployment.Attachable;
import org.jboss.as.server.deployment.AttachableDependency;
import org.jboss.as.server.deployment.AttachedDependency;
import org.jboss.as.server.deployment.AttachmentKey;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeployerChains;
import org.jboss.as.server.deployment.DeploymentPhaseContextImpl;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.ListAttachmentKey;
import org.jboss.as.server.deployment.Phase;
import org.jboss.as.server.deployment.Services;
import org.jboss.logging.Logger;
import org.jboss.msc.service.DelegatingServiceRegistry;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

final class DeploymentUnitPhaseService<T>
implements Service<T> {
    private final InjectedValue<DeployerChains> deployerChainsInjector = new InjectedValue();
    private final DeploymentUnit deploymentUnit;
    private final Phase phase;
    private final AttachmentKey<T> valueKey;
    private final List<AttachedDependency> injectedAttachedDepenendencies = new ArrayList<AttachedDependency>();
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.server.deployment");

    private DeploymentUnitPhaseService(DeploymentUnit deploymentUnit, Phase phase, AttachmentKey<T> valueKey) {
        this.deploymentUnit = deploymentUnit;
        this.phase = phase;
        this.valueKey = valueKey;
    }

    private static <T> DeploymentUnitPhaseService<T> create(DeploymentUnit deploymentUnit, Phase phase, AttachmentKey<T> valueKey) {
        return new DeploymentUnitPhaseService<T>(deploymentUnit, phase, valueKey);
    }

    static DeploymentUnitPhaseService<?> create(DeploymentUnit deploymentUnit, Phase phase) {
        return DeploymentUnitPhaseService.create(deploymentUnit, phase, phase.getPhaseKey());
    }

    public synchronized void start(StartContext context) throws StartException {
        DeployerChains chains = (DeployerChains)this.deployerChainsInjector.getValue();
        DeploymentUnit deploymentUnit = this.deploymentUnit;
        List<DeploymentUnitProcessor> list = chains.getChain(this.phase);
        ListIterator<DeploymentUnitProcessor> iterator = list.listIterator();
        ServiceContainer container = context.getController().getServiceContainer();
        ServiceTarget serviceTarget = context.getChildTarget().subTarget();
        DeploymentPhaseContextImpl processorContext = new DeploymentPhaseContextImpl(serviceTarget, (ServiceRegistry)new DelegatingServiceRegistry((ServiceRegistry)container), deploymentUnit, this.phase);
        for (AttachedDependency attachedDependency : this.injectedAttachedDepenendencies) {
            Attachable target = attachedDependency.isDeploymentUnit() ? deploymentUnit : processorContext;
            if (attachedDependency.getAttachmentKey() instanceof ListAttachmentKey) {
                target.addToAttachmentList(attachedDependency.getAttachmentKey(), attachedDependency.getValue().getValue());
                continue;
            }
            target.putAttachment(attachedDependency.getAttachmentKey(), attachedDependency.getValue().getValue());
        }
        while (iterator.hasNext()) {
            DeploymentUnitProcessor processor = iterator.next();
            try {
                processor.deploy(processorContext);
            }
            catch (Throwable e) {
                while (iterator.hasPrevious()) {
                    DeploymentUnitProcessor prev = iterator.previous();
                    DeploymentUnitPhaseService.safeUndeploy(deploymentUnit, this.phase, prev);
                }
                throw new StartException(String.format("Failed to process phase %s of %s", new Object[]{this.phase, deploymentUnit}), e);
            }
        }
        Phase nextPhase = this.phase.next();
        if (nextPhase != null) {
            List nextPhaseAttachableDeps;
            String name = deploymentUnit.getName();
            DeploymentUnit parent = deploymentUnit.getParent();
            ServiceName serviceName = parent == null ? Services.deploymentUnitName(name, nextPhase) : Services.deploymentUnitName(parent.getName(), name, nextPhase);
            DeploymentUnitPhaseService<?> phaseService = DeploymentUnitPhaseService.create(deploymentUnit, nextPhase);
            ServiceBuilder phaseServiceBuilder = serviceTarget.addService(serviceName, phaseService);
            phaseServiceBuilder.addDependency(Services.JBOSS_DEPLOYMENT_CHAINS, DeployerChains.class, phaseService.getDeployerChainsInjector());
            phaseServiceBuilder.addDependency(context.getController().getName());
            List nextPhaseDeps = processorContext.getAttachment(Attachments.NEXT_PHASE_DEPS);
            if (nextPhaseDeps != null) {
                phaseServiceBuilder.addDependencies((Iterable)nextPhaseDeps);
            }
            if ((nextPhaseAttachableDeps = (List)processorContext.getAttachment(Attachments.NEXT_PHASE_ATTACHABLE_DEPS)) != null) {
                for (AttachableDependency attachableDep : nextPhaseAttachableDeps) {
                    AttachedDependency result = new AttachedDependency(attachableDep.getAttachmentKey(), attachableDep.isDeploymentUnit());
                    phaseServiceBuilder.addDependency(attachableDep.getServiceName(), result.getValue());
                    phaseService.injectedAttachedDepenendencies.add(result);
                }
            }
            if (deploymentUnit.getParent() != null) {
                phaseServiceBuilder.addDependencies(new ServiceName[]{Services.deploymentUnitName(deploymentUnit.getParent().getName(), nextPhase)});
            }
            List<DeploymentUnit> subDeployments = deploymentUnit.getAttachmentList(Attachments.SUB_DEPLOYMENTS);
            for (DeploymentUnit du : subDeployments) {
                phaseServiceBuilder.addDependencies(new ServiceName[]{du.getServiceName().append(new String[]{this.phase.name()})});
            }
            phaseServiceBuilder.install();
        }
    }

    public synchronized void stop(StopContext context) {
        DeploymentUnit deploymentUnitContext = this.deploymentUnit;
        DeployerChains chains = (DeployerChains)this.deployerChainsInjector.getValue();
        List<DeploymentUnitProcessor> list = chains.getChain(this.phase);
        ListIterator<DeploymentUnitProcessor> iterator = list.listIterator(list.size());
        while (iterator.hasPrevious()) {
            DeploymentUnitProcessor prev = iterator.previous();
            DeploymentUnitPhaseService.safeUndeploy(deploymentUnitContext, this.phase, prev);
        }
    }

    private static void safeUndeploy(DeploymentUnit deploymentUnit, Phase phase, DeploymentUnitProcessor prev) {
        try {
            prev.undeploy(deploymentUnit);
        }
        catch (Throwable t) {
            log.errorf(t, "Deployment unit processor %s unexpectedly threw an exception during undeploy phase %s of %s", (Object)prev, (Object)phase, (Object)deploymentUnit);
        }
    }

    public synchronized T getValue() throws IllegalStateException, IllegalArgumentException {
        return this.deploymentUnit.getAttachment(this.valueKey);
    }

    InjectedValue<DeployerChains> getDeployerChainsInjector() {
        return this.deployerChainsInjector;
    }
}

