/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.jboss.as.server.deployment.AttachmentList;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.ServicesAttachment;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.logging.Logger;
import org.jboss.vfs.VFSUtils;
import org.jboss.vfs.VirtualFile;

public final class ServiceLoaderProcessor
implements DeploymentUnitProcessor {
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.server.deployment.service-loader");
    private static final Pattern VALID_NAME = Pattern.compile("(?:[a-zA-Z0-9_]+\\.)*[a-zA-Z0-9_]+");

    @Override
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        AttachmentList<ResourceRoot> resourceRoots;
        HashMap<String, List<String>> foundServices = new HashMap<String, List<String>>();
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        ResourceRoot deploymentRoot = deploymentUnit.getAttachment(Attachments.DEPLOYMENT_ROOT);
        if (deploymentRoot != null) {
            this.processRoot(deploymentRoot, foundServices);
        }
        if ((resourceRoots = deploymentUnit.getAttachment(Attachments.RESOURCE_ROOTS)) != null) {
            for (ResourceRoot resourceRoot : resourceRoots) {
                this.processRoot(resourceRoot, foundServices);
            }
        }
        deploymentUnit.putAttachment(Attachments.SERVICES, new ServicesAttachment(foundServices));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processRoot(ResourceRoot resourceRoot, Map<String, List<String>> foundServices) throws DeploymentUnitProcessingException {
        VirtualFile virtualFile = resourceRoot.getRoot();
        VirtualFile child = virtualFile.getChild("META-INF/services");
        for (VirtualFile serviceType : child.getChildren()) {
            String name = serviceType.getName();
            if (!VALID_NAME.matcher(name).matches()) continue;
            try {
                List<String> list = foundServices.get(name);
                if (list == null) {
                    list = new ArrayList<String>();
                    foundServices.put(name, list);
                }
                InputStream stream = serviceType.openStream();
                try {
                    String line;
                    BufferedReader reader = new BufferedReader(new InputStreamReader(stream, "UTF-8"));
                    while ((line = reader.readLine()) != null) {
                        int commentIdx = line.indexOf(35);
                        String className = commentIdx == -1 ? line.trim() : line.substring(0, commentIdx).trim();
                        if (className.length() == 0) continue;
                        if (!VALID_NAME.matcher(className).matches()) {
                            log.warnf("Encountered invalid class name \"%s\" for service type \"%s\"", (Object)className, (Object)name);
                        }
                        list.add(className);
                    }
                }
                finally {
                    VFSUtils.safeClose((Closeable)stream);
                }
            }
            catch (IOException e) {
                throw new DeploymentUnitProcessingException("Failed to read '" + child + "'", e);
            }
        }
    }

    @Override
    public void undeploy(DeploymentUnit context) {
        context.removeAttachment(Attachments.SERVICES);
    }
}

