/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment;

import org.jboss.as.server.deployment.AbstractDeploymentUnitService;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitImpl;
import org.jboss.as.server.deployment.module.ModuleSpecification;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.msc.service.ServiceRegistry;

public class SubDeploymentUnitService
extends AbstractDeploymentUnitService {
    private final ResourceRoot deploymentRoot;
    private final DeploymentUnit parent;

    public SubDeploymentUnitService(ResourceRoot deploymentRoot, DeploymentUnit parent) {
        if (deploymentRoot == null) {
            throw new IllegalArgumentException("Deployment root is required");
        }
        this.deploymentRoot = deploymentRoot;
        if (parent == null) {
            throw new IllegalArgumentException("Sub-deployments require a parent deployment unit");
        }
        this.parent = parent;
    }

    @Override
    protected DeploymentUnit createAndInitializeDeploymentUnit(ServiceRegistry registry) {
        DeploymentUnitImpl deploymentUnit = new DeploymentUnitImpl(this.parent, this.deploymentRoot.getRootName(), registry);
        deploymentUnit.putAttachment(Attachments.DEPLOYMENT_ROOT, this.deploymentRoot);
        deploymentUnit.putAttachment(Attachments.MODULE_SPECIFICATION, new ModuleSpecification());
        return deploymentUnit;
    }
}

