/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment.module;

import java.util.List;
import java.util.jar.Manifest;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.DeploymentUtils;
import org.jboss.as.server.deployment.module.ModuleDependency;
import org.jboss.as.server.deployment.module.ModuleSpecification;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.as.server.moduleservice.ServiceModuleLoader;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;

public final class ModuleDependencyProcessor
implements DeploymentUnitProcessor {
    private static final String DEPENDENCIES_ATTR = "Dependencies";
    private static final String EXPORT_PARAM = "export";
    private static final String OPTIONAL_PARAM = "optional";
    private static final String SERVICES_PARAM = "services";

    @Override
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        ModuleSpecification moduleSpecification = deploymentUnit.getAttachment(Attachments.MODULE_SPECIFICATION);
        ServiceModuleLoader deploymentModuleLoader = deploymentUnit.getAttachment(Attachments.SERVICE_MODULE_LOADER);
        List<ResourceRoot> allResourceRoots = DeploymentUtils.allResourceRoots(deploymentUnit);
        for (ResourceRoot resourceRoot : allResourceRoots) {
            String[] dependencyDefs;
            String dependencyString;
            Manifest manifest = resourceRoot.getAttachment(Attachments.MANIFEST);
            if (manifest == null || (dependencyString = manifest.getMainAttributes().getValue(DEPENDENCIES_ATTR)) == null) continue;
            for (String dependencyDef : dependencyDefs = dependencyString.split(",")) {
                String[] dependencyParts = dependencyDef.split(" ");
                if (dependencyParts.length == 0) {
                    throw new RuntimeException("Invalid dependency: " + dependencyString);
                }
                ModuleIdentifier dependencyId = ModuleIdentifier.fromString((String)dependencyParts[0]);
                boolean export = this.containsParam(dependencyParts, EXPORT_PARAM);
                boolean optional = this.containsParam(dependencyParts, OPTIONAL_PARAM);
                boolean services = this.containsParam(dependencyParts, SERVICES_PARAM);
                ServiceModuleLoader dependencyLoader = dependencyId.getName().startsWith("deployment.") ? deploymentModuleLoader : Module.getBootModuleLoader();
                ModuleDependency dependency = new ModuleDependency(dependencyLoader, dependencyId, optional, export, services);
                moduleSpecification.addDependency(dependency);
                deploymentUnit.addToAttachmentList(Attachments.MANIFEST_DEPENDENCIES, dependency);
            }
        }
        if (deploymentUnit.getParent() != null) {
            List<ModuleDependency> parentDependencies = deploymentUnit.getParent().getAttachmentList(Attachments.MANIFEST_DEPENDENCIES);
            moduleSpecification.addDependencies(parentDependencies);
        }
    }

    @Override
    public void undeploy(DeploymentUnit context) {
    }

    private boolean containsParam(String[] parts, String expected) {
        if (parts.length > 1) {
            for (int i = 1; i < parts.length; ++i) {
                if (!expected.equals(parts[i])) continue;
                return true;
            }
        }
        return false;
    }
}

