/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment.module;

import java.util.HashSet;
import java.util.List;
import org.jboss.as.server.deployment.AttachmentList;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.DeploymentUtils;
import org.jboss.as.server.deployment.Services;
import org.jboss.as.server.deployment.module.AdditionalModuleSpecification;
import org.jboss.as.server.deployment.module.ExtensionListEntry;
import org.jboss.as.server.deployment.module.ModuleDependency;
import org.jboss.as.server.deployment.module.ModuleSpecification;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.as.server.moduleservice.ExtensionIndex;
import org.jboss.as.server.moduleservice.ServiceModuleLoader;
import org.jboss.logging.Logger;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoader;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;

public final class ModuleExtensionListProcessor
implements DeploymentUnitProcessor {
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.server.deployment.module.module-extension-list-processor");

    @Override
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        ModuleSpecification moduleSpecification = deploymentUnit.getAttachment(Attachments.MODULE_SPECIFICATION);
        ModuleLoader moduleLoader = deploymentUnit.getAttachment(Attachments.SERVICE_MODULE_LOADER);
        ServiceController controller = phaseContext.getServiceRegistry().getRequiredService(Services.JBOSS_DEPLOYMENT_EXTENSION_INDEX);
        ExtensionIndex index = (ExtensionIndex)controller.getValue();
        List<ResourceRoot> allResourceRoots = DeploymentUtils.allResourceRoots(deploymentUnit);
        HashSet<ServiceName> nextPhaseDeps = new HashSet<ServiceName>();
        for (ResourceRoot resourceRoot : allResourceRoots) {
            AttachmentList<ExtensionListEntry> entries = resourceRoot.getAttachment(Attachments.EXTENSION_LIST_ENTRIES);
            if (entries == null) continue;
            for (ExtensionListEntry entry : entries) {
                ModuleIdentifier extension = index.findExtension(entry.getName(), entry.getSpecificationVersion(), entry.getImplementationVersion(), entry.getImplementationVendorId());
                if (extension != null) {
                    moduleSpecification.addDependency(new ModuleDependency(moduleLoader, extension, false, false, true));
                    nextPhaseDeps.add(ServiceModuleLoader.moduleSpecServiceName(extension));
                    nextPhaseDeps.add(ServiceModuleLoader.moduleSpecServiceName(extension));
                    continue;
                }
                log.warnf("Could not find Extension-List entry " + entry + " referenced from " + resourceRoot, new Object[0]);
            }
        }
        List additionalModules = deploymentUnit.getAttachment(Attachments.ADDITIONAL_MODULES);
        if (additionalModules != null) {
            for (AdditionalModuleSpecification additionalModule : additionalModules) {
                for (ResourceRoot resourceRoot : additionalModule.getResourceRoots()) {
                    AttachmentList<ExtensionListEntry> entries = resourceRoot.getAttachment(Attachments.EXTENSION_LIST_ENTRIES);
                    if (entries == null) continue;
                    for (ExtensionListEntry entry : entries) {
                        ModuleIdentifier extension = index.findExtension(entry.getName(), entry.getSpecificationVersion(), entry.getImplementationVersion(), entry.getImplementationVendorId());
                        if (extension != null) {
                            moduleSpecification.addDependency(new ModuleDependency(moduleLoader, extension, false, false, true));
                            nextPhaseDeps.add(ServiceModuleLoader.moduleSpecServiceName(extension));
                            continue;
                        }
                        log.warnf("Could not find Extension-List entry " + entry + " referenced from " + resourceRoot, new Object[0]);
                    }
                }
            }
        }
        for (ServiceName dep : nextPhaseDeps) {
            phaseContext.addToAttachmentList(Attachments.NEXT_PHASE_DEPS, dep);
        }
    }

    @Override
    public void undeploy(DeploymentUnit context) {
    }
}

