/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment.reflect;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class ClassReflectionIndex<T> {
    private final Class<T> indexedClass;
    private final Map<String, Field> fields;
    private final Map<ParamList, Constructor<T>> constructors;
    private final Map<String, Map<ParamList, Map<Class<?>, Method>>> methods;
    private static final ParamList EMPTY = new ParamList(new Class[0]);

    ClassReflectionIndex(Class<T> indexedClass) {
        this.indexedClass = indexedClass;
        Field[] declaredFields = indexedClass.getDeclaredFields();
        HashMap<String, Field> fields = new HashMap<String, Field>();
        for (Field field : declaredFields) {
            field.setAccessible(true);
            fields.put(field.getName(), field);
        }
        this.fields = fields;
        Method[] declaredMethods = indexedClass.getDeclaredMethods();
        HashMap methods = new HashMap();
        for (Method method : declaredMethods) {
            method.setAccessible(true);
            ClassReflectionIndex.addMethod(methods, method);
        }
        for (Method method : indexedClass.getMethods()) {
            ClassReflectionIndex.addMethod(methods, method);
        }
        this.methods = methods;
        Constructor<?>[] declaredConstructors = indexedClass.getDeclaredConstructors();
        HashMap<ParamList, Constructor<T>> constructors = new HashMap<ParamList, Constructor<T>>();
        for (Constructor<?> constructor : declaredConstructors) {
            constructor.setAccessible(true);
            constructors.put(ClassReflectionIndex.createParamList(constructor.getParameterTypes()), constructor);
        }
        this.constructors = constructors;
    }

    private static void addMethod(Map<String, Map<ParamList, Map<Class<?>, Method>>> methods, Method method) {
        Class<?>[] types;
        ParamList list;
        Map<Class<?>, Method> paramsMap;
        String name = method.getName();
        Map<ParamList, Map<Class<?>, Method>> nameMap = methods.get(name);
        if (nameMap == null) {
            nameMap = new HashMap();
            methods.put(name, nameMap);
        }
        if ((paramsMap = nameMap.get(list = ClassReflectionIndex.createParamList(types = method.getParameterTypes()))) == null) {
            paramsMap = new HashMap();
            nameMap.put(list, paramsMap);
        }
        paramsMap.put(method.getReturnType(), method);
    }

    private static ParamList createParamList(Class<?>[] types) {
        return types == null || types.length == 0 ? EMPTY : new ParamList(types);
    }

    public Class<T> getIndexedClass() {
        return this.indexedClass;
    }

    public Field getField(String name) {
        return this.fields.get(name);
    }

    public Collection<Field> getFields() {
        return Collections.unmodifiableCollection(this.fields.values());
    }

    public Method getMethod(Class<?> returnType, String name, Class<?> ... paramTypes) {
        Map<ParamList, Map<Class<?>, Method>> nameMap = this.methods.get(name);
        if (nameMap == null) {
            return null;
        }
        Map<Class<?>, Method> paramsMap = nameMap.get(ClassReflectionIndex.createParamList(paramTypes));
        if (paramsMap == null) {
            return null;
        }
        return paramsMap.get(returnType);
    }

    public Collection<Method> getMethods(String name, Class<?> ... paramTypes) {
        Map<ParamList, Map<Class<?>, Method>> nameMap = this.methods.get(name);
        if (nameMap == null) {
            return Collections.emptySet();
        }
        Map<Class<?>, Method> paramsMap = nameMap.get(ClassReflectionIndex.createParamList(paramTypes));
        if (paramsMap == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableCollection(paramsMap.values());
    }

    public Collection<Method> getAllMethods(String name) {
        Map<ParamList, Map<Class<?>, Method>> nameMap = this.methods.get(name);
        if (nameMap == null) {
            return Collections.emptySet();
        }
        ArrayList<Method> methods = new ArrayList<Method>();
        for (Map<Class<?>, Method> map : nameMap.values()) {
            methods.addAll(map.values());
        }
        return methods;
    }

    public Collection<Method> getMethods() {
        ArrayList<Method> methods = new ArrayList<Method>();
        for (Map.Entry<String, Map<ParamList, Map<Class<?>, Method>>> entry : this.methods.entrySet()) {
            Map<ParamList, Map<Class<?>, Method>> nameMap = entry.getValue();
            for (Map<Class<?>, Method> map : nameMap.values()) {
                methods.addAll(map.values());
            }
        }
        return methods;
    }

    public Collection<Constructor<T>> getConstructors() {
        return Collections.unmodifiableCollection(this.constructors.values());
    }

    public Constructor<T> getConstructor(Class<?> ... paramTypes) {
        return this.constructors.get(ClassReflectionIndex.createParamList(paramTypes));
    }

    private static final class ParamList {
        private final Class<?>[] types;
        private final int hashCode;

        ParamList(Class<?>[] types) {
            this.types = types;
            this.hashCode = Arrays.hashCode(types);
        }

        Class<?>[] getTypes() {
            return this.types;
        }

        public boolean equals(Object other) {
            return other instanceof ParamList && this.equals((ParamList)other);
        }

        public boolean equals(ParamList other) {
            return this == other || other != null && Arrays.equals(this.types, other.types);
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

