/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.mgmt;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import javax.net.ServerSocketFactory;
import org.jboss.as.protocol.Connection;
import org.jboss.as.protocol.ConnectionHandler;
import org.jboss.as.protocol.MessageHandler;
import org.jboss.as.protocol.ProtocolServer;
import org.jboss.as.protocol.mgmt.ManagementHeaderMessageHandler;
import org.jboss.as.protocol.mgmt.ManagementOperationHandler;
import org.jboss.as.server.services.net.NetworkInterfaceBinding;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class ManagementCommunicationService
implements Service<ManagementCommunicationService>,
ConnectionHandler {
    public static final ServiceName SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"server", "controller", "management", "communication"});
    private final InjectedValue<NetworkInterfaceBinding> interfaceBindingValue = new InjectedValue();
    private final InjectedValue<Integer> portValue = new InjectedValue();
    private final InjectedValue<ExecutorService> executorServiceValue = new InjectedValue();
    private final InjectedValue<ThreadFactory> threadFactoryValue = new InjectedValue();
    private final ConcurrentMap<Byte, ManagementOperationHandler> handlers = new ConcurrentHashMap<Byte, ManagementOperationHandler>();
    private ProtocolServer server;
    private MessageHandler initialMessageHandler = new ManagementHeaderMessageHandler(){

        protected MessageHandler getHandlerForId(byte handlerId) {
            return (MessageHandler)ManagementCommunicationService.this.handlers.get(handlerId);
        }
    };

    public synchronized void start(StartContext context) throws StartException {
        ExecutorService executorService = (ExecutorService)this.executorServiceValue.getValue();
        ThreadFactory threadFactory = (ThreadFactory)this.threadFactoryValue.getValue();
        NetworkInterfaceBinding interfaceBinding = (NetworkInterfaceBinding)this.interfaceBindingValue.getValue();
        Integer port = (Integer)this.portValue.getValue();
        try {
            ProtocolServer.Configuration config = new ProtocolServer.Configuration();
            config.setBindAddress(new InetSocketAddress(interfaceBinding.getAddress(), (int)port));
            config.setThreadFactory(threadFactory);
            config.setReadExecutor((Executor)executorService);
            config.setSocketFactory(ServerSocketFactory.getDefault());
            config.setBacklog(50);
            config.setConnectionHandler((ConnectionHandler)this);
            this.server = new ProtocolServer(config);
            this.server.start();
        }
        catch (Exception e) {
            throw new StartException("Failed to start server socket", (Throwable)e);
        }
    }

    public synchronized void stop(StopContext context) {
        if (this.server != null) {
            this.server.stop();
        }
    }

    public ManagementCommunicationService getValue() throws IllegalStateException {
        return this;
    }

    public Injector<NetworkInterfaceBinding> getInterfaceInjector() {
        return this.interfaceBindingValue;
    }

    public Injector<ExecutorService> getExecutorServiceInjector() {
        return this.executorServiceValue;
    }

    public Injector<Integer> getPortInjector() {
        return this.portValue;
    }

    public Injector<ThreadFactory> getThreadFactoryInjector() {
        return this.threadFactoryValue;
    }

    void addHandler(ManagementOperationHandler handler) {
        if (this.handlers.putIfAbsent(handler.getIdentifier(), handler) != null) {
            // empty if block
        }
    }

    void removeHandler(ManagementOperationHandler handler) {
        if (!this.handlers.remove(handler.getIdentifier(), handler)) {
            // empty if block
        }
    }

    public MessageHandler handleConnected(Connection connection) throws IOException {
        return this.initialMessageHandler;
    }

    public MessageHandler getInitialMessageHandler() {
        return this.initialMessageHandler;
    }
}

