/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.operations;

import java.util.ArrayList;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.operations.global.WriteAttributeHandlers;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.domain.management.security.SecurityRealmService;
import org.jboss.as.remoting.RemotingServices;
import org.jboss.as.server.services.net.NetworkInterfaceService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;

public class NativeManagementAttributeHandlers {
    public static OperationStepHandler INSTANCE = new NativeManagementAttributeHandler();

    static class NativeManagementAttributeHandler
    extends WriteAttributeHandlers.WriteAttributeOperationHandler {
        NativeManagementAttributeHandler() {
        }

        protected void modelChanged(OperationContext context, ModelNode operation, String attributeName, ModelNode newValue, ModelNode currentValue) throws OperationFailedException {
            Resource resource = context.readResource(PathAddress.EMPTY_ADDRESS);
            final ModelNode subModel = resource.getModel();
            if (!newValue.equals(currentValue)) {
                context.addStep(new OperationStepHandler(){

                    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                        String interfaceName = subModel.require("interface").asString();
                        int port = subModel.require("port").asInt();
                        context.removeService(RemotingServices.AUTHENTICATION_PROVIDER);
                        context.removeService(RemotingServices.OPTION_MAP);
                        context.removeService(RemotingServices.serverServiceName((String)"management", (int)port));
                        ServiceTarget serviceTarget = context.getServiceTarget();
                        ServiceName interfaceSvcName = NetworkInterfaceService.JBOSS_NETWORK_INTERFACE.append(new String[]{interfaceName});
                        ServiceName realmSvcName = null;
                        if (subModel.hasDefined("security-realm")) {
                            realmSvcName = SecurityRealmService.BASE_SERVICE_NAME.append(new String[]{subModel.require("security-realm").asString()});
                        }
                        ArrayList list = new ArrayList();
                        ServiceVerificationHandler verificationHandler = new ServiceVerificationHandler();
                        RemotingServices.installStandaloneConnectorServices((ServiceTarget)serviceTarget, (ServiceName)interfaceSvcName, (int)port, (ServiceName)realmSvcName, (ServiceVerificationHandler)verificationHandler, list);
                        context.addStep((OperationStepHandler)verificationHandler, OperationContext.Stage.VERIFY);
                        context.completeStep();
                    }
                }, OperationContext.Stage.RUNTIME);
            }
            context.completeStep();
        }
    }
}

