/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.mgmt.domain;

import java.io.DataInput;
import java.io.IOException;
import java.security.AccessController;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.jboss.as.controller.ControllerLogger;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.remote.TransactionalModelControllerOperationHandler;
import org.jboss.as.protocol.mgmt.AbstractManagementRequest;
import org.jboss.as.protocol.mgmt.ActiveOperation;
import org.jboss.as.protocol.mgmt.FlushableDataOutput;
import org.jboss.as.protocol.mgmt.ManagementChannelReceiver;
import org.jboss.as.protocol.mgmt.ManagementMessageHandler;
import org.jboss.as.protocol.mgmt.ManagementRequest;
import org.jboss.as.protocol.mgmt.ManagementRequestContext;
import org.jboss.as.server.ServerMessages;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.remoting3.Channel;
import org.jboss.remoting3.CloseHandler;
import org.jboss.threads.AsyncFuture;
import org.jboss.threads.JBossThreadFactory;

public class HostControllerServerClient
implements Service<HostControllerServerClient> {
    public static final ServiceName SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"host", "controller", "client"});
    private final InjectedValue<Channel> hcChannel = new InjectedValue();
    private final InjectedValue<ModelController> controller = new InjectedValue();
    private final String serverName;
    private final String serverProcessName;
    private final ThreadFactory threadFactory = new JBossThreadFactory(new ThreadGroup("host-controller-connection-threads"), Boolean.FALSE, null, "%G - %t", null, null, AccessController.getContext());
    private final ExecutorService executor = Executors.newCachedThreadPool(this.threadFactory);
    private volatile ManagementMessageHandler handler;

    public HostControllerServerClient(String serverName, String serverProcessName) {
        this.serverName = serverName;
        this.serverProcessName = serverProcessName;
    }

    public synchronized void start(StartContext context) throws StartException {
        Channel channel = (Channel)this.hcChannel.getValue();
        final HostControllerServerHandler handler = new HostControllerServerHandler((ModelController)this.controller.getValue(), this.executor);
        channel.addCloseHandler((CloseHandler)new CloseHandler<Channel>(){

            public void handleClose(Channel closed, IOException exception) {
                handler.shutdownNow();
            }
        });
        context.asynchronous();
        try {
            handler.executeRegistrationRequest(channel, (ManagementRequest)new ServerRegisterRequest(), context);
        }
        catch (Exception e) {
            throw ServerMessages.MESSAGES.failedToConnectToHC(e);
        }
        this.handler = handler;
        channel.receiveMessage(ManagementChannelReceiver.createDelegating((ManagementMessageHandler)handler));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stop(StopContext context) {
        ManagementMessageHandler handler = this.handler;
        if (handler != null) {
            handler.shutdown();
            try {
                if (!handler.awaitCompletion(100L, TimeUnit.MILLISECONDS)) {
                    ControllerLogger.ROOT_LOGGER.debugf("HostController server client did not complete shutdown within timeout", new Object[0]);
                }
            }
            catch (Exception e) {
                ControllerLogger.ROOT_LOGGER.warnf((Throwable)e, "service shutdown did not complete", new Object[0]);
            }
            finally {
                handler.shutdownNow();
            }
        }
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getServerProcessName() {
        return this.serverProcessName;
    }

    public synchronized HostControllerServerClient getValue() throws IllegalStateException {
        return this;
    }

    public Injector<Channel> getHcChannelInjector() {
        return this.hcChannel;
    }

    public Injector<ModelController> getServerControllerInjector() {
        return this.controller;
    }

    private class ServerRegisterRequest
    extends AbstractManagementRequest<Void, Void> {
        private ServerRegisterRequest() {
        }

        public byte getOperationType() {
            return 0;
        }

        protected void sendRequest(ActiveOperation.ResultHandler<Void> resultHandler, ManagementRequestContext<Void> voidManagementRequestContext, FlushableDataOutput output) throws IOException {
            output.write(1);
            output.writeUTF(HostControllerServerClient.this.serverProcessName);
        }

        public void handleRequest(DataInput input, ActiveOperation.ResultHandler<Void> resultHandler, ManagementRequestContext<Void> voidManagementRequestContext) throws IOException {
            resultHandler.done(null);
        }
    }

    private class HostControllerServerHandler
    extends TransactionalModelControllerOperationHandler {
        private HostControllerServerHandler(ModelController controller, ExecutorService executorService) {
            super(controller, executorService);
        }

        protected AsyncFuture<Void> executeRegistrationRequest(Channel channel, ManagementRequest request, final StartContext callback) {
            ActiveOperation support = super.registerActiveOperation(null, (ActiveOperation.CompletedCallback)new ActiveOperation.CompletedCallback<Void>(){

                public void completed(Void result) {
                    callback.complete();
                }

                public void failed(Exception e) {
                    callback.failed(ServerMessages.MESSAGES.failedToConnectToHC(e));
                }

                public void cancelled() {
                    callback.failed(ServerMessages.MESSAGES.cancelledHCConnect());
                }
            });
            return super.executeRequest(request, channel, support);
        }
    }
}

