/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment.module;

import java.io.IOException;
import java.lang.instrument.ClassFileTransformer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.as.server.deployment.AttachmentKey;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.SubDeploymentMarker;
import org.jboss.as.server.deployment.module.AdditionalModuleSpecification;
import org.jboss.as.server.deployment.module.DelegatingClassFileTransformer;
import org.jboss.as.server.deployment.module.FilterSpecification;
import org.jboss.as.server.deployment.module.ModuleDependency;
import org.jboss.as.server.deployment.module.ModuleRootMarker;
import org.jboss.as.server.deployment.module.ModuleSpecification;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.as.server.deployment.module.VFSResourceLoader;
import org.jboss.as.server.moduleservice.ModuleLoadService;
import org.jboss.as.server.moduleservice.ServiceModuleLoader;
import org.jboss.logging.Logger;
import org.jboss.modules.DependencySpec;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.ModuleSpec;
import org.jboss.modules.ResourceLoader;
import org.jboss.modules.ResourceLoaderSpec;
import org.jboss.modules.filter.MultiplePathFilterBuilder;
import org.jboss.modules.filter.PathFilter;
import org.jboss.modules.filter.PathFilters;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ValueService;
import org.jboss.msc.value.ImmediateValue;
import org.jboss.msc.value.Value;

public class ModuleSpecProcessor
implements DeploymentUnitProcessor {
    private static final AttachmentKey<Boolean> MARKER = AttachmentKey.create(Boolean.class);
    private static final Logger logger = Logger.getLogger((String)"org.jboss.as.server.deployment.module");

    @Override
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (deploymentUnit.getAttachment(MARKER) != null) {
            return;
        }
        deploymentUnit.putAttachment(MARKER, true);
        if (deploymentUnit.hasAttachment(Attachments.OSGI_MANIFEST)) {
            return;
        }
        ResourceRoot mainRoot = deploymentUnit.getAttachment(Attachments.DEPLOYMENT_ROOT);
        List<ResourceRoot> additionalRoots = deploymentUnit.getAttachmentList(Attachments.RESOURCE_ROOTS);
        if (mainRoot == null) {
            return;
        }
        ArrayList<ResourceRoot> resourceRoots = new ArrayList<ResourceRoot>();
        if (ModuleRootMarker.isModuleRoot(mainRoot)) {
            resourceRoots.add(mainRoot);
        }
        for (ResourceRoot additionalRoot : additionalRoots) {
            if (!ModuleRootMarker.isModuleRoot(additionalRoot) || SubDeploymentMarker.isSubDeployment(additionalRoot)) continue;
            resourceRoots.add(additionalRoot);
        }
        ModuleSpecification moduleSpecification = deploymentUnit.getAttachment(Attachments.MODULE_SPECIFICATION);
        ModuleIdentifier moduleIdentifier = deploymentUnit.getAttachment(Attachments.MODULE_IDENTIFIER);
        if (moduleIdentifier == null) {
            throw new DeploymentUnitProcessingException("No Module Identifier attached to deployment " + deploymentUnit.getName());
        }
        ServiceName moduleServiceName = this.createModuleService(phaseContext, deploymentUnit, resourceRoots, moduleSpecification, moduleIdentifier);
        phaseContext.addDeploymentDependency(moduleServiceName, Attachments.MODULE);
        for (DeploymentUnit subDeployment : deploymentUnit.getAttachmentList(Attachments.SUB_DEPLOYMENTS)) {
            ModuleIdentifier moduleId = subDeployment.getAttachment(Attachments.MODULE_IDENTIFIER);
            if (moduleId == null) continue;
            phaseContext.addToAttachmentList(Attachments.NEXT_PHASE_DEPS, ServiceModuleLoader.moduleSpecServiceName(moduleId));
        }
        List additionalModules = deploymentUnit.getAttachment(Attachments.ADDITIONAL_MODULES);
        if (additionalModules == null) {
            return;
        }
        for (AdditionalModuleSpecification module : additionalModules) {
            this.addSystemDependencies(moduleSpecification, module);
            ServiceName additionalModuleServiceName = this.createModuleService(phaseContext, deploymentUnit, module.getResourceRoots(), module, module.getModuleIdentifier());
            phaseContext.addToAttachmentList(Attachments.NEXT_PHASE_DEPS, additionalModuleServiceName);
        }
    }

    private void addSystemDependencies(ModuleSpecification moduleSpecification, AdditionalModuleSpecification module) {
        module.addSystemDependencies(moduleSpecification.getSystemDependencies());
    }

    private ServiceName createModuleService(DeploymentPhaseContext phaseContext, DeploymentUnit deploymentUnit, List<ResourceRoot> resourceRoots, ModuleSpecification moduleSpecification, ModuleIdentifier moduleIdentifier) throws DeploymentUnitProcessingException {
        logger.debug((Object)("Creating module" + moduleIdentifier));
        ModuleSpec.Builder specBuilder = ModuleSpec.build((ModuleIdentifier)moduleIdentifier);
        for (DependencySpec dep : moduleSpecification.getModuleSystemDependencies()) {
            specBuilder.addDependency(dep);
        }
        List<ModuleDependency> dependencies = moduleSpecification.getSystemDependencies();
        List<ModuleDependency> localDependencies = moduleSpecification.getLocalDependencies();
        List<ModuleDependency> userDependencies = moduleSpecification.getUserDependencies();
        this.installAliases(moduleSpecification, moduleIdentifier, deploymentUnit, phaseContext);
        for (ResourceLoaderSpec resourceLoaderSpec : moduleSpecification.getResourceLoaders()) {
            logger.debug((Object)("Adding resource loader " + resourceLoaderSpec + " to module " + moduleIdentifier));
            specBuilder.addResourceRoot(resourceLoaderSpec);
        }
        for (ResourceRoot resourceRoot : resourceRoots) {
            logger.debug((Object)("Adding resource " + resourceRoot.getRoot() + " to module " + moduleIdentifier));
            ModuleSpecProcessor.addResourceRoot(specBuilder, resourceRoot);
        }
        this.createDependencies(phaseContext, specBuilder, dependencies, moduleSpecification.isRequiresTransitiveDependencies());
        this.createDependencies(phaseContext, specBuilder, userDependencies, moduleSpecification.isRequiresTransitiveDependencies());
        if (moduleSpecification.isLocalLast()) {
            this.createDependencies(phaseContext, specBuilder, localDependencies, moduleSpecification.isRequiresTransitiveDependencies());
            specBuilder.addDependency(DependencySpec.createLocalDependencySpec());
        } else {
            specBuilder.addDependency(DependencySpec.createLocalDependencySpec());
            this.createDependencies(phaseContext, specBuilder, localDependencies, moduleSpecification.isRequiresTransitiveDependencies());
        }
        DelegatingClassFileTransformer delegatingClassFileTransformer = new DelegatingClassFileTransformer();
        specBuilder.setClassFileTransformer((ClassFileTransformer)delegatingClassFileTransformer);
        deploymentUnit.putAttachment(DelegatingClassFileTransformer.ATTACHMENT_KEY, delegatingClassFileTransformer);
        ModuleSpec moduleSpec = specBuilder.create();
        ServiceName moduleSpecServiceName = ServiceModuleLoader.moduleSpecServiceName(moduleIdentifier);
        ValueService moduleSpecService = new ValueService((Value)new ImmediateValue((Object)moduleSpec));
        phaseContext.getServiceTarget().addService(moduleSpecServiceName, (Service)moduleSpecService).addDependencies(new ServiceName[]{deploymentUnit.getServiceName()}).addDependencies(new ServiceName[]{phaseContext.getPhaseServiceName()}).setInitialMode(ServiceController.Mode.ON_DEMAND).install();
        ArrayList<ModuleDependency> allDependencies = new ArrayList<ModuleDependency>();
        allDependencies.addAll(dependencies);
        allDependencies.addAll(localDependencies);
        allDependencies.addAll(userDependencies);
        return ModuleLoadService.install(phaseContext.getServiceTarget(), moduleIdentifier, allDependencies);
    }

    private void installAliases(ModuleSpecification moduleSpecification, ModuleIdentifier moduleIdentifier, DeploymentUnit deploymentUnit, DeploymentPhaseContext phaseContext) {
        for (ModuleIdentifier alias : moduleSpecification.getAliases()) {
            ServiceName moduleSpecServiceName = ServiceModuleLoader.moduleSpecServiceName(alias);
            ModuleSpec spec = ModuleSpec.buildAlias((ModuleIdentifier)alias, (ModuleIdentifier)moduleIdentifier).create();
            ValueService moduleSpecService = new ValueService((Value)new ImmediateValue((Object)spec));
            phaseContext.getServiceTarget().addService(moduleSpecServiceName, (Service)moduleSpecService).addDependencies(new ServiceName[]{deploymentUnit.getServiceName()}).addDependencies(new ServiceName[]{phaseContext.getPhaseServiceName()}).setInitialMode(ServiceController.Mode.ON_DEMAND).install();
            ModuleLoadService.installService(phaseContext.getServiceTarget(), alias, Collections.singletonList(moduleIdentifier));
        }
    }

    private void createDependencies(DeploymentPhaseContext phaseContext, ModuleSpec.Builder specBuilder, List<ModuleDependency> apiDependencies, boolean requireTransitive) {
        if (apiDependencies != null) {
            for (ModuleDependency dependency : apiDependencies) {
                PathFilter exportFilter;
                boolean export = requireTransitive ? true : dependency.isExport();
                List<FilterSpecification> importFilters = dependency.getImportFilters();
                List<FilterSpecification> exportFilters = dependency.getExportFilters();
                MultiplePathFilterBuilder importBuilder = PathFilters.multiplePathFilterBuilder((boolean)true);
                for (FilterSpecification filter : importFilters) {
                    importBuilder.addFilter(filter.getPathFilter(), filter.isInclude());
                }
                if (dependency.isImportServices()) {
                    importBuilder.addFilter(PathFilters.getMetaInfServicesFilter(), true);
                }
                importBuilder.addFilter(PathFilters.getMetaInfSubdirectoriesFilter(), false);
                importBuilder.addFilter(PathFilters.getMetaInfFilter(), false);
                PathFilter importFilter = importBuilder.create();
                if (exportFilters.isEmpty()) {
                    exportFilter = export ? PathFilters.acceptAll() : PathFilters.rejectAll();
                } else {
                    MultiplePathFilterBuilder exportBuilder = PathFilters.multiplePathFilterBuilder((boolean)export);
                    for (FilterSpecification filter : exportFilters) {
                        exportBuilder.addFilter(filter.getPathFilter(), filter.isInclude());
                    }
                    exportFilter = exportBuilder.create();
                }
                DependencySpec depSpec = DependencySpec.createModuleDependencySpec((PathFilter)importFilter, (PathFilter)exportFilter, (ModuleLoader)dependency.getModuleLoader(), (ModuleIdentifier)dependency.getIdentifier(), (boolean)dependency.isOptional());
                specBuilder.addDependency(depSpec);
                logger.debug((Object)("Adding dependency " + dependency + " to module " + specBuilder.getIdentifier()));
                String depName = dependency.getIdentifier().getName();
                if (!depName.startsWith("deployment.")) continue;
                phaseContext.addToAttachmentList(Attachments.NEXT_PHASE_DEPS, ServiceModuleLoader.moduleSpecServiceName(dependency.getIdentifier()));
            }
        }
    }

    private static void addResourceRoot(ModuleSpec.Builder specBuilder, ResourceRoot resource) throws DeploymentUnitProcessingException {
        try {
            if (resource.getExportFilters().isEmpty()) {
                specBuilder.addResourceRoot(ResourceLoaderSpec.createResourceLoaderSpec((ResourceLoader)new VFSResourceLoader(resource.getRootName(), resource.getRoot(), resource.isUsePhysicalCodeSource())));
            } else {
                MultiplePathFilterBuilder filterBuilder = PathFilters.multiplePathFilterBuilder((boolean)true);
                for (FilterSpecification filter : resource.getExportFilters()) {
                    filterBuilder.addFilter(filter.getPathFilter(), filter.isInclude());
                }
                specBuilder.addResourceRoot(ResourceLoaderSpec.createResourceLoaderSpec((ResourceLoader)new VFSResourceLoader(resource.getRootName(), resource.getRoot(), resource.isUsePhysicalCodeSource()), (PathFilter)filterBuilder.create()));
            }
        }
        catch (IOException e) {
            throw new DeploymentUnitProcessingException("Failed to create VFSResourceLoader for root [" + resource.getRootName() + "]", e);
        }
    }

    @Override
    public void undeploy(DeploymentUnit context) {
        context.removeAttachment(MARKER);
    }
}

