/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.mgmt.domain;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.RealmCallback;
import javax.security.sasl.RealmChoiceCallback;
import org.jboss.as.protocol.ProtocolChannelClient;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.as.server.ServerMessages;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.remoting3.Channel;
import org.jboss.remoting3.Connection;
import org.jboss.remoting3.Endpoint;
import org.xnio.OptionMap;

public class HostControllerConnectionService
implements Service<Channel> {
    public static final ServiceName SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"host", "controller", "channel"});
    private final InjectedValue<InetSocketAddress> hcAddressInjector = new InjectedValue();
    private final InjectedValue<Endpoint> endpointInjector = new InjectedValue();
    private volatile Channel channel;
    private volatile ProtocolChannelClient client;
    private volatile Connection connection;
    private final String serverName;
    private final byte[] authKey;

    private HostControllerConnectionService(String serverName, byte[] authKey) {
        this.serverName = serverName;
        this.authKey = authKey;
    }

    public static void install(ServiceTarget serviceTarget, ServiceName endpointName, InetSocketAddress managementSocket, String serverName, byte[] authKey) {
        HostControllerConnectionService hcConnection = new HostControllerConnectionService(serverName, authKey);
        serviceTarget.addService(SERVICE_NAME, (Service)hcConnection).addInjection(hcConnection.hcAddressInjector, (Object)managementSocket).addDependency(endpointName, Endpoint.class, hcConnection.endpointInjector).setInitialMode(ServiceController.Mode.ACTIVE).install();
    }

    public synchronized void start(StartContext context) throws StartException {
        ProtocolChannelClient client;
        try {
            ProtocolChannelClient.Configuration configuration = new ProtocolChannelClient.Configuration();
            configuration.setEndpoint((Endpoint)this.endpointInjector.getValue());
            configuration.setUri(new URI("remote://" + ((InetSocketAddress)this.hcAddressInjector.getValue()).getHostName() + ":" + ((InetSocketAddress)this.hcAddressInjector.getValue()).getPort()));
            client = ProtocolChannelClient.create((ProtocolChannelClient.Configuration)configuration);
        }
        catch (Exception e) {
            throw new StartException((Throwable)e);
        }
        try {
            this.connection = client.connectSync((CallbackHandler)new ClientCallbackHandler());
            this.channel = (Channel)this.connection.openChannel("server", OptionMap.EMPTY).get();
        }
        catch (IOException e) {
            throw ServerMessages.MESSAGES.failedToConnectToHC(e);
        }
    }

    public synchronized void stop(StopContext context) {
        StreamUtils.safeClose((Closeable)this.client);
        this.client = null;
        this.channel = null;
    }

    public synchronized Channel getValue() throws IllegalStateException {
        return this.channel;
    }

    private class ClientCallbackHandler
    implements CallbackHandler {
        private ClientCallbackHandler() {
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            for (Callback current : callbacks) {
                if (current instanceof RealmCallback) {
                    RealmCallback rcb = (RealmCallback)current;
                    String defaultText = rcb.getDefaultText();
                    rcb.setText(defaultText);
                    continue;
                }
                if (current instanceof RealmChoiceCallback) {
                    throw new UnsupportedCallbackException(current, "Realm choice not currently supported.");
                }
                if (current instanceof NameCallback) {
                    NameCallback ncb = (NameCallback)current;
                    ncb.setName(HostControllerConnectionService.this.serverName);
                    continue;
                }
                if (current instanceof PasswordCallback) {
                    PasswordCallback pcb = (PasswordCallback)current;
                    pcb.setPassword(new String(HostControllerConnectionService.this.authKey).toCharArray());
                    continue;
                }
                throw new UnsupportedCallbackException(current);
            }
        }
    }
}

