/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server;

import java.security.Permission;
import org.jboss.msc.service.ServiceContainer;

public class CurrentServiceContainer {
    private static final RuntimePermission LOOKUP_CURRENT_SERVICE_CONTAINER = new RuntimePermission("org.jboss.as.server.LOOKUP_CURRENT_SERVICE_CONTAINER");
    private static final RuntimePermission SET_CURRENT_SERVICE_CONTAINER = new RuntimePermission("org.jboss.as.server.SET_CURRENT_SERVICE_CONTAINER");
    private static volatile ServiceContainer serviceContainer;

    public static ServiceContainer getServiceContainer() {
        CurrentServiceContainer.checkPermission(LOOKUP_CURRENT_SERVICE_CONTAINER);
        return serviceContainer;
    }

    static void setServiceContainer(ServiceContainer serviceContainer) {
        CurrentServiceContainer.checkPermission(SET_CURRENT_SERVICE_CONTAINER);
        CurrentServiceContainer.serviceContainer = serviceContainer;
    }

    private static void checkPermission(Permission permission) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(permission);
        }
    }
}

